/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components;

import com.opensymphony.xwork2.util.ValueStack;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.components.UIBean;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;

@StrutsTag(name="datetimepicker", tldTagClass="org.apache.struts2.views.jsp.ui.DateTimePickerTag", description="Render datetimepicker")
public class DateTimePicker
extends UIBean {
    public static final String TEMPLATE = "datetimepicker";
    private static final String RFC3339_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String RFC3339_PATTERN = "{0,date,yyyy-MM-dd'T'HH:mm:ss}";
    protected static final Log LOG = LogFactory.getLog(DateTimePicker.class);
    protected String iconPath;
    protected String formatLength;
    protected String displayFormat;
    protected String toggleType;
    protected String toggleDuration;
    protected String type;
    protected String displayWeeks;
    protected String adjustWeeks;
    protected String startDate;
    protected String endDate;
    protected String weekStartsOn;
    protected String staticDisplay;
    protected String dayWidth;
    protected String language;
    protected String templateCssPath;

    public DateTimePicker(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    protected String getDefaultTemplate() {
        return TEMPLATE;
    }

    public void evaluateParams() {
        super.evaluateParams();
        if (this.displayWeeks != null) {
            this.addParameter("displayWeeks", this.findString(this.displayWeeks));
        }
        if (this.adjustWeeks != null) {
            this.addParameter("adjustWeeks", this.findValue(this.adjustWeeks, Boolean.class));
        }
        if (this.startDate != null) {
            this.addParameter("startDate", this.findString(this.startDate));
        }
        if (this.endDate != null) {
            this.addParameter("endDate", this.findString(this.endDate));
        }
        if (this.weekStartsOn != null) {
            this.addParameter("weekStartsOn", this.findString(this.weekStartsOn));
        }
        if (this.staticDisplay != null) {
            this.addParameter("staticDisplay", this.findValue(this.staticDisplay, Boolean.class));
        }
        if (this.dayWidth != null) {
            this.addParameter("dayWidth", this.findValue(this.dayWidth, Integer.class));
        }
        if (this.language != null) {
            this.addParameter("language", this.findString(this.language));
        }
        if (this.value != null) {
            this.addParameter("value", this.findString(this.value));
        }
        if (this.iconPath != null) {
            this.addParameter("iconPath", this.findString(this.iconPath));
        }
        if (this.formatLength != null) {
            this.addParameter("formatLength", this.findString(this.formatLength));
        }
        if (this.displayFormat != null) {
            this.addParameter("displayFormat", this.findString(this.displayFormat));
        }
        if (this.toggleType != null) {
            this.addParameter("toggleType", this.findString(this.toggleType));
        }
        if (this.toggleDuration != null) {
            this.addParameter("toggleDuration", this.findValue(this.toggleDuration, Integer.class));
        }
        if (this.type != null) {
            this.addParameter("type", this.findString(this.type));
        } else {
            this.addParameter("type", "date");
        }
        if (this.templateCssPath != null) {
            this.addParameter("templateCssPath", this.findString(this.templateCssPath));
        }
        if (this.parameters.containsKey("value")) {
            this.parameters.put("nameValue", this.format(this.parameters.get("value")));
        } else if (this.name != null) {
            String expr = this.name;
            if (this.altSyntax()) {
                expr = "%{" + expr + "}";
            }
            this.addParameter("nameValue", this.format(this.findValue(expr)));
        }
    }

    @StrutsTagAttribute(description="If true, weekly size of calendar changes to acomodate the month if false, 42 day format is used", type="Boolean", defaultValue="false")
    public void setAdjustWeeks(String adjustWeeks) {
        this.adjustWeeks = adjustWeeks;
    }

    @StrutsTagAttribute(description="How to render the names of the days in the header(narrow, abbr or wide)", defaultValue="narrow")
    public void setDayWidth(String dayWidth) {
        this.dayWidth = dayWidth;
    }

    @StrutsTagAttribute(description="Total weeks to display", type="Integer", defaultValue="6")
    public void setDisplayWeeks(String displayWeeks) {
        this.displayWeeks = displayWeeks;
    }

    @StrutsTagAttribute(description="Last available date in the calendar set", type="Date", defaultValue="2941-10-12")
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    @StrutsTagAttribute(description="First available date in the calendar set", type="Date", defaultValue="1492-10-12")
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    @StrutsTagAttribute(description="Disable all incremental controls, must pick a date in the current display", type="Boolean", defaultValue="false")
    public void setStaticDisplay(String staticDisplay) {
        this.staticDisplay = staticDisplay;
    }

    @StrutsTagAttribute(description="Adjusts the first day of the week 0==Sunday..6==Saturday", type="Integer", defaultValue="0")
    public void setWeekStartsOn(String weekStartsOn) {
        this.weekStartsOn = weekStartsOn;
    }

    @StrutsTagAttribute(description="Language to display this widget in", defaultValue="brower's specified preferred language")
    public void setLanguage(String language) {
        this.language = language;
    }

    @StrutsTagAttribute(description="A pattern used for the visual display of the formatted date, e.g. dd/MM/yyyy")
    public void setDisplayFormat(String displayFormat) {
        this.displayFormat = displayFormat;
    }

    @StrutsTagAttribute(description="Type of formatting used for visual display. Possible values are long, short, medium or full", defaultValue="short")
    public void setFormatLength(String formatLength) {
        this.formatLength = formatLength;
    }

    @StrutsTagAttribute(description="Path to icon used for the dropdown")
    public void setIconPath(String iconPath) {
        this.iconPath = iconPath;
    }

    @StrutsTagAttribute(description="Duration of toggle in milliseconds", type="Integer", defaultValue="100")
    public void setToggleDuration(String toggleDuration) {
        this.toggleDuration = toggleDuration;
    }

    @StrutsTagAttribute(description="Defines the type of the picker on the dropdown. Possible values are 'date' for a DateTimePicker, and 'time' for a timePicker", defaultValue="date")
    public void setType(String type) {
        this.type = type;
    }

    @StrutsTagAttribute(description="oggle type of the dropdown. Possible values are plain,wipe,explode,fade", defaultValue="plain")
    public void setToggleType(String toggleType) {
        this.toggleType = toggleType;
    }

    @StrutsTagAttribute(description="Template css path")
    public void setTemplateCssPath(String templateCssPath) {
        this.templateCssPath = templateCssPath;
    }

    private String format(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            return MessageFormat.format(RFC3339_PATTERN, (Date)obj);
        }
        if (obj instanceof Calendar) {
            return MessageFormat.format(RFC3339_PATTERN, ((Calendar)obj).getTime());
        }
        String dateStr = obj.toString();
        if (dateStr.equalsIgnoreCase("today")) {
            return MessageFormat.format(RFC3339_PATTERN, new Date());
        }
        try {
            Date date = null;
            if (this.displayFormat != null) {
                SimpleDateFormat format = new SimpleDateFormat((String)this.getParameters().get("displayFormat"));
                date = format.parse(dateStr);
                return MessageFormat.format(RFC3339_PATTERN, date);
            }
            return dateStr;
        }
        catch (ParseException e) {
            LOG.error((Object)"Could not parse date", (Throwable)e);
            return dateStr;
        }
    }
}

