package news.database;

import java.io.*;
import java.sql.*;
import java.util.*;
import java.util.Date;

public class DBConnectionManager {
 static private DBConnectionManager instance; // Ψһʵ
 static private int clients;

 private Vector drivers = new Vector();
 private PrintWriter log;
 private Hashtable pools = new Hashtable();

 /**
  * Ψһʵ.ǵһεô˷,򴴽ʵ
  *
  * @return DBConnectionManager Ψһʵ
  */
 static synchronized public DBConnectionManager getInstance() {
   if (instance == null) {
     instance = new DBConnectionManager();
   }
   clients++;
   return instance;
 }

 /**
  * ˽Էֹ󴴽ʵ
  */
 private DBConnectionManager() {
   init();
 }

 /**
  * Ӷ󷵻ظָӳ
  *
  * @param name ļжӳ
  * @param con Ӷ
  */
 public void freeConnection(String name, Connection con) {
   DBConnectionPool pool = (DBConnectionPool) pools.get(name);
   if (pool != null) {
     pool.freeConnection(con);
   }
 }

 /**
  * һõ(е).ûп,С
  * ,򴴽
  *
  * @param name ļжӳ
  * @return Connection ӻnull
  */
 public Connection getConnection(String name) {
   DBConnectionPool pool = (DBConnectionPool) pools.get(name);
   if (pool != null) {
     return pool.getConnection();
   }
   return null;
 }

 /**
  * һ.ûп,С,
  * 򴴽.,ָʱڵȴ߳ͷ.
  *
  * @param name ӳ
  * @param time ԺƵĵȴʱ
  * @return Connection ӻnull
  */
 public Connection getConnection(String name, long time) {
   DBConnectionPool pool = (DBConnectionPool) pools.get(name);
   if (pool != null) {
     return pool.getConnection(time);
   }
   return null;
 }

 /**
  * ر,ע
  */
 public synchronized void release() {
   // ȴֱһͻ
   if (--clients != 0) {
     return;
   }

   Enumeration allPools = pools.elements();
   while (allPools.hasMoreElements()) {
     DBConnectionPool pool = (DBConnectionPool) allPools.nextElement();
     pool.release();
   }
   Enumeration allDrivers = drivers.elements();
   while (allDrivers.hasMoreElements()) {
     Driver driver = (Driver) allDrivers.nextElement();
     try {
       DriverManager.deregisterDriver(driver);
       log("JDBC " + driver.getClass().getName()+"ע");
     }
     catch (SQLException e) {
       log(e, "޷JDBCע: " + driver.getClass().getName());
     }
   }
 }

 /**
  * ָԴӳʵ.
  *
  * @param props ӳ
  */
 private void createPools(Properties props) {
   Enumeration propNames = props.propertyNames();
   while (propNames.hasMoreElements()) {
   String name = (String) propNames.nextElement();
   if (name.endsWith(".url")) {
     String poolName = name.substring(0, name.lastIndexOf("."));
     String url = props.getProperty(poolName + ".url");
     if (url == null) {
       log("ûΪӳ" + poolName + "ָURL");
       continue;
     }
   String user = props.getProperty(poolName + ".user");
   String password = props.getProperty(poolName + ".password");
   String maxconn = props.getProperty(poolName + ".maxconn", "0");
   int max;
   try {
   max = Integer.valueOf(maxconn).intValue();
   }
   catch (NumberFormatException e) {
     log(": " + maxconn + " .ӳ: " + poolName);
     max = 0;
   }
   DBConnectionPool pool = new DBConnectionPool(poolName, url, user, password, max);
   pools.put(poolName, pool);
   log("ɹӳ" + poolName);
  }
 }
 }

 /**
  * ȡɳʼ
  */
  private void init() {
  InputStream is = getClass().getResourceAsStream("/news.txt");
  Properties dbProps = new Properties();
  try {
    dbProps.load(is);
  }
  catch (Exception e) {
    System.err.println("ܶȡļ. " +
   "ȷdb.propertiesCLASSPATHָ·");
    return;
  }
  String logFile = dbProps.getProperty("logfile", "newslog.txt");
  try {
    log = new PrintWriter(new FileWriter(logFile, true), true);
  }
  catch (IOException e) {
    System.err.println("޷־ļ: " + logFile);
    log = new PrintWriter(System.err);
  }
  loadDrivers(dbProps);
  createPools(dbProps);
 }

 /**
  * װغעJDBC
  *
  * @param props 
  */
 private void loadDrivers(Properties props) {
   String driverClasses = props.getProperty("driver");
   StringTokenizer st = new StringTokenizer(driverClasses);
   while (st.hasMoreElements()) {
   String driverClassName = st.nextToken().trim();
   try {
     Driver driver = (Driver)
     Class.forName(driverClassName).newInstance();
     DriverManager.registerDriver(driver);
     drivers.addElement(driver);
     log("ɹעJDBC" + driverClassName);
   }
   catch (Exception e) {
     log("޷עJDBC: " +
     driverClassName + ", : " + e);
   }
 }
 }

 /**
  * ıϢд־ļ
  */
 private void log(String msg) {
//   log.println(new Date() + ": " + msg);
 }

 /**
  * ıϢ쳣д־ļ
  */
 private void log(Throwable e, String msg) {
  // log.println(new Date() + ": " + msg);
  // e.printStackTrace(log);
 }

 /**
  * ڲඨһӳ.ܹҪ󴴽,ֱԤ
  * Ϊֹ.ڷӸͻ֮ǰ,ܹ֤ӵЧ.
  */
 class DBConnectionPool {
   private int checkedOut;
   private Vector freeConnections = new Vector();
   private int maxConn;
   private String name;
   private String password;
   private String URL;
   private String user;
   private String databaseUrl;

 /**
  * µӳ
  *
  * @param name ӳ
  * @param URL ݿJDBC URL
  * @param user ݿʺ, null
  * @param password , null
  * @param maxConn ӳ
  */
 public DBConnectionPool(String name, String URL, String user, String password, int maxConn) {
   this.name = name;
   this.URL = URL;
   this.user = user;
   this.password = password;
   this.maxConn = maxConn;
   }

  /**
   * ʹõӷظӳ
   *
   * @param con ͻͷŵ
   */
 public synchronized void freeConnection(Connection con) {
   // ָӼ뵽ĩβ
   freeConnections.addElement(con);
   checkedOut--;
   notifyAll();
 }

 /**
  * ӳػһ.ûпеҵǰС
  * ,򴴽.ԭǼΪõӲЧ,ɾ֮,
  * ȻݹԼԳµĿ.
  */
 public synchronized Connection getConnection() {
   Connection con = null;
   if (freeConnections.size() > 0) {
     // ȡеһ
     con = (Connection) freeConnections.firstElement();
     freeConnections.removeElementAt(0);
     try {
       if (con.isClosed()) {
         log("ӳ" + name+"ɾһЧ");
         // ݹԼ,ٴλȡ
         con = getConnection();
       }
     }
     catch (SQLException e) {
       log("ӳ" + name+"ɾһЧ");
       // ݹԼ,ٴλȡ
       con = getConnection();
     }
    }
    else if (maxConn == 0 || checkedOut < maxConn) {
con = newConnection();
}
if (con != null) {
checkedOut++;
}
return con;
}

/**
* ӳػȡ.ָͻܹȴʱ
* μǰһgetConnection().
*
* @param timeout ԺƵĵȴʱ
*/
public synchronized Connection getConnection(long timeout) {
long startTime = new Date().getTime();
Connection con;
while ((con = getConnection()) == null) {
try {
wait(timeout);
}
catch (InterruptedException e) {}
if ((new Date().getTime() - startTime) >= timeout) {
        // wait()صԭǳʱ
        return null;
      }
    }
    return con;
  }

 /**
  * ر
  */
 public synchronized void release() {
   Enumeration allConnections = freeConnections.elements();
   while (allConnections.hasMoreElements()) {
     Connection con = (Connection) allConnections.nextElement();
     try {
       con.close();
       log("رӳ" + name+"еһ");
     }
     catch (SQLException e) {
       log(e, "޷رӳ" + name+"е");
     }
   }
   freeConnections.removeAllElements();
 }

 /**
  * µ
  */
 private Connection newConnection() {
 Connection con = null; 
 try { 
 if (user == null) { 
 con = DriverManager.getConnection(URL); 
 } 
 else { 
 con = DriverManager.getConnection(URL, user, password); 
 } 
 log("ӳ" + name+"һµ"); 
 } 
 catch (SQLException e) { 
 log(e, "޷URL: " + URL); 
 return null; 
 } 
 return con; 
 } 
 

 }
 }
