/*
 * Decompiled with CFR 0.152.
 */
package com.ntsky.database;

import com.ntsky.common.Debug;
import com.ntsky.database.DBOperator;
import com.ntsky.pool.DBConnectionManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class SQLDBOperator
extends DBOperator {
    private DBConnectionManager conManager;
    private String poolName;
    private PreparedStatement prepstmt = null;
    private Connection conn;
    private static SQLDBOperator instance;

    private SQLDBOperator(String strKey) {
        this.poolName = strKey;
        this.conManager = DBConnectionManager.getInstance();
        this.conn = this.conManager.getConnection(strKey);
    }

    public void Close() {
        try {
            this.conManager.freeConnection(this.poolName, this.conn);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void executeUpdate(String strSql) {
        try {
            strSql = new String(strSql.getBytes("GBK"), "ISO8859_1");
            Statement stmt = this.conn.createStatement();
            stmt.executeUpdate(strSql);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            Debug.writeLog("In executeUpdate(String), Exception Occured ! Info :" + e.getLocalizedMessage());
        }
    }

    public ResultSet executeQuery(String strSql) {
        ResultSet rs = null;
        try {
            strSql = new String(strSql.getBytes("GBK"), "ISO8859_1");
            Statement stmt = this.conn.createStatement();
            rs = stmt.executeQuery(strSql);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            Debug.writeLog("In executeQuery(String), Exception Occured ! Info :" + e.getLocalizedMessage());
        }
        return rs;
    }

    public void prepareStatement(String strSql) {
        try {
            this.prepstmt = this.conn.prepareStatement(strSql);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            Debug.writeLog("In prepareStatement(String strSql), Exception Occured ! Info :" + e.getLocalizedMessage());
        }
    }

    public void setString(int index, String value) {
        try {
            value = new String(value.getBytes("GBK"), "ISO8859_1");
            this.prepstmt.setString(index, value);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            Debug.writeLog("In setString(int index,String value), Exception Occured ! Info :" + e.getLocalizedMessage());
        }
    }

    public void setInt(int index, int value) {
        try {
            this.prepstmt.setInt(index, value);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            Debug.writeLog("In setInt(int index,int value), Exception Occured ! Info :" + e.getLocalizedMessage());
        }
    }

    public void clearParameters() {
        try {
            this.prepstmt.clearParameters();
            this.prepstmt = null;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            Debug.writeLog("In clearParameters(), Exception Occured ! Info :" + e.getLocalizedMessage());
        }
    }

    public PreparedStatement getPreparedStatement() {
        return this.prepstmt;
    }

    public void executeUpdate() {
        try {
            if (this.prepstmt != null) {
                this.prepstmt.executeUpdate();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            Debug.writeLog("In executeUpdate(String), Exception Occured ! Info :" + e.getLocalizedMessage());
        }
    }

    public ResultSet executeQuery() {
        ResultSet rs = null;
        try {
            if (this.prepstmt != null) {
                rs = this.prepstmt.executeQuery();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            Debug.writeLog("In executeQuery(String), Exception Occured ! Info :" + e.getLocalizedMessage());
        }
        return rs;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public static SQLDBOperator getInstance(String strKey) {
        if (instance == null) {
            instance = new SQLDBOperator(strKey);
        }
        return instance;
    }
}

