/*
 * Decompiled with CFR 0.152.
 */
package com.ntsky.news.manage;

import com.ntsky.common.CodeFilter;
import com.ntsky.common.Debug;
import com.ntsky.database.SQLDBOperator;
import com.ntsky.persistence.NEWSKind;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;

public class Kind {
    private SQLDBOperator sdbo = null;

    public boolean isNullKind(int classId) {
        boolean isNull = false;
        if (this.sdbo == null) {
            this.sdbo = SQLDBOperator.getInstance("Connection");
        }
        ResultSet rs = null;
        String Sql = "select kindId from newskind where classId=?;";
        this.sdbo.prepareStatement(Sql);
        this.sdbo.setInt(1, classId);
        rs = this.sdbo.executeQuery();
        try {
            rs.last();
            if (rs.getRow() > 0) {
                isNull = true;
                rs.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            Debug.writeLog("Kind inNullKind(), Exception Occured ! Info :" + e.getLocalizedMessage());
        }
        this.sdbo.Close();
        return isNull;
    }

    public Iterator allKind() {
        ResultSet rs = null;
        if (this.sdbo == null) {
            this.sdbo = SQLDBOperator.getInstance("Connection");
        }
        Vector<NEWSKind> vector = new Vector<NEWSKind>();
        String Sql = "select kindId,content,classId from newskind;";
        rs = this.sdbo.executeQuery(Sql);
        try {
            while (rs.next()) {
                NEWSKind tableKind = new NEWSKind();
                tableKind.setKindId(rs.getInt("kindId"));
                tableKind.setContent(rs.getString("content"));
                tableKind.setClassId(rs.getInt("classId"));
                vector.add(tableKind);
            }
            rs.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            Debug.writeLog("Kind getKind(), Exception Occured ! Info :" + e.getLocalizedMessage());
        }
        this.sdbo.Close();
        return vector.iterator();
    }

    public Iterator getKind(int classId) {
        ResultSet rs = null;
        if (this.sdbo == null) {
            this.sdbo = SQLDBOperator.getInstance("Connection");
        }
        Vector<NEWSKind> vector = new Vector<NEWSKind>();
        String Sql = "select kindId,content,classId from newskind where classId=?;";
        this.sdbo.prepareStatement(Sql);
        this.sdbo.setInt(1, classId);
        rs = this.sdbo.executeQuery();
        try {
            while (rs.next()) {
                NEWSKind tableKind = new NEWSKind();
                tableKind.setKindId(rs.getInt("kindId"));
                tableKind.setContent(rs.getString("content"));
                tableKind.setClassId(rs.getInt("classId"));
                vector.add(tableKind);
            }
            rs.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            Debug.writeLog("Kind getKind(), Exception Occured ! Info :" + e.getLocalizedMessage());
        }
        this.sdbo.Close();
        return vector.iterator();
    }

    public void insKind(String content, int classId) throws SQLException {
        if (this.sdbo == null) {
            this.sdbo = SQLDBOperator.getInstance("Connection");
        }
        String sql = "insert into newskind(content,classId) values(?,?);";
        this.sdbo.prepareStatement(sql);
        this.sdbo.setString(1, CodeFilter.toHtml(content));
        this.sdbo.setInt(2, classId);
        this.sdbo.executeUpdate();
        this.sdbo.Close();
    }

    public void delKind(int kindId) throws SQLException {
        if (this.sdbo == null) {
            this.sdbo = SQLDBOperator.getInstance("Connection");
        }
        String sql_kind = "delete from newskind where kindId=?;";
        String sql_news = "delete from news where kindId=?;";
        String sql_news_newsId = "select newsId from news where kindId=?";
        String sql_reply = "delete from newsreply where newsId=?;";
        this.sdbo.prepareStatement(sql_kind);
        this.sdbo.setInt(1, kindId);
        this.sdbo.executeUpdate();
        this.sdbo.prepareStatement(sql_news);
        this.sdbo.setInt(1, kindId);
        this.sdbo.executeUpdate();
        this.sdbo.prepareStatement(sql_news_newsId);
        this.sdbo.setInt(1, kindId);
        ResultSet rs = this.sdbo.executeQuery();
        this.sdbo.prepareStatement(sql_reply);
        while (rs.next()) {
            int newsId = rs.getInt("newsId");
            this.sdbo.setInt(1, newsId);
            this.sdbo.executeUpdate();
        }
        this.sdbo.Close();
    }

    public Iterator editKind(int kindId) {
        if (this.sdbo == null) {
            this.sdbo = SQLDBOperator.getInstance("Connection");
        }
        String sql = "select * from newskind where kindId=?";
        Vector<NEWSKind> vector = new Vector<NEWSKind>();
        try {
            this.sdbo.prepareStatement(sql);
            this.sdbo.setInt(1, kindId);
            ResultSet rs = this.sdbo.executeQuery();
            while (rs.next()) {
                NEWSKind tableKind = new NEWSKind();
                tableKind.setContent(rs.getString("content"));
                tableKind.setClassId(rs.getInt("classId"));
                vector.add(tableKind);
            }
        }
        catch (Exception e) {
            Debug.writeLog("Kind editKind(), Exception Occured ! Info :" + e.getLocalizedMessage());
        }
        this.sdbo.Close();
        return vector.iterator();
    }

    public void upKind(int classId, String content, int kindId) throws Exception {
        if (this.sdbo == null) {
            this.sdbo = SQLDBOperator.getInstance("Connection");
        }
        String sql = "update newskind set classId=?,content=? where kindId=?;";
        this.sdbo.prepareStatement(sql);
        this.sdbo.setInt(1, classId);
        this.sdbo.setString(2, CodeFilter.toHtml(content));
        this.sdbo.setInt(3, kindId);
        this.sdbo.executeUpdate();
        this.sdbo.Close();
    }
}

