/*
 * Decompiled with CFR 0.152.
 */
package com.ntsky.news.manage;

import com.ntsky.common.CodeFilter;
import com.ntsky.common.DateUtil;
import com.ntsky.common.Debug;
import com.ntsky.database.SQLDBOperator;
import com.ntsky.persistence.NEWSReply;
import com.ntsky.persistence.NEWSTable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;

public class News {
    private SQLDBOperator sdbo = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insNews(int classId, int kindId, int myOther, String headTitle, String content, String connect, String author, String editor, String newsFrom, int top) {
        if (this.sdbo == null) {
            this.sdbo = SQLDBOperator.getInstance("Connection");
        }
        String sql = "insert into news(classId,kindId,myOther,headTitle,content,connect,author,editor,newsFrom,top,newsTime,state,tag) values(?,?,?,?,?,?,?,?,?,?,?,1,1);";
        try {
            try {
                this.sdbo.prepareStatement(sql);
                this.sdbo.setInt(1, classId);
                this.sdbo.setInt(2, kindId);
                this.sdbo.setInt(3, myOther);
                this.sdbo.setString(4, CodeFilter.toHtml(headTitle));
                this.sdbo.setString(5, CodeFilter.toHtml(content));
                this.sdbo.setString(6, CodeFilter.toHtml(connect));
                this.sdbo.setString(7, CodeFilter.toHtml(author));
                this.sdbo.setString(8, CodeFilter.toHtml(editor));
                this.sdbo.setString(9, CodeFilter.toHtml(newsFrom));
                this.sdbo.setInt(10, top);
                this.sdbo.setString(11, DateUtil.getNowDate());
                this.sdbo.executeUpdate();
            }
            catch (Exception sqlE) {
                System.out.print("News insNews() " + sqlE.getMessage());
                Debug.writeLog("News insNews(), Exception Occured ! Info :" + sqlE.getLocalizedMessage());
                Object var14_13 = null;
                this.sdbo.Close();
            }
            Object var14_12 = null;
            this.sdbo.Close();
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            this.sdbo.Close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insUbbNews(int classId, int kindId, int myOther, String headTitle, String content, String connect, String author, String editor, String newsFrom, int top) {
        if (this.sdbo == null) {
            this.sdbo = SQLDBOperator.getInstance("Connection");
        }
        String sql = "insert into news(classId,kindId,myOther,headTitle,content,connect,author,editor,newsFrom,top,newsTime,state,tag) values(?,?,?,?,?,?,?,?,?,?,?,1,1);";
        try {
            try {
                this.sdbo.prepareStatement(sql);
                this.sdbo.setInt(1, classId);
                this.sdbo.setInt(2, kindId);
                this.sdbo.setInt(3, myOther);
                this.sdbo.setString(4, CodeFilter.toHtml(headTitle));
                this.sdbo.setString(5, CodeFilter.toUbbHtml(content));
                this.sdbo.setString(6, CodeFilter.toHtml(connect));
                this.sdbo.setString(7, CodeFilter.toHtml(author));
                this.sdbo.setString(8, CodeFilter.toHtml(editor));
                this.sdbo.setString(9, CodeFilter.toHtml(newsFrom));
                this.sdbo.setInt(10, top);
                this.sdbo.setString(11, DateUtil.getNowDate());
                this.sdbo.executeUpdate();
            }
            catch (Exception sqlE) {
                System.out.print("News insNews() " + sqlE.getMessage());
                Debug.writeLog("News insNews(), Exception Occured ! Info :" + sqlE.getLocalizedMessage());
                Object var14_13 = null;
                this.sdbo.Close();
            }
            Object var14_12 = null;
            this.sdbo.Close();
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            this.sdbo.Close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator listNews() {
        Vector<NEWSTable> vector = new Vector<NEWSTable>();
        if (this.sdbo == null) {
            this.sdbo = SQLDBOperator.getInstance("Connection");
        }
        String sql = "select newsId,headTitle,DATE_FORMAT(newsTime,'%Y-%m-%d') as time,hits from news where state=1 order by newsTime desc;";
        try {
            try {
                ResultSet rs = this.sdbo.executeQuery(sql);
                try {
                    while (rs.next()) {
                        NEWSTable tableNews = new NEWSTable();
                        tableNews.setNewsId(rs.getInt("newsId"));
                        tableNews.setHeadTitle(rs.getString("headTitle"));
                        tableNews.setNewsTime(rs.getString("time"));
                        tableNews.setHits(rs.getInt("hits"));
                        vector.add(tableNews);
                    }
                    rs.close();
                }
                catch (NullPointerException nullE) {
                    System.out.println("News istNews() :" + nullE.getMessage());
                    Debug.writeLog("News istNews(), Exception Occured ! Info :" + nullE.getLocalizedMessage());
                }
                Object var6_7 = null;
                this.sdbo.Close();
            }
            catch (SQLException sqlE) {
                System.out.println("News istNews() :" + sqlE.getMessage());
                Debug.writeLog("News istNews(), Exception Occured ! Info :" + sqlE.getLocalizedMessage());
                Object var6_8 = null;
                this.sdbo.Close();
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.sdbo.Close();
            throw throwable;
        }
        return vector.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sumNews() {
        if (this.sdbo == null) {
            this.sdbo = SQLDBOperator.getInstance("Connection");
        }
        int sum = 0;
        String sql = "select count(newsId) as total from news where state=1;";
        try {
            try {
                ResultSet rs = this.sdbo.executeQuery(sql);
                try {
                    rs.next();
                    sum = rs.getInt("total");
                    rs.close();
                }
                catch (NullPointerException nullE) {
                    System.out.println("News sumNews() :" + nullE.getMessage());
                    Debug.writeLog("News sumNews(), Exception Occured ! Info :" + nullE.getLocalizedMessage());
                }
                Object var6_6 = null;
                this.sdbo.Close();
            }
            catch (SQLException sqlE) {
                System.out.println("News sumNews() :" + sqlE.getMessage());
                Debug.writeLog("News sumNews(), Exception Occured ! Info :" + sqlE.getLocalizedMessage());
                Object var6_7 = null;
                this.sdbo.Close();
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.sdbo.Close();
            throw throwable;
        }
        return sum;
    }

    public int sumSearchNews(String search) {
        String strSearch = CodeFilter.toHtml(search);
        if (this.sdbo == null) {
            this.sdbo = SQLDBOperator.getInstance("Connection");
        }
        String sql = "select count(newsId) as total from news where state=1 and headTitle like '%" + strSearch + "%';";
        int total = 0;
        try {
            ResultSet rs = this.sdbo.executeQuery(sql);
            rs.next();
            total = rs.getInt("total");
            rs.close();
        }
        catch (Exception e) {
            System.out.print("News sumNews() " + e.getMessage());
            Debug.writeLog("News sumNews(), Exception Occured ! Info :" + e.getLocalizedMessage());
        }
        this.sdbo.Close();
        return total;
    }

    public Iterator searchNews(String search) {
        String strSearch = CodeFilter.toHtml(search);
        Vector<NEWSTable> vector = new Vector<NEWSTable>();
        if (this.sdbo == null) {
            this.sdbo = SQLDBOperator.getInstance("Connection");
        }
        String sql = "select newsId,headTitle,DATE_FORMAT(newsTime,'%Y-%m-%d') as time,hits from news where state=1 and headTitle like '%" + strSearch + "%';";
        try {
            ResultSet rs = this.sdbo.executeQuery(sql);
            while (rs.next()) {
                NEWSTable tableNews = new NEWSTable();
                tableNews.setNewsId(rs.getInt("newsId"));
                tableNews.setHeadTitle(rs.getString("headTitle"));
                tableNews.setNewsTime(rs.getString("time"));
                tableNews.setHits(rs.getInt("hits"));
                vector.add(tableNews);
            }
            rs.close();
        }
        catch (Exception e) {
            System.out.print("News searchNews() " + e.getMessage());
            Debug.writeLog("News searchNews(), Exception Occured ! Info :" + e.getLocalizedMessage());
        }
        this.sdbo.Close();
        return vector.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator editNews(int newsId) {
        Vector<NEWSTable> vector = new Vector<NEWSTable>();
        if (this.sdbo == null) {
            this.sdbo = SQLDBOperator.getInstance("Connection");
        }
        String sql = "select * from news where newsId=?;";
        try {
            try {
                this.sdbo.prepareStatement(sql);
                this.sdbo.setInt(1, newsId);
                ResultSet rs = this.sdbo.executeQuery();
                while (rs.next()) {
                    NEWSTable tableNews = new NEWSTable();
                    tableNews.setClassId(rs.getInt("classId"));
                    tableNews.setKindId(rs.getInt("kindId"));
                    tableNews.setMyOther(rs.getInt("myOther"));
                    tableNews.setHeadTitle(CodeFilter.unHtml(rs.getString("headTitle")));
                    tableNews.setContent(CodeFilter.unHtml(rs.getString("content")));
                    tableNews.setConnect(CodeFilter.unHtml(rs.getString("connect")));
                    tableNews.setAuthor(rs.getString("author"));
                    tableNews.setEditor(rs.getString("editor"));
                    tableNews.setNewsFrom(rs.getString("newsFrom"));
                    tableNews.setTop(rs.getInt("top"));
                    vector.add(tableNews);
                }
                rs.close();
            }
            catch (Exception e) {
                System.out.print("News editNews() " + e.getMessage());
                Debug.writeLog("News editNews(), Exception Occured ! Info :" + e.getLocalizedMessage());
                Object var7_8 = null;
                this.sdbo.Close();
            }
            Object var7_7 = null;
            this.sdbo.Close();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.sdbo.Close();
            throw throwable;
        }
        return vector.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upNews(int classId, int kindId, int myOther, String headTitle, String content, String connect, String author, String editor, String newsFrom, int top, int newsId) {
        if (this.sdbo == null) {
            this.sdbo = SQLDBOperator.getInstance("Connection");
        }
        String sql = "update news set classId=?,kindId=?,myOther=?,headTitle=?,content=?,connect=?,author=?,editor=?,newsFrom=?,top=? where newsId=?;";
        try {
            try {
                this.sdbo.prepareStatement(sql);
                this.sdbo.setInt(1, classId);
                this.sdbo.setInt(2, kindId);
                this.sdbo.setInt(3, myOther);
                this.sdbo.setString(4, CodeFilter.toHtml(headTitle));
                this.sdbo.setString(5, CodeFilter.toHtml(content));
                this.sdbo.setString(6, CodeFilter.toHtml(connect));
                this.sdbo.setString(7, CodeFilter.toHtml(author));
                this.sdbo.setString(8, CodeFilter.toHtml(editor));
                this.sdbo.setString(9, CodeFilter.toHtml(newsFrom));
                this.sdbo.setInt(10, top);
                this.sdbo.setInt(11, newsId);
                this.sdbo.executeUpdate();
            }
            catch (Exception e) {
                System.out.print("News upNews() " + e.getMessage());
                Debug.writeLog("News upNews(), Exception Occured ! Info :" + e.getLocalizedMessage());
                Object var15_14 = null;
                this.sdbo.Close();
            }
            Object var15_13 = null;
            this.sdbo.Close();
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            this.sdbo.Close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upUbbNews(int classId, int kindId, int myOther, String headTitle, String content, String connect, String author, String editor, String newsFrom, int top, int newsId) {
        if (this.sdbo == null) {
            this.sdbo = SQLDBOperator.getInstance("Connection");
        }
        String sql = "update news set classId=?,kindId=?,myOther=?,headTitle=?,content=?,connect=?,author=?,editor=?,newsFrom=?,top=? where newsId=?;";
        try {
            try {
                this.sdbo.prepareStatement(sql);
                this.sdbo.setInt(1, classId);
                this.sdbo.setInt(2, kindId);
                this.sdbo.setInt(3, myOther);
                this.sdbo.setString(4, CodeFilter.toHtml(headTitle));
                this.sdbo.setString(5, CodeFilter.toUbbHtml(content));
                this.sdbo.setString(6, CodeFilter.toHtml(connect));
                this.sdbo.setString(7, CodeFilter.toHtml(author));
                this.sdbo.setString(8, CodeFilter.toHtml(editor));
                this.sdbo.setString(9, CodeFilter.toHtml(newsFrom));
                this.sdbo.setInt(10, top);
                this.sdbo.setInt(11, newsId);
                this.sdbo.executeUpdate();
            }
            catch (Exception e) {
                System.out.print("News upNews() " + e.getMessage());
                Debug.writeLog("News upNews(), Exception Occured ! Info :" + e.getLocalizedMessage());
                Object var15_14 = null;
                this.sdbo.Close();
            }
            Object var15_13 = null;
            this.sdbo.Close();
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            this.sdbo.Close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delNews(int newsId) {
        if (this.sdbo == null) {
            this.sdbo = SQLDBOperator.getInstance("Connection");
        }
        String sql = "delete from news where newsId=?;";
        try {
            try {
                this.sdbo.prepareStatement(sql);
                this.sdbo.setInt(1, newsId);
                this.sdbo.executeUpdate();
            }
            catch (Exception e) {
                System.out.print("News delNews() " + e.getMessage());
                Debug.writeLog("News delNews(), Exception Occured ! Info :" + e.getLocalizedMessage());
                Object var5_4 = null;
                this.sdbo.Close();
            }
            Object var5_3 = null;
            this.sdbo.Close();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.sdbo.Close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator listShNews() {
        Vector<NEWSTable> vector = new Vector<NEWSTable>();
        if (this.sdbo == null) {
            this.sdbo = SQLDBOperator.getInstance("Connection");
        }
        ResultSet rs = null;
        String strSql = "select newsId,headTitle,author,DATE_FORMAT(newsTime,'%Y-%m-%d') as time from news where state=0;";
        try {
            try {
                rs = this.sdbo.executeQuery(strSql);
                try {
                    while (rs.next()) {
                        NEWSTable tableNews = new NEWSTable();
                        tableNews.setNewsId(rs.getInt("newsId"));
                        tableNews.setHeadTitle(rs.getString("headTitle"));
                        tableNews.setAuthor(rs.getString("author"));
                        tableNews.setNewsTime(rs.getString("time"));
                        vector.add(tableNews);
                    }
                    rs.close();
                }
                catch (NullPointerException nullE) {
                    System.out.print("News listShNews() " + nullE.getMessage());
                    Debug.writeLog("News listShNews(), Exception Occured ! Info :" + nullE.getLocalizedMessage());
                }
                Object var6_7 = null;
                this.sdbo.Close();
            }
            catch (SQLException sqlE) {
                System.out.print("News listShNews() " + sqlE.getMessage());
                Debug.writeLog("News listShNews(), Exception Occured ! Info :" + sqlE.getLocalizedMessage());
                Object var6_8 = null;
                this.sdbo.Close();
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.sdbo.Close();
            throw throwable;
        }
        return vector.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sumShNews() {
        if (this.sdbo == null) {
            this.sdbo = SQLDBOperator.getInstance("Connection");
        }
        int sum = 0;
        String sql = "select count(newsId) as total from news where state=0;";
        try {
            try {
                ResultSet rs = this.sdbo.executeQuery(sql);
                try {
                    rs.next();
                    sum = rs.getInt("total");
                    rs.close();
                }
                catch (NullPointerException nullE) {
                    System.out.println("News sumNews() :" + nullE.getMessage());
                    Debug.writeLog("News sumNews(), Exception Occured ! Info :" + nullE.getLocalizedMessage());
                }
                Object var6_6 = null;
                this.sdbo.Close();
            }
            catch (SQLException sqlE) {
                System.out.println("News sumNews() :" + sqlE.getMessage());
                Debug.writeLog("News sumNews(), Exception Occured ! Info :" + sqlE.getLocalizedMessage());
                Object var6_7 = null;
                this.sdbo.Close();
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.sdbo.Close();
            throw throwable;
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shNews(int newsId) {
        if (this.sdbo == null) {
            this.sdbo = SQLDBOperator.getInstance("Connection");
        }
        String strSql = "update news set state=1 where newsId='" + newsId + "'";
        try {
            try {
                this.sdbo.executeUpdate(strSql);
            }
            catch (Exception e) {
                System.out.print("News listShNews() " + e.getMessage());
                Debug.writeLog("News listShNews(), Exception Occured ! Info :" + e.getLocalizedMessage());
                Object var5_4 = null;
                this.sdbo.Close();
            }
            Object var5_3 = null;
            this.sdbo.Close();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.sdbo.Close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTalk() {
        ResultSet rs = null;
        String strSql = "select replyId from newsreply";
        boolean isTalk = false;
        if (this.sdbo == null) {
            this.sdbo = SQLDBOperator.getInstance("Connection");
        }
        try {
            try {
                rs = this.sdbo.executeQuery(strSql);
                try {
                    rs.last();
                    if (rs.getRow() > 0) {
                        isTalk = true;
                    }
                    rs.close();
                }
                catch (NullPointerException nullE) {
                    System.out.print("News isTalk() " + nullE.getMessage());
                    Debug.writeLog("News isTalk(), Exception Occured ! Info :" + nullE.getLocalizedMessage());
                }
                Object var6_6 = null;
                this.sdbo.Close();
            }
            catch (SQLException sqlE) {
                System.out.print("Usr isAdminName() " + sqlE.getMessage());
                Debug.writeLog("Usr isAdminName(), Exception Occured ! Info :" + sqlE.getLocalizedMessage());
                Object var6_7 = null;
                this.sdbo.Close();
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.sdbo.Close();
            throw throwable;
        }
        return isTalk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sumReplyNews() {
        if (this.sdbo == null) {
            this.sdbo = SQLDBOperator.getInstance("Connection");
        }
        int sum = 0;
        String sql = "select distinct news.newsId from news,newsreply where news.newsId=newsreply.newsId;";
        try {
            try {
                ResultSet rs = this.sdbo.executeQuery(sql);
                try {
                    rs.next();
                    sum = rs.getInt("totalNews");
                    rs.close();
                }
                catch (NullPointerException nullE) {
                    System.out.println("News sumReplyNews() :" + nullE.getMessage());
                    Debug.writeLog("News sumReplyNews(), Exception Occured ! Info :" + nullE.getLocalizedMessage());
                }
                Object var6_6 = null;
                this.sdbo.Close();
            }
            catch (SQLException sqlE) {
                System.out.println("News sumReplyNews() :" + sqlE.getMessage());
                Debug.writeLog("News sumReplyNews(), Exception Occured ! Info :" + sqlE.getLocalizedMessage());
                Object var6_7 = null;
                this.sdbo.Close();
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.sdbo.Close();
            throw throwable;
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator listReplyNews() {
        ResultSet rs = null;
        String strSql = "select distinct news.newsId,news.headTitle,DATE_FORMAT(news.newsTime,'%Y-%m-%d') as time from news,newsreply where news.newsId=newsreply.newsId;";
        Vector<NEWSTable> vector = new Vector<NEWSTable>();
        if (this.sdbo == null) {
            this.sdbo = SQLDBOperator.getInstance("Connection");
        }
        try {
            try {
                rs = this.sdbo.executeQuery(strSql);
                try {
                    while (rs.next()) {
                        NEWSTable tableNews = new NEWSTable();
                        tableNews.setNewsId(rs.getInt("newsId"));
                        tableNews.setHeadTitle(rs.getString("headTitle"));
                        tableNews.setNewsTime(rs.getString("time"));
                        vector.add(tableNews);
                        rs.close();
                    }
                }
                catch (NullPointerException nullE) {
                    System.out.print("News listReplyNews() " + nullE.getMessage());
                    Debug.writeLog("News listReplyNews(), Exception Occured ! Info :" + nullE.getLocalizedMessage());
                }
                Object var6_7 = null;
                this.sdbo.Close();
            }
            catch (SQLException sqlE) {
                System.out.print("Usr isAdminName() " + sqlE.getMessage());
                Debug.writeLog("Usr isAdminName(), Exception Occured ! Info :" + sqlE.getLocalizedMessage());
                Object var6_8 = null;
                this.sdbo.Close();
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.sdbo.Close();
            throw throwable;
        }
        return vector.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sumReply(int newsId) {
        ResultSet rs = null;
        int sum = 0;
        String strSql = "select count(replyId) as total from newsreply where newsId=?;";
        if (this.sdbo == null) {
            this.sdbo = SQLDBOperator.getInstance("Connection");
        }
        try {
            try {
                this.sdbo.prepareStatement(strSql);
                this.sdbo.setInt(1, newsId);
                rs = this.sdbo.executeQuery();
                try {
                    rs.next();
                    sum = rs.getInt("total");
                    rs.close();
                }
                catch (NullPointerException nullE) {
                    System.out.print("Usr isAdminName() " + nullE.getMessage());
                    Debug.writeLog("Usr isAdminName(), Exception Occured ! Info :" + nullE.getLocalizedMessage());
                }
                Object var7_7 = null;
                this.sdbo.Close();
            }
            catch (SQLException sqlE) {
                System.out.print("Usr isAdminName() " + sqlE.getMessage());
                Debug.writeLog("Usr isAdminName(), Exception Occured ! Info :" + sqlE.getLocalizedMessage());
                Object var7_8 = null;
                this.sdbo.Close();
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.sdbo.Close();
            throw throwable;
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator listReply(int newsId) {
        ResultSet rs = null;
        String strSql = "select replyId,newsId,user,content from newsreply where newsId=?;";
        Vector<NEWSReply> vector = new Vector<NEWSReply>();
        if (this.sdbo == null) {
            this.sdbo = SQLDBOperator.getInstance("Connection");
        }
        try {
            try {
                block10: {
                    this.sdbo.prepareStatement(strSql);
                    this.sdbo.setInt(1, newsId);
                    rs = this.sdbo.executeQuery();
                    try {
                        try {
                            while (rs.next()) {
                                NEWSReply tableReply = new NEWSReply();
                                tableReply.setReplyId(rs.getInt("replyId"));
                                tableReply.setUser(rs.getString("user"));
                                tableReply.setContent(rs.getString("content"));
                                vector.add(tableReply);
                            }
                        }
                        catch (NullPointerException nullE) {
                            System.out.print("News listReplyNews() " + nullE.getMessage());
                            Debug.writeLog("News listReplyNews(), Exception Occured ! Info :" + nullE.getLocalizedMessage());
                            Object var7_9 = null;
                            rs.close();
                            break block10;
                        }
                        Object var7_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_10 = null;
                        rs.close();
                        throw throwable;
                    }
                    rs.close();
                }
                Object var9_12 = null;
                this.sdbo.Close();
                return vector.iterator();
            }
            catch (SQLException sqlE) {
                System.out.print("Usr isAdminName() " + sqlE.getMessage());
                Debug.writeLog("Usr isAdminName(), Exception Occured ! Info :" + sqlE.getLocalizedMessage());
                Object var9_13 = null;
                this.sdbo.Close();
                return vector.iterator();
            }
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            this.sdbo.Close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delNewsReply(int replyId) {
        if (this.sdbo == null) {
            this.sdbo = SQLDBOperator.getInstance("Connection");
        }
        String strSql = "delete from NEWSReply where replyId=?;";
        try {
            try {
                this.sdbo.prepareStatement(strSql);
                this.sdbo.setInt(1, replyId);
                this.sdbo.executeUpdate();
            }
            catch (Exception e) {
                System.out.print("News listShNews() " + e.getMessage());
                Debug.writeLog("News listShNews(), Exception Occured ! Info :" + e.getLocalizedMessage());
                Object var5_4 = null;
                this.sdbo.Close();
            }
            Object var5_3 = null;
            this.sdbo.Close();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.sdbo.Close();
            throw throwable;
        }
    }
}

