/*
 * Decompiled with CFR 0.152.
 */
package com.ntsky.pool;

import com.ntsky.common.Debug;
import com.ntsky.common.EnvironmentConfig;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class DBConnectionManager {
    private static DBConnectionManager instance;
    private static int clients;
    private Vector drivers = new Vector();
    private Hashtable pools = new Hashtable();

    private DBConnectionManager() {
        this.init();
    }

    private void createPools(Properties props) {
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            int max;
            String name = (String)propNames.nextElement();
            Debug.writeLog("createPools(Properties), name is:  " + name);
            if (!name.endsWith(".url")) continue;
            Debug.writeLog("createPools(Properties), name end with url");
            String poolName = name.substring(0, name.lastIndexOf("."));
            String url = props.getProperty(poolName + ".url");
            Debug.writeLog("createPools(Properties), url is " + url);
            if (url == null) {
                Debug.writeLog("\u6ca1\u6709\u4e3a\u8fde\u63a5\u6c60" + poolName + "\u6307\u5b9aURL");
                continue;
            }
            String user = props.getProperty(poolName + ".user");
            String password = props.getProperty(poolName + ".password");
            String maxconn = props.getProperty(poolName + ".maxconn", "0");
            try {
                max = Integer.valueOf(maxconn);
            }
            catch (NumberFormatException e) {
                Debug.writeLog("\u9519\u8bef\u7684\u6700\u5927\u8fde\u63a5\u6570\u9650\u5236: " + maxconn + " .\u8fde\u63a5\u6c60: " + poolName);
                max = 0;
            }
            DBConnectionPool pool = new DBConnectionPool(poolName, url, user, password, max);
            this.pools.put(poolName, pool);
            Debug.writeLog("\u6210\u529f\u521b\u5efa\u8fde\u63a5\u6c60" + poolName);
        }
    }

    public void freeConnection(String name, Connection con) {
        DBConnectionPool pool = (DBConnectionPool)this.pools.get(name);
        if (pool != null) {
            pool.freeConnection(con);
        }
    }

    public Connection getConnection(String name) {
        DBConnectionPool pool = (DBConnectionPool)this.pools.get(name);
        if (pool != null) {
            Debug.writeLog("DBConnectionManager getConnection(String) ! pool is not null !");
            return pool.getConnection();
        }
        return null;
    }

    public Connection getConnection(String name, long time) {
        DBConnectionPool pool = (DBConnectionPool)this.pools.get(name);
        if (pool != null) {
            return pool.getConnection(time);
        }
        return null;
    }

    public static synchronized DBConnectionManager getInstance() {
        if (instance == null) {
            instance = new DBConnectionManager();
        }
        ++clients;
        return instance;
    }

    private void init() {
        Properties dbProps = EnvironmentConfig.getInstance().getProperties("/properties/ntsky.properties");
        this.loadDrivers(dbProps);
        this.createPools(dbProps);
    }

    private void loadDrivers(Properties props) {
        String driverClasses = props.getProperty("drivers");
        StringTokenizer st = new StringTokenizer(driverClasses);
        while (st.hasMoreElements()) {
            String driverClassName = st.nextToken().trim();
            try {
                Driver driver = (Driver)Class.forName(driverClassName).newInstance();
                DriverManager.registerDriver(driver);
                Debug.writeLog("Load Driver Success !");
                this.drivers.addElement(driver);
                Debug.writeLog("\u6210\u529f\u6ce8\u518cJDBC\u9a71\u52a8\u7a0b\u5e8f" + driverClassName);
            }
            catch (Exception e) {
                Debug.writeLog("\u65e0\u6cd5\u6ce8\u518cJDBC\u9a71\u52a8\u7a0b\u5e8f: " + driverClassName + ", \u9519\u8bef: " + e);
            }
        }
    }

    public synchronized void release() {
        if (--clients != 0) {
            return;
        }
        Enumeration allPools = this.pools.elements();
        while (allPools.hasMoreElements()) {
            DBConnectionPool pool = (DBConnectionPool)allPools.nextElement();
            pool.release();
        }
        Enumeration allDrivers = this.drivers.elements();
        while (allDrivers.hasMoreElements()) {
            Driver driver = (Driver)allDrivers.nextElement();
            try {
                DriverManager.deregisterDriver(driver);
                Debug.writeLog("\u64a4\u9500JDBC\u9a71\u52a8\u7a0b\u5e8f " + driver.getClass().getName() + "\u7684\u6ce8\u518c");
            }
            catch (SQLException e) {
                Debug.writeLog("\u65e0\u6cd5\u64a4\u9500\u4e0b\u5217JDBC\u9a71\u52a8\u7a0b\u5e8f\u7684\u6ce8\u518c: " + driver.getClass().getName());
                e.printStackTrace(System.out);
            }
        }
    }

    class DBConnectionPool {
        private int checkedOut;
        private Vector freeConnections = new Vector();
        private int maxConn;
        private String name;
        private String user;
        private String password;
        private String URL;
        private PrintWriter log;

        public DBConnectionPool(String name, String url, String user, String password, int maxConn) {
            this.name = name;
            this.URL = url;
            this.user = user;
            this.password = password;
            this.maxConn = maxConn;
            this.log = new PrintWriter(System.err);
            Debug.writeLog("poolname" + this.name);
            Debug.writeLog("URL: " + this.URL);
            Debug.writeLog("user: " + this.user);
            Debug.writeLog("password: " + this.password);
            Debug.writeLog("maxConn: " + this.maxConn);
        }

        public synchronized void freeConnection(Connection Conn) {
            this.freeConnections.addElement(Conn);
            --this.checkedOut;
            this.notifyAll();
        }

        public synchronized Connection getConnection() {
            Connection con = null;
            if (this.freeConnections.size() > 0) {
                con = (Connection)this.freeConnections.firstElement();
                this.freeConnections.removeElementAt(0);
                try {
                    if (con.isClosed()) {
                        Debug.writeLog("\u4ece\u8fde\u63a5\u6c60" + this.name + "\u5220\u9664\u4e00\u4e2a\u65e0\u6548\u8fde\u63a5");
                        con = this.getConnection();
                    }
                }
                catch (SQLException e) {
                    Debug.writeLog("\u4ece\u8fde\u63a5\u6c60" + this.name + "\u5220\u9664\u4e00\u4e2a\u65e0\u6548\u8fde\u63a5");
                    con = this.getConnection();
                }
            } else if (this.maxConn == 0 || this.checkedOut < this.maxConn) {
                con = this.newConnection();
            }
            if (con != null) {
                ++this.checkedOut;
            }
            if (con == null) {
                Debug.writeLog("DBConnectionPool getConnection(), The Returned Con is null");
            }
            return con;
        }

        public synchronized Connection getConnection(long timeout) {
            Connection con;
            long startTime = new Date().getTime();
            while ((con = this.getConnection()) == null) {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (new Date().getTime() - startTime < timeout) continue;
                return null;
            }
            return con;
        }

        private void log(String msg) {
            this.log.println(new Date() + ": " + msg);
        }

        private void log(Throwable e, String msg) {
            this.log.println(new Date() + ": " + msg);
            e.printStackTrace(this.log);
        }

        private Connection newConnection() {
            Connection con = null;
            try {
                con = this.user == null ? DriverManager.getConnection(this.URL) : DriverManager.getConnection(this.URL, this.user, this.password);
                Debug.writeLog("\u8fde\u63a5\u6c60" + this.name + "\u521b\u5efa\u4e00\u4e2a\u65b0\u7684\u8fde\u63a5");
            }
            catch (SQLException e) {
                Debug.writeLog("\u65e0\u6cd5\u521b\u5efa\u4e0b\u5217URL\u7684\u8fde\u63a5: " + this.URL);
                e.printStackTrace(System.out);
                return null;
            }
            if (con == null) {
                Debug.writeLog("DBConnectionPool newConnection(), The Returned Con is null");
            }
            return con;
        }

        public synchronized void release() {
            Enumeration allConnections = this.freeConnections.elements();
            while (allConnections.hasMoreElements()) {
                Connection con = (Connection)allConnections.nextElement();
                try {
                    con.close();
                    Debug.writeLog("\u5173\u95ed\u8fde\u63a5\u6c60" + this.name + "\u4e2d\u7684\u4e00\u4e2a\u8fde\u63a5");
                }
                catch (SQLException e) {
                    Debug.writeLog("\u65e0\u6cd5\u5173\u95ed\u8fde\u63a5\u6c60" + this.name + "\u4e2d\u7684\u8fde\u63a5");
                    e.printStackTrace(System.out);
                }
            }
            this.freeConnections.removeAllElements();
        }
    }
}

