package com.ntsky.pool;

import java.io.*;
import java.sql.*;
import java.util.*;

import com.ntsky.common.*;

/**
 * <p>Title: NTskyŷv1.0ʽ</p>
 * <p>Description: ݿӳ</p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: NTsky</p>
 * @authory Ҧ
 * @version 1.0
 */

public class DBConnectionManager {
    static private DBConnectionManager instance; //Ψһʵ
    static private int clients; //ͻ˵Ŀ
    private Vector drivers = new Vector();
    private Hashtable pools = new Hashtable(); //һHashtable

    class DBConnectionPool { //һDBConnectionPool[DBConnectionManagerҪDBConnectionPool봴DBConnectionPoolĶ]

        private int checkedOut; //жǷпõ
        private Vector freeConnections = new Vector();//һfreeConnections
        private int maxConn; //
        private String name; //ݿӳ
        private String user; //ݿû
        private String password; //ݿ
        private String URL; //ݿַ
        private PrintWriter log; //־
        /**
         * ļ
         * @param name
         * @param url
         * @param user
         * @param password
         * @param maxConn
         */
        public DBConnectionPool(String name, String url, String user,
                                String password, int maxConn) {
            /**
             *ļ
             */
            this.name = name; //poolname ӳ
            this.URL = url; //ַ
            this.user = user; //û
            this.password = password; //
            this.maxConn = maxConn; //
            //д־
            this.log = new PrintWriter(System.err);
            Debug.writeLog("poolname" + this.name); //7"poolname" + Connection
            Debug.writeLog("URL: " + this.URL); //8jdbc:mysql://127.0.0.1:3306/nt
            Debug.writeLog("user: " + this.user); //9user: skyyjl
            Debug.writeLog("password: " + this.password); //10password: abc
            Debug.writeLog("maxConn: " + this.maxConn); //11maxConn: 100
        }

        /**
         * ѿеӵǼǵӳɵfreeConnection()ʵ
         * ĲΪظӳصӶ󡣸ö󱻼뵽freeConnectionsĩβȻʹӼ
         * notifyAll()Ϊ֪ͨڵȴӵ̡߳
         * @param Conn
         */
        public synchronized void freeConnection(Connection Conn) {
            freeConnections.addElement(Conn);
            checkedOut--;
            notifyAll();
        }

        /**
         * ӳдڿӣֱӷأ򴴽µӲء
         * ûпһֱӷnull
         * ڶȴֱпΪֹ
         * еĿӶǼΪfreeConnectionsVectorС
         * жһӣgetConnection()ѡȡһ
         * µĿǴβӶʹݿڳʱöرյķռ͵С̶ȡ
         *
         * @return Connection
         */
        public synchronized Connection getConnection() {
            Connection con = null;
            if (freeConnections.size() > 0) { //ȡеһ
                con = (Connection) freeConnections.firstElement(); //һconnectionΪConnection
                freeConnections.removeElementAt(0);
                try {
                    /**
                     * һgetConnection()ڷؿӸͻ֮ǰisClosed()֤ԾЧ
                     * ӱرջ򴥷쳣getConnection()ݹصԼԳԻȡĿӡ
                     */
                    if (con.isClosed()) { //жǷر
                        Debug.writeLog("ӳ" + name + "ɾһЧ");
                        con = getConnection(); //ݹԼ,ٴλȡ
                    }
                }
                catch (SQLException e) {
                    Debug.writeLog("ӳ" + name + "ɾһЧ"); // ݹԼ,ٴλȡ
                    con = getConnection();
                }
            }
            /**
             * freeConnectionsвκοӣgetConnection()ǷѾָơ
             * Ѿָ鵱ǰǷѾＫޡ˴maxConnΪ0ʾûơ
             * ûָƻǰСڸֵ÷Դµӡ
             * 紴ɹʹӵļ(checkout)أ򷵻ؿֵ
             */
            else if (maxConn == 0 || checkedOut < maxConn) {
                con = newConnection(); //(maxConn)
            }
            if (con != null) { //conn()ΪգжϾͼ
                checkedOut++;
            }
            if (con == null) { //ΪվͽconΪд־
                Debug.writeLog(
                    "DBConnectionPool getConnection(), The Returned Con is null");
            }
            return con; //
        }

        /**
         * һԺΪλʱòʾͻܹȴʱ䡣
         * ӵľԾɵһgetConnection()ʵ֡
         * μǰһgetConnection().
         * @param timeout ԺƵĵȴʱ
         */
        public synchronized Connection getConnection(long timeout) {
            long startTime = new java.util.Date().getTime(); //ӵĳʼʱ
            Connection con;
            /**
             * whileѭгԻһӡʧܣԸʱֵΪwait()
             * wait()ķؿ̵߳notify()notifyAll()ҲԤʱѵ
             * Ϊҳwait()صԭ򣬳õǰʱʼʱ䣨startTime
             * ֵԤʱ򷵻ؿֵٴεgetConnection()
             */
            while ( (con = getConnection()) == null) {
                try {
                    wait(timeout);
                }
                catch (InterruptedException e) {

                }
                if ( (new java.util.Date().getTime() - startTime) >= timeout) { //wait()صԭǳʱ
                    return null; //ӳʱ,ͷŵ
                }
            }
            return con; //
        }

        private void log(String msg) {
            log.println(new java.util.Date() + ": " + msg);
        }

        /**
         * ıϢ쳣д־ļ
         */
        private void log(Throwable e, String msg) {
            log.println(new java.util.Date() + ": " + msg);
            e.printStackTrace(log);
        }

        /**
         * newConnection()ʵ֡
         * ǷѾָݿʺšйء
         * JDBCDriverManagerṩgetConnection()ЩҪõJDBC URLһЩûʺźȡ
         * DriverManagerʹָJDBC URLȷʺĿݿ򼰽ӡ
         */
        private Connection newConnection() {
            Connection con = null;
            try {
                if (user == null) {
                    con = DriverManager.getConnection(URL); //ݿӼݿ
                }
                else {
                    con = DriverManager.getConnection(URL, user, password);
                }
                Debug.writeLog("ӳ" + name + "һµ"); //21ûӾд־˵û
            }
            catch (SQLException e) {
                Debug.writeLog("޷URL: " + URL);
                e.printStackTrace(System.out);
                return null;
            }
            if (con == null) {
                Debug.writeLog(
                    "DBConnectionPool newConnection(), The Returned Con is null");
            }
            return con;
        }

        /**
         * ʵֵrelease()DBConnectionManagerá
         * ÷freeConnectionsرӣȻɾЩӡ
         */
        public synchronized void release() {
            Enumeration allConnections = freeConnections.elements();
            while (allConnections.hasMoreElements()) { //freeConnections
                Connection con = (Connection) allConnections.nextElement(); //ȡе
                try {
                    con.close(); //Թر
                    Debug.writeLog("رӳ" + name + "еһ");
                }
                catch (SQLException e) {
                    Debug.writeLog("޷رӳ" + name + "е");
                    e.printStackTrace(System.out);
                }
            }
            freeConnections.removeAllElements(); //
        }
    }

    /**
     * *****************************************************************
     * ˽Էֹ󴴽ʵ
     * ܹ侲̬ҲΪ෽øΨһʵ
     * DBConnectionManagerĽ˽еģΪ˱󴴽ʵ
     */
    private DBConnectionManager() {
        init();
    }

    /**
     *
     * @param props ӳ
     */
    private void createPools(Properties props) {
        Enumeration propNames = props.propertyNames(); //öٶ----öΪһԪϵУεnextElement()˳򷵻ظԪ
        while (propNames.hasMoreElements()) { //öٶ
            String name = (String) propNames.nextElement(); //ȡֵʽΪַ
            Debug.writeLog("createPools(Properties), name is:  " + name); //3logPath ·д־
            /**
             * ԡ.urlβ
             * ÿһԣȡӳֲ֣ȡڸӳص
             */
            if (name.endsWith(".url")) {
                Debug.writeLog("createPools(Properties), name end with url"); //5
                String poolName = name.substring(0, name.lastIndexOf(".")); //ȡ.֮ǰַ(ӳص)
                String url = props.getProperty(poolName + ".url"); //4Connection.url ȡURL
                Debug.writeLog("createPools(Properties), url is " + url); //6jdbc:mysql://127.0.0.1:3306/nt дݿurl"jdbc:mysql://127.0.0.1:3306/"
                if (url == null) { //URLΪգд־ʾûҵָURL
                    Debug.writeLog("ûΪӳ" + poolName + "ָURL");
                    continue; //ѭ
                }
                String user = props.getProperty(poolName + ".user"); //û
                String password = props.getProperty(poolName + ".password"); //
                String maxconn = props.getProperty(poolName + ".maxconn", "0"); //
                int max; //һα
                try {
                    max = Integer.valueOf(maxconn).intValue(); //ȡֵ
                }
                catch (NumberFormatException e) {
                    Debug.writeLog(": " + maxconn + " .ӳ: " +
                                   poolName);
                    max = 0;
                }
                //ӳض󲢰ʵpools
                DBConnectionPool pool = new DBConnectionPool(poolName, url, user, password, max);
                //ɢбHashtable poolsʵӳֵӳض֮ӳ䣬˴ӳΪӳضΪֵ
                pools.put(poolName, pool);
                Debug.writeLog("ɹӳ" + poolName); //12ɹӳConnection
            }
        }
    }

    /**
     * Ӷ󷵻ظָӳ
     * @param name ļжӳ
     * @param con Ӷ
     */
    public void freeConnection(String name, Connection con) {
        DBConnectionPool pool = (DBConnectionPool) pools.get(name);
        if (pool != null) {
            pool.freeConnection(con);
        }
    }

    /**
     * һõ(е).ûп,С
     * ,򴴽
     * @param name ļжӳ
     * @return Connection ӻnull
     */
    public Connection getConnection(String name) {
        DBConnectionPool pool = (DBConnectionPool) pools.get(name);
        if (pool != null) {
            Debug.writeLog(
                "DBConnectionManager getConnection(String) ! pool is not null !"); //20
            return pool.getConnection();
        }
        return null;
    }

    /**
     * һ.ûп,С,
     * 򴴽.,ָʱڵȴ߳ͷ.
     * @param name ӳ
     * @param time ԺƵĵȴʱ
     * @return Connection ӻnull
     */
    public Connection getConnection(String name, long time) {
        DBConnectionPool pool = (DBConnectionPool) pools.get(name);
        if (pool != null) {
            return pool.getConnection(time);
        }
        return null;
    }

    /**
     * þһֱھ̬instance
     * ÿεgetInstance()һDBConnectionManagerĿͻ
     * üDBConnectionManagerΨһʵĿͻڿӳصĹرղ
     * @return Ψһʵ.ǵһεô˷,򴴽ʵ
     */
    public static synchronized DBConnectionManager getInstance() {
        if (instance == null) {
            instance = new DBConnectionManager();
        }
        clients++; //Կͻ˵ķʼ
        return instance;
    }

    /**
     * ȡɳʼ
     */
    private void init() {
        //[ļ·ISiteEnvironment.ConfigFile]EnvironmentConfiggetProperties()
        Properties dbProps = EnvironmentConfig.getInstance().getProperties(
            ISiteEnvironment.ConfigFile);
        loadDrivers(dbProps); //װ
        createPools(dbProps); //˽зcreatePools()ӳض
    }

    /**
     * װغעJDBC
     * ÷StringTokenizerdriversֵָΪӦƵַ
     *
     * @param props 
     */
    private void loadDrivers(Properties props) {
        String driverClasses = props.getProperty("drivers");
        StringTokenizer st = new StringTokenizer(driverClasses);
        while (st.hasMoreElements()) {
            String driverClassName = st.nextToken().trim(); //ȡorg.gjt.mm.mysql.Driver
            try {
                Driver driver = (Driver) Class.forName(driverClassName).
                    newInstance();
                DriverManager.registerDriver(driver);
                Debug.writeLog("Load Driver Success !"); //1ɹ
                drivers.addElement(driver);
                Debug.writeLog("ɹעJDBC" + driverClassName); //2JDBCorg.gjt.mm.mysql.Driver
            }
            catch (Exception e) {
                Debug.writeLog("޷עJDBC: " + driverClassName + ", : " +  e);
            }
        }
    }

    /**
     * ͻڹرʱrelease()Եݼü
     * һͻrelease()ݼüΪ0ͿԵøӳصrelease()رˡ
     * ر,ע
     */
    public synchronized void release() { //ȴֱһͻ
        if (--clients != 0) {
            return;
        }
        Enumeration allPools = pools.elements();
        while (allPools.hasMoreElements()) {
            DBConnectionPool pool = (DBConnectionPool) allPools.nextElement();
            pool.release();
        }
        Enumeration allDrivers = drivers.elements();
        while (allDrivers.hasMoreElements()) {
            Driver driver = (Driver) allDrivers.nextElement();
            try {
                DriverManager.deregisterDriver(driver);
                Debug.writeLog("JDBC " + driver.getClass().getName() + "ע");
            }
            catch (SQLException e) {
                Debug.writeLog("޷JDBCע: " + driver.getClass().getName());
                e.printStackTrace(System.out);
            }
        }
    }
}
