/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.FontFactory;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.SpecialSymbol;

public class GreekList
extends List {
    public GreekList() {
        super(true);
        this.setGreekFont();
    }

    public GreekList(int symbolIndent) {
        super(true, symbolIndent);
        this.setGreekFont();
    }

    public GreekList(boolean greeklower, int symbolIndent) {
        super(true, symbolIndent);
        this.lowercase = greeklower;
        this.setGreekFont();
    }

    protected void setGreekFont() {
        float fontsize = this.symbol.font().size();
        this.symbol.setFont(FontFactory.getFont("Symbol", fontsize, 0));
    }

    public void setGreekLower(boolean greeklower) {
        this.lowercase = greeklower;
    }

    public boolean isGreekLower() {
        return this.lowercase;
    }

    public boolean add(Object o) {
        if (o instanceof ListItem) {
            ListItem item = (ListItem)o;
            int index = this.first + this.list.size();
            int[] greekValue = GreekList.getGreekValue(index, this.lowercase);
            Chunk chunk = SpecialSymbol.get((char)greekValue[0], this.symbol.font());
            int i = 1;
            while (i < greekValue.length) {
                chunk.append(String.valueOf(SpecialSymbol.getCorrespondingSymbol((char)greekValue[i])));
                ++i;
            }
            chunk.append(". ");
            item.setListSymbol(chunk);
            item.setIndentationLeft(this.symbolIndent, this.autoindent);
            item.setIndentationRight(0.0f);
            this.list.add(item);
        } else {
            if (o instanceof List) {
                List nested = (List)o;
                nested.setIndentationLeft(nested.indentationLeft() + this.symbolIndent);
                --this.first;
                return this.list.add(nested);
            }
            if (o instanceof String) {
                return this.add(new ListItem((String)o));
            }
        }
        return false;
    }

    public static int[] getGreekValue(int index, boolean lowercase) {
        if (index < 1) {
            return new int[0];
        }
        --index;
        int bytes = 1;
        int start = 0;
        int symbols = 24;
        while (index >= symbols + start) {
            ++bytes;
            start += symbols;
            symbols *= 24;
        }
        int c = index - start;
        int[] value = new int[bytes];
        while (bytes > 0) {
            value[--bytes] = c % 24;
            if (value[bytes] > 16) {
                int n = bytes;
                value[n] = value[n] + 1;
            }
            int n = bytes;
            value[n] = value[n] + (lowercase ? 945 : 913);
            c /= 24;
        }
        return value;
    }
}

