# How to contribute

Want to show Jodd some love? Help out by contributing!

## :beetle: Found a bug?
Log it in our *issue tracker* (in GitHub or in old GoogleCode) or send a note to the *user group* or simply send us an *email*. Be sure to include all relevant information, like the versions of Jodd you’re using. A code snippet that caused the issue as well as any error messages are also very helpful.

## :bar_chart: What is currently developing?

The best way to get overall information on what's planned is by using the [ZenHub](https://www.zenhub.com) plugin.

## :star2: Have a patch?
The best way to make sure your issue or feature is addressed is to submit a patch. We accept patches through all mediums: pull requests, email, issue comment, link to a snippet, graffiti outside of John's apartment, etc.

However, before sending a patch, please make sure that the following applies:

* Your commit message is descriptive.
* Your patch doesn't have useless merge commits.
* Your coding style is similar to ours.
* Your patch is 100% tested. We don't accept any test regressions. 
* See our [styleguide](STYLEGUIDE.md) how tests should be written.
* All tests checks pass.
* You understand that we're super grateful for your patch!

## :heart: Adding something new?
We do love to enhance Jodd with you to become more powerful! The best way to workout your idea is to _discuss it first_! **Please**, if you can, don't just throw us the code of a new feature or a refactoring; lets first figure together what would be the best approach regarding the current architecture and future plans, before any development. This way we all get sure that your idea is aligned with the codebase and you can enjoy your happy coding even more :)

## :question: Need help?
Simply contact our *support* via email - or ask question on [stackoverflow](https://stackoverflow.com/questions/tagged/jodd).

## :closed_book: Want to write docs?
Documentation is very valuable to us. So just send it any way you like :)
