![](jodd-github-logo.png)
<br>

[![GitHub release](https://img.shields.io/github/release/oblac/jodd.svg)](https://jodd.org)
[![Build Status](https://img.shields.io/travis/oblac/jodd.svg)](https://travis-ci.org/oblac/jodd)
[![codecov](https://codecov.io/gh/oblac/jodd/branch/master/graph/badge.svg)](https://codecov.io/gh/oblac/jodd)
[![Codacy Badge](https://api.codacy.com/project/badge/Grade/0ce3a0ae3667441fbbd261f6c9e043b0)](https://www.codacy.com/app/igo_rs/jodd)
[![JitPack](https://jitpack.io/v/oblac/jodd.svg)](https://jitpack.io/#oblac/jodd)
[![Stack Overflow](https://img.shields.io/badge/stack%20overflow-jodd-4183C4.svg)](https://stackoverflow.com/questions/tagged/jodd)
[![BSD License](https://img.shields.io/badge/license-BSD--2--Clause-blue.svg)](https://jodd.org/license.html)


> Produce lightweight code and focus on unleashing your full potential. Jodd is a set of developer-friendly and open-source Java micro-frameworks. It's designed to make things simple, but not simpler.

## 👋 Hello!

Welcome to the **Jodd** - a unique, alternative world of Java :) You can find here some micro-frameworks and some handy tools. Nothing more, nothing less.

<h4 align="center">Jodd = tools + ioc + mvc + db + aop + tx + json + html < 1.7 Mb</h4>

Check the official web-site: https://jodd.org


## ‼️ The Future and Jodd Versions

Version **v6** is the maintained version, working on Java 8 and 11. Only few components are promoted to v6:

+ [jodd-util](https://github.com/oblac/jodd-util) ⭐
+ [jodd-mail](https://github.com/oblac/jodd-mail) ⭐
+ [jodd-json](https://github.com/oblac/jodd-json) ⭐
+ [jodd-lagarto](https://github.com/oblac/jodd-lagarto) ⭐

The decision which component is promoted is based on the Maven Central Repo statistics. 

Version **v5** contains remaining libraries and frameworks. They are in maintenance mode.

Sorry, I can only do so much.

## :zap: Jodd

**Jodd** is set of micro-frameworks and developer-friendly tools and utilities.

_Use what you like._ **Thank you.** 🙏

**Cool libraries**:

+ `jodd-json` - JSON parser and serializer. ⭐
+ `jodd-lagarto` - HTML parser with `Jerry` and `CSSelly` and `Form` tag. ⭐
+ `jodd-http` - tiny HTTP client.
+ `jodd-mail` - for easier email sending. ⭐

**Micro-frameworks**:

+ `jodd-madvoc` - slick MVC framework.
+ `jodd-petite` - pragmatic DI container.
+ `jodd-proxetta` - dynamic proxies and `Paramo`.
+ `jodd-db` - thin database layer and object mapper.
+ `jodd-jtx` - transactions management.

**Less used tools**:

+ `jodd-decora` - pages decorator.
+ `jodd-htmlstapler` - static page resources handler.
+ `jodd-vtor` - validation framework.

**Full Stack Bundle**:

+ `jodd-joy` - super-easy app framework, built with *Jodd* micro-frameworks.

**Utilities**:

+ `jodd-core` - contains many every-day utilities. ⭐
+ `jodd-bean` - our infamous `BeanUtil`, type inspectors and converters. ⭐
+ `jodd-props` - is the super-replacement for Java `Properties`.
+ `jodd-servlet` - with many servlet utilities, including nice tag library.

Read more in our [official documentation](http://jodd.org/doc).

## :octocat: Building Jodd from source

**Jodd** is built with [Gradle](http://gradle.org/) on JDK8,
targeting Java 1.8. You don't have to install anything,
the only prerequisites are [Git](http://help.github.com/set-up-git-redirect)
and Java JDK.

## :gift_heart: Contribute

Feel free to [contribute](CONTRIBUTING.md)! Follow these steps:

First time only:

+ fork the **Jodd** repo (`upstream`) to your GitHub account (`origin`)
+ clone `origin` as your `local` repo

Every other time:

+ update both `origin` and `local` repos from `upstream`
+ create new branch for a feature or bug fix
+ commit often :)
+ once when work is done, push local changes to your `origin`
+ send us a pull request (PR)

We will pickup up from there :)

:rocket:

## Code Contributors

This project exists thanks to all the people who contribute. [[Contribute](CONTRIBUTING.md)].
<a href="https://github.com/oblac/jodd/graphs/contributors"><img src="https://opencollective.com/jodd/contributors.svg?width=890&button=false" /></a>
