// Copyright (c) 2003-present, Jodd Team (http://jodd.org)
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

package jodd.htmlstapler;

import org.junit.jupiter.api.Test;

import static jodd.htmlstapler.HtmlStaplerBundlesManager.Strategy.RESOURCES_ONLY;
import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertTrue;

class HtmlStaplerBundlesManagerTest {

	@Test
	void testRandomDigest() {
		HtmlStaplerBundlesManager hsbm = new HtmlStaplerBundlesManager("/ctx", "/", RESOURCES_ONLY);

		String digest = hsbm.createDigest("source");

		hsbm.setRandomDigestChars(5);

		String digest2 = hsbm.createDigest("source");
		String digest3 = hsbm.createDigest("source");

		assertEquals(digest2, digest3);
		assertTrue(digest2.startsWith(digest));


		hsbm.setRandomDigestChars(0);

		digest2 = hsbm.createDigest("source");

		assertEquals(digest, digest2);
	}

	@Test
	void testFixUrl() {
		HtmlStaplerBundlesManager hsbm = new HtmlStaplerBundlesManager("/ctx", "/", RESOURCES_ONLY);
		String fixedCss;

		fixedCss = hsbm.fixCssRelativeUrls("@import url('/aaa/css?family=Roboto:300,400,500,700');", "/aaa.css");
		assertEquals("@import url('/aaa/css?family=Roboto:300,400,500,700');", fixedCss);

		fixedCss = hsbm.fixCssRelativeUrls("@import url('bbb/css?family=Roboto:300,400,500,700');", "/aaa/ccc.css");
		assertEquals("@import url('../aaa/bbb/css?family=Roboto:300,400,500,700');", fixedCss);

		fixedCss = hsbm.fixCssRelativeUrls("@import url('https://fonts.googleapis.com/css?family=Roboto:300,400,500,700');", "/");
		assertEquals("@import url('https://fonts.googleapis.com/css?family=Roboto:300,400,500,700');", fixedCss);

		fixedCss = hsbm.fixCssRelativeUrls("background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhE);", "/");
		assertEquals("background-image:url('data:image/png;base64,iVBORw0KGgoAAAANSUhE');", fixedCss);

		fixedCss = hsbm.fixCssRelativeUrls("background-image:url('data:image/png;base64,iVBORw0KGgoAAAANSUhE');", "/");
		assertEquals("background-image:url('data:image/png;base64,iVBORw0KGgoAAAANSUhE');", fixedCss);
	}
}
