// Copyright (c) 2003-present, Jodd Team (http://jodd.org)
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

package jodd.vtor.constraint;

import jodd.vtor.TestUtils;
import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

class LengthConstraintTest extends ConstraintTestBase {
    @Test
    void testValidate_WithNullValue() {
        assertTrue(LengthConstraint.validate(null, 1, 2), "result must be true when validate a null value");
    }

    @Test
    void testConstructor1() {
        LengthConstraint lengthConstraint = new LengthConstraint();
        assertEquals(0, lengthConstraint.getMin());
        assertEquals(0, lengthConstraint.getMax());
    }

    @Test
    void testConstructor2() {
        LengthConstraint lengthConstraint = new LengthConstraint(5, 10);
        assertEquals(5, lengthConstraint.getMin());
        assertEquals(10, lengthConstraint.getMax());
    }

    @Test
    void testSetMinMax() {
        LengthConstraint lengthConstraint = new LengthConstraint();
        lengthConstraint.setMin(5);
        lengthConstraint.setMax(10);
        assertEquals(5, lengthConstraint.getMin());
        assertEquals(10, lengthConstraint.getMax());
    }

    @Test
    void testConfigure() {
        LengthConstraint lengthConstraint = new LengthConstraint();
        Length annotation = mock(Length.class);
        when(annotation.min()).thenReturn(5);
        when(annotation.max()).thenReturn(10);

        lengthConstraint.configure(annotation);
        assertEquals(5, lengthConstraint.getMin());
        assertEquals(10, lengthConstraint.getMax());
    }

    @Test
    void testLengthConstraint() {
        LengthConstraint lengthConstraint = new LengthConstraint(4, 6);
        assertFalse(lengthConstraint.isValid(mockContext(), TestUtils.stringWithLength(7)));
        assertFalse(lengthConstraint.isValid(mockContext(), TestUtils.stringWithLength(3)));
        assertTrue(lengthConstraint.isValid(mockContext(), TestUtils.stringWithLength(4)));
        assertTrue(lengthConstraint.isValid(mockContext(), TestUtils.stringWithLength(6)));
        assertTrue(lengthConstraint.isValid(mockContext(), TestUtils.stringWithLength(5)));
    }

}
