/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio;

import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.protocol.Packet;
import com.corundumstudio.socketio.protocol.PacketType;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AckRequest {
    private final Packet originalPacket;
    private final SocketIOClient client;
    private final AtomicBoolean sended = new AtomicBoolean();

    public AckRequest(Packet originalPacket, SocketIOClient client) {
        this.originalPacket = originalPacket;
        this.client = client;
    }

    public boolean isAckRequested() {
        return this.originalPacket.isAckRequested();
    }

    public void sendAckData(Object ... objs) {
        List<Object> args = Arrays.asList(objs);
        this.sendAckData(args);
    }

    public void sendAckData(List<Object> objs) {
        if (!this.isAckRequested() || !this.sended.compareAndSet(false, true)) {
            return;
        }
        Packet ackPacket = new Packet(PacketType.MESSAGE);
        ackPacket.setSubType(PacketType.ACK);
        ackPacket.setAckId(this.originalPacket.getAckId());
        ackPacket.setData(objs);
        this.client.send(ackPacket);
    }
}

