/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio;

import com.corundumstudio.socketio.AckCallback;
import com.corundumstudio.socketio.SocketIOClient;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BroadcastAckCallback<T> {
    final AtomicBoolean loopFinished = new AtomicBoolean();
    final AtomicInteger counter = new AtomicInteger();
    final AtomicBoolean successExecuted = new AtomicBoolean();
    final Class<T> resultClass;
    final int timeout;

    public BroadcastAckCallback(Class<T> resultClass, int timeout) {
        this.resultClass = resultClass;
        this.timeout = timeout;
    }

    public BroadcastAckCallback(Class<T> resultClass) {
        this(resultClass, -1);
    }

    final AckCallback<T> createClientCallback(final SocketIOClient client) {
        this.counter.getAndIncrement();
        return new AckCallback<T>(this.resultClass, this.timeout){

            @Override
            public void onSuccess(T result) {
                BroadcastAckCallback.this.counter.getAndDecrement();
                BroadcastAckCallback.this.onClientSuccess(client, result);
                BroadcastAckCallback.this.executeSuccess();
            }

            @Override
            public void onTimeout() {
                BroadcastAckCallback.this.onClientTimeout(client);
            }
        };
    }

    protected void onClientTimeout(SocketIOClient client) {
    }

    protected void onClientSuccess(SocketIOClient client, T result) {
    }

    protected void onAllSuccess() {
    }

    private void executeSuccess() {
        if (this.loopFinished.get() && this.counter.get() == 0 && this.successExecuted.compareAndSet(false, true)) {
            this.onAllSuccess();
        }
    }

    void loopFinished() {
        this.loopFinished.set(true);
        this.executeSuccess();
    }
}

