/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio;

import com.corundumstudio.socketio.BroadcastAckCallback;
import com.corundumstudio.socketio.ClientOperations;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.misc.IterableCollection;
import com.corundumstudio.socketio.namespace.Namespace;
import com.corundumstudio.socketio.protocol.Packet;
import com.corundumstudio.socketio.protocol.PacketType;
import com.corundumstudio.socketio.store.StoreFactory;
import com.corundumstudio.socketio.store.pubsub.DispatchMessage;
import com.corundumstudio.socketio.store.pubsub.PubSubType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BroadcastOperations
implements ClientOperations {
    private final Iterable<SocketIOClient> clients;
    private final StoreFactory storeFactory;

    public BroadcastOperations(Iterable<SocketIOClient> clients, StoreFactory storeFactory) {
        this.clients = clients;
        this.storeFactory = storeFactory;
    }

    private void dispatch(Packet packet) {
        HashMap<String, HashSet<String>> namespaceRooms = new HashMap<String, HashSet<String>>();
        for (SocketIOClient socketIOClient : this.clients) {
            Namespace namespace = (Namespace)socketIOClient.getNamespace();
            Set<String> rooms = namespace.getRooms(socketIOClient);
            HashSet<String> roomsList = (HashSet<String>)namespaceRooms.get(namespace.getName());
            if (roomsList == null) {
                roomsList = new HashSet<String>();
                namespaceRooms.put(namespace.getName(), roomsList);
            }
            roomsList.addAll(rooms);
        }
        for (Map.Entry entry : namespaceRooms.entrySet()) {
            for (String room : (Set)entry.getValue()) {
                this.storeFactory.pubSubStore().publish(PubSubType.DISPATCH, new DispatchMessage(room, packet, (String)entry.getKey()));
            }
        }
    }

    public Collection<SocketIOClient> getClients() {
        return new IterableCollection<SocketIOClient>(this.clients);
    }

    @Override
    public void send(Packet packet) {
        for (SocketIOClient client : this.clients) {
            client.send(packet);
        }
        this.dispatch(packet);
    }

    public <T> void send(Packet packet, BroadcastAckCallback<T> ackCallback) {
        for (SocketIOClient client : this.clients) {
            client.send(packet, ackCallback.createClientCallback(client));
        }
        ackCallback.loopFinished();
    }

    @Override
    public void disconnect() {
        for (SocketIOClient client : this.clients) {
            client.disconnect();
        }
    }

    public void sendEvent(String name, SocketIOClient excludedClient, Object ... data) {
        Packet packet = new Packet(PacketType.MESSAGE);
        packet.setSubType(PacketType.EVENT);
        packet.setName(name);
        packet.setData(Arrays.asList(data));
        for (SocketIOClient client : this.clients) {
            if (client.getSessionId().equals(excludedClient.getSessionId())) continue;
            client.send(packet);
        }
        this.dispatch(packet);
    }

    @Override
    public void sendEvent(String name, Object ... data) {
        Packet packet = new Packet(PacketType.MESSAGE);
        packet.setSubType(PacketType.EVENT);
        packet.setName(name);
        packet.setData(Arrays.asList(data));
        this.send(packet);
    }

    public <T> void sendEvent(String name, Object data, BroadcastAckCallback<T> ackCallback) {
        for (SocketIOClient client : this.clients) {
            client.sendEvent(name, ackCallback.createClientCallback(client), data);
        }
        ackCallback.loopFinished();
    }

    public <T> void sendEvent(String name, Object data, SocketIOClient excludedClient, BroadcastAckCallback<T> ackCallback) {
        for (SocketIOClient client : this.clients) {
            if (client.getSessionId().equals(excludedClient.getSessionId())) continue;
            client.sendEvent(name, ackCallback.createClientCallback(client), data);
        }
        ackCallback.loopFinished();
    }
}

