/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio;

import com.corundumstudio.socketio.AckCallback;
import com.corundumstudio.socketio.protocol.AckArgs;
import com.corundumstudio.socketio.protocol.JsonSupport;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JsonSupportWrapper
implements JsonSupport {
    private static final Logger log = LoggerFactory.getLogger(JsonSupportWrapper.class);
    private final JsonSupport delegate;

    JsonSupportWrapper(JsonSupport delegate) {
        this.delegate = delegate;
    }

    @Override
    public AckArgs readAckArgs(ByteBufInputStream src, AckCallback<?> callback) throws IOException {
        try {
            return this.delegate.readAckArgs(src, callback);
        }
        catch (Exception e) {
            src.reset();
            log.error("Can't read ack args: " + src.readLine() + " for type: " + callback.getResultClass(), (Throwable)e);
            throw new IOException(e);
        }
    }

    @Override
    public <T> T readValue(String namespaceName, ByteBufInputStream src, Class<T> valueType) throws IOException {
        try {
            return this.delegate.readValue(namespaceName, src, valueType);
        }
        catch (Exception e) {
            src.reset();
            log.error("Can't read value: " + src.readLine() + " for type: " + valueType, (Throwable)e);
            throw new IOException(e);
        }
    }

    @Override
    public void writeValue(ByteBufOutputStream out, Object value) throws IOException {
        try {
            this.delegate.writeValue(out, value);
        }
        catch (Exception e) {
            log.error("Can't write value: " + value, (Throwable)e);
            throw new IOException(e);
        }
    }

    @Override
    public void addEventMapping(String namespaceName, String eventName, Class<?> ... eventClass) {
        this.delegate.addEventMapping(namespaceName, eventName, eventClass);
    }

    @Override
    public void removeEventMapping(String namespaceName, String eventName) {
        this.delegate.removeEventMapping(namespaceName, eventName);
    }

    @Override
    public List<byte[]> getArrays() {
        return this.delegate.getArrays();
    }
}

