/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.ack;

import com.corundumstudio.socketio.AckCallback;
import com.corundumstudio.socketio.Disconnectable;
import com.corundumstudio.socketio.MultiTypeAckCallback;
import com.corundumstudio.socketio.MultiTypeArgs;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.ack.AckSchedulerKey;
import com.corundumstudio.socketio.handler.ClientHead;
import com.corundumstudio.socketio.protocol.Packet;
import com.corundumstudio.socketio.scheduler.CancelableScheduler;
import com.corundumstudio.socketio.scheduler.SchedulerKey;
import io.netty.util.internal.PlatformDependent;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AckManager
implements Disconnectable {
    private static final Logger log = LoggerFactory.getLogger(AckManager.class);
    private final Map<UUID, AckEntry> ackEntries = PlatformDependent.newConcurrentHashMap();
    private final CancelableScheduler scheduler;

    public AckManager(CancelableScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void initAckIndex(UUID sessionId, long index) {
        AckEntry ackEntry = this.getAckEntry(sessionId);
        ackEntry.initAckIndex(index);
    }

    private AckEntry getAckEntry(UUID sessionId) {
        AckEntry oldAckEntry;
        AckEntry ackEntry = this.ackEntries.get(sessionId);
        if (ackEntry == null && (oldAckEntry = this.ackEntries.put(sessionId, ackEntry = new AckEntry())) != null) {
            ackEntry = oldAckEntry;
        }
        return ackEntry;
    }

    public void onAck(SocketIOClient client, Packet packet) {
        AckSchedulerKey key = new AckSchedulerKey(SchedulerKey.Type.ACK_TIMEOUT, client.getSessionId(), packet.getAckId());
        this.scheduler.cancel(key);
        AckCallback<?> callback = this.removeCallback(client.getSessionId(), packet.getAckId());
        if (callback == null) {
            return;
        }
        if (callback instanceof MultiTypeAckCallback) {
            callback.onSuccess(new MultiTypeArgs((List)packet.getData()));
        } else {
            Object param = null;
            List args = (List)packet.getData();
            if (!args.isEmpty()) {
                param = args.get(0);
            }
            if (args.size() > 1) {
                log.error("Wrong ack args amount. Should be only one argument, but current amount is: {}. Ack id: {}, sessionId: {}", new Object[]{args.size(), packet.getAckId(), client.getSessionId()});
            }
            callback.onSuccess(param);
        }
    }

    private AckCallback<?> removeCallback(UUID sessionId, long index) {
        AckEntry ackEntry = this.ackEntries.get(sessionId);
        if (ackEntry != null) {
            return ackEntry.removeCallback(index);
        }
        return null;
    }

    public AckCallback<?> getCallback(UUID sessionId, long index) {
        AckEntry ackEntry = this.getAckEntry(sessionId);
        return ackEntry.getAckCallback(index);
    }

    public long registerAck(UUID sessionId, AckCallback<?> callback) {
        AckEntry ackEntry = this.getAckEntry(sessionId);
        ackEntry.initAckIndex(0L);
        long index = ackEntry.addAckCallback(callback);
        if (log.isDebugEnabled()) {
            log.debug("AckCallback registered with id: {} for client: {}", (Object)index, (Object)sessionId);
        }
        this.scheduleTimeout(index, sessionId, callback);
        return index;
    }

    private void scheduleTimeout(final long index, final UUID sessionId, AckCallback<?> callback) {
        if (callback.getTimeout() == -1) {
            return;
        }
        AckSchedulerKey key = new AckSchedulerKey(SchedulerKey.Type.ACK_TIMEOUT, sessionId, index);
        this.scheduler.scheduleCallback(key, new Runnable(){

            public void run() {
                AckCallback cb = AckManager.this.removeCallback(sessionId, index);
                if (cb != null) {
                    cb.onTimeout();
                }
            }
        }, callback.getTimeout(), TimeUnit.SECONDS);
    }

    @Override
    public void onDisconnect(ClientHead client) {
        AckEntry e = this.ackEntries.remove(client.getSessionId());
        if (e == null) {
            return;
        }
        Set<Long> indexes = e.getAckIndexes();
        for (Long index : indexes) {
            AckCallback<?> callback = e.getAckCallback(index);
            if (callback != null) {
                callback.onTimeout();
            }
            AckSchedulerKey key = new AckSchedulerKey(SchedulerKey.Type.ACK_TIMEOUT, client.getSessionId(), index);
            this.scheduler.cancel(key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AckEntry {
        final Map<Long, AckCallback<?>> ackCallbacks = PlatformDependent.newConcurrentHashMap();
        final AtomicLong ackIndex = new AtomicLong(-1L);

        AckEntry() {
        }

        public long addAckCallback(AckCallback<?> callback) {
            long index = this.ackIndex.incrementAndGet();
            this.ackCallbacks.put(index, callback);
            return index;
        }

        public Set<Long> getAckIndexes() {
            return this.ackCallbacks.keySet();
        }

        public AckCallback<?> getAckCallback(long index) {
            return this.ackCallbacks.get(index);
        }

        public AckCallback<?> removeCallback(long index) {
            return this.ackCallbacks.remove(index);
        }

        public void initAckIndex(long index) {
            this.ackIndex.compareAndSet(-1L, index);
        }
    }
}

