/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.annotation;

import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.annotation.AnnotationScanner;
import com.corundumstudio.socketio.annotation.OnDisconnect;
import com.corundumstudio.socketio.handler.SocketIOException;
import com.corundumstudio.socketio.listener.DisconnectListener;
import com.corundumstudio.socketio.namespace.Namespace;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnDisconnectScanner
implements AnnotationScanner {
    @Override
    public Class<? extends Annotation> getScanAnnotation() {
        return OnDisconnect.class;
    }

    @Override
    public void addListener(Namespace namespace, final Object object, final Method method, Annotation annotation) {
        namespace.addDisconnectListener(new DisconnectListener(){

            public void onDisconnect(SocketIOClient client) {
                try {
                    method.invoke(object, client);
                }
                catch (InvocationTargetException e) {
                    throw new SocketIOException(e.getCause());
                }
                catch (Exception e) {
                    throw new SocketIOException(e);
                }
            }
        });
    }

    @Override
    public void validate(Method method, Class<?> clazz) {
        if (method.getParameterTypes().length != 1) {
            throw new IllegalArgumentException("Wrong OnDisconnect listener signature: " + clazz + "." + method.getName());
        }
        boolean valid = false;
        for (Class<?> eventType : method.getParameterTypes()) {
            if (!eventType.equals(SocketIOClient.class)) continue;
            valid = true;
        }
        if (!valid) {
            throw new IllegalArgumentException("Wrong OnDisconnect listener signature: " + clazz + "." + method.getName());
        }
    }
}

