/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeIterable<T>
implements Iterable<T>,
Iterator<T> {
    private List<Iterable<T>> iterablesList;
    private Iterable<T>[] iterables;
    private Iterator<Iterator<T>> listIterator;
    private Iterator<T> currentIterator;

    public CompositeIterable(List<Iterable<T>> iterables) {
        this.iterablesList = iterables;
    }

    public CompositeIterable(Iterable<T> ... iterables) {
        this.iterables = iterables;
    }

    public CompositeIterable(CompositeIterable<T> iterable) {
        this.iterables = iterable.iterables;
        this.iterablesList = iterable.iterablesList;
    }

    @Override
    public Iterator<T> iterator() {
        ArrayList<Iterator<T>> iterators = new ArrayList<Iterator<T>>();
        if (this.iterables != null) {
            for (Iterable<T> iterable : this.iterables) {
                iterators.add(iterable.iterator());
            }
        } else {
            for (Iterable<T> iterable : this.iterablesList) {
                iterators.add(iterable.iterator());
            }
        }
        this.listIterator = iterators.iterator();
        this.currentIterator = null;
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.currentIterator == null || !this.currentIterator.hasNext()) {
            while (this.listIterator.hasNext()) {
                Iterator<T> iterator = this.listIterator.next();
                if (!iterator.hasNext()) continue;
                this.currentIterator = iterator;
                return true;
            }
            return false;
        }
        return this.currentIterator.hasNext();
    }

    @Override
    public T next() {
        this.hasNext();
        return this.currentIterator.next();
    }

    @Override
    public void remove() {
        this.currentIterator.remove();
    }
}

