/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.scheduler;

import com.corundumstudio.socketio.scheduler.CancelableScheduler;
import com.corundumstudio.socketio.scheduler.SchedulerKey;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.internal.PlatformDependent;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class HashedWheelTimeoutScheduler
implements CancelableScheduler {
    private final ConcurrentMap<SchedulerKey, Timeout> scheduledFutures = PlatformDependent.newConcurrentHashMap();
    private final HashedWheelTimer executorService = new HashedWheelTimer();
    private volatile ChannelHandlerContext ctx;

    public void update(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    public void cancel(SchedulerKey key) {
        Timeout timeout = (Timeout)this.scheduledFutures.remove(key);
        if (timeout != null) {
            timeout.cancel();
        }
    }

    public void schedule(final Runnable runnable, long delay, TimeUnit unit) {
        this.executorService.newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                runnable.run();
            }
        }, delay, unit);
    }

    public void scheduleCallback(final SchedulerKey key, final Runnable runnable, long delay, TimeUnit unit) {
        Timeout timeout = this.executorService.newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                HashedWheelTimeoutScheduler.this.ctx.executor().execute(new Runnable(){

                    public void run() {
                        try {
                            runnable.run();
                        }
                        finally {
                            HashedWheelTimeoutScheduler.this.scheduledFutures.remove(key);
                        }
                    }
                });
            }
        }, delay, unit);
        this.replaceScheduledFuture(key, timeout);
    }

    public void schedule(final SchedulerKey key, final Runnable runnable, long delay, TimeUnit unit) {
        Timeout timeout = this.executorService.newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                try {
                    runnable.run();
                }
                finally {
                    HashedWheelTimeoutScheduler.this.scheduledFutures.remove(key);
                }
            }
        }, delay, unit);
        this.replaceScheduledFuture(key, timeout);
    }

    public void shutdown() {
        this.executorService.stop();
    }

    private void replaceScheduledFuture(SchedulerKey key, Timeout newTimeout) {
        Timeout oldTimeout = newTimeout.isExpired() ? (Timeout)this.scheduledFutures.remove(key) : this.scheduledFutures.put(key, newTimeout);
        if (oldTimeout != null) {
            oldTimeout.cancel();
        }
    }
}

