/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.store;

import com.corundumstudio.socketio.store.HazelcastPubSubStore;
import com.corundumstudio.socketio.store.HazelcastStore;
import com.corundumstudio.socketio.store.Store;
import com.corundumstudio.socketio.store.pubsub.BaseStoreFactory;
import com.corundumstudio.socketio.store.pubsub.PubSubStore;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.core.HazelcastInstance;
import java.util.Map;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HazelcastStoreFactory
extends BaseStoreFactory {
    private final HazelcastInstance hazelcastClient;
    private final HazelcastInstance hazelcastPub;
    private final HazelcastInstance hazelcastSub;
    private final PubSubStore pubSubStore;

    public HazelcastStoreFactory() {
        this(HazelcastClient.newHazelcastClient());
    }

    public HazelcastStoreFactory(HazelcastInstance instance) {
        this.hazelcastClient = instance;
        this.hazelcastPub = instance;
        this.hazelcastSub = instance;
        this.pubSubStore = new HazelcastPubSubStore(this.hazelcastPub, this.hazelcastSub, this.getNodeId());
    }

    public HazelcastStoreFactory(HazelcastInstance hazelcastClient, HazelcastInstance hazelcastPub, HazelcastInstance hazelcastSub) {
        this.hazelcastClient = hazelcastClient;
        this.hazelcastPub = hazelcastPub;
        this.hazelcastSub = hazelcastSub;
        this.pubSubStore = new HazelcastPubSubStore(hazelcastPub, hazelcastSub, this.getNodeId());
    }

    @Override
    public Store createStore(UUID sessionId) {
        return new HazelcastStore(sessionId, this.hazelcastClient);
    }

    @Override
    public void shutdown() {
        this.hazelcastClient.shutdown();
        this.hazelcastPub.shutdown();
        this.hazelcastSub.shutdown();
    }

    @Override
    public PubSubStore pubSubStore() {
        return this.pubSubStore;
    }

    @Override
    public <K, V> Map<K, V> createMap(String name) {
        return this.hazelcastClient.getMap(name);
    }
}

