/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.store.pubsub;

import com.corundumstudio.socketio.handler.AuthorizeHandler;
import com.corundumstudio.socketio.handler.ClientHead;
import com.corundumstudio.socketio.namespace.NamespacesHub;
import com.corundumstudio.socketio.protocol.JsonSupport;
import com.corundumstudio.socketio.store.StoreFactory;
import com.corundumstudio.socketio.store.pubsub.ConnectMessage;
import com.corundumstudio.socketio.store.pubsub.DisconnectMessage;
import com.corundumstudio.socketio.store.pubsub.DispatchMessage;
import com.corundumstudio.socketio.store.pubsub.JoinLeaveMessage;
import com.corundumstudio.socketio.store.pubsub.PubSubListener;
import com.corundumstudio.socketio.store.pubsub.PubSubStore;
import com.corundumstudio.socketio.store.pubsub.PubSubType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseStoreFactory
implements StoreFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Long nodeId = (long)(Math.random() * 1000000.0);

    protected Long getNodeId() {
        return this.nodeId;
    }

    public void init(final NamespacesHub namespacesHub, final AuthorizeHandler authorizeHandler, JsonSupport jsonSupport) {
        this.pubSubStore().subscribe(PubSubType.DISCONNECT, new PubSubListener<DisconnectMessage>(){

            @Override
            public void onMessage(DisconnectMessage msg) {
                BaseStoreFactory.this.log.debug("{} sessionId: {}", (Object)PubSubType.DISCONNECT, (Object)msg.getSessionId());
            }
        }, DisconnectMessage.class);
        this.pubSubStore().subscribe(PubSubType.CONNECT, new PubSubListener<ConnectMessage>(){

            @Override
            public void onMessage(ConnectMessage msg) {
                authorizeHandler.connect(msg.getSessionId());
                BaseStoreFactory.this.log.debug("{} sessionId: {}", (Object)PubSubType.CONNECT, (Object)msg.getSessionId());
            }
        }, ConnectMessage.class);
        this.pubSubStore().subscribe(PubSubType.DISPATCH, new PubSubListener<DispatchMessage>(){

            @Override
            public void onMessage(DispatchMessage msg) {
                String name = msg.getRoom();
                namespacesHub.get(msg.getNamespace()).dispatch(name, msg.getPacket());
                BaseStoreFactory.this.log.debug("{} packet: {}", (Object)PubSubType.DISPATCH, (Object)msg.getPacket());
            }
        }, DispatchMessage.class);
        this.pubSubStore().subscribe(PubSubType.JOIN, new PubSubListener<JoinLeaveMessage>(){

            @Override
            public void onMessage(JoinLeaveMessage msg) {
                String name = msg.getRoom();
                namespacesHub.get(msg.getNamespace()).join(name, msg.getSessionId());
                BaseStoreFactory.this.log.debug("{} sessionId: {}", (Object)PubSubType.JOIN, (Object)msg.getSessionId());
            }
        }, JoinLeaveMessage.class);
        this.pubSubStore().subscribe(PubSubType.LEAVE, new PubSubListener<JoinLeaveMessage>(){

            @Override
            public void onMessage(JoinLeaveMessage msg) {
                String name = msg.getRoom();
                namespacesHub.get(msg.getNamespace()).leave(name, msg.getSessionId());
                BaseStoreFactory.this.log.debug("{} sessionId: {}", (Object)PubSubType.LEAVE, (Object)msg.getSessionId());
            }
        }, JoinLeaveMessage.class);
    }

    public abstract PubSubStore pubSubStore();

    public void onDisconnect(ClientHead client) {
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (distributed session store, distributed publish/subscribe)";
    }
}

