/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pamirs.schedule;

import com.taobao.pamirs.schedule.strategy.TBScheduleManagerFactory;
import com.taobao.pamirs.schedule.taskmanager.IScheduleDataManager;
import com.taobao.pamirs.schedule.zk.ScheduleStrategyDataManager4ZK;
import com.taobao.pamirs.schedule.zk.ZKManager;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConsoleManager {
    protected static transient Log log = LogFactory.getLog(ConsoleManager.class);
    public static final String configFile = System.getProperty("user.dir") + File.separator + "pamirsScheduleConfig.properties";
    private static TBScheduleManagerFactory scheduleManagerFactory;

    public static boolean isInitial() throws Exception {
        return scheduleManagerFactory != null;
    }

    public static boolean initial() throws Exception {
        if (scheduleManagerFactory != null) {
            return true;
        }
        File file = new File(configFile);
        scheduleManagerFactory = new TBScheduleManagerFactory();
        ConsoleManager.scheduleManagerFactory.start = false;
        if (file.exists()) {
            Properties p = new Properties();
            FileReader reader = new FileReader(file);
            p.load(reader);
            reader.close();
            scheduleManagerFactory.init(p);
            log.info((Object)("\u52a0\u8f7dSchedule\u914d\u7f6e\u6587\u4ef6\uff1a" + configFile));
            return true;
        }
        return false;
    }

    public static TBScheduleManagerFactory getScheduleManagerFactory() throws Exception {
        if (!ConsoleManager.isInitial()) {
            ConsoleManager.initial();
        }
        return scheduleManagerFactory;
    }

    public static IScheduleDataManager getScheduleDataManager() throws Exception {
        if (!ConsoleManager.isInitial()) {
            ConsoleManager.initial();
        }
        return scheduleManagerFactory.getScheduleDataManager();
    }

    public static ScheduleStrategyDataManager4ZK getScheduleStrategyManager() throws Exception {
        if (!ConsoleManager.isInitial()) {
            ConsoleManager.initial();
        }
        return scheduleManagerFactory.getScheduleStrategyManager();
    }

    public static Properties loadConfig() throws IOException {
        Properties properties;
        File file = new File(configFile);
        if (!file.exists()) {
            properties = ZKManager.createProperties();
        } else {
            properties = new Properties();
            FileReader reader = new FileReader(file);
            properties.load(reader);
            reader.close();
        }
        return properties;
    }

    public static void saveConfigInfo(Properties p) throws Exception {
        try {
            FileWriter writer = new FileWriter(configFile);
            p.store(writer, "");
            writer.close();
        }
        catch (Exception ex) {
            throw new Exception("\u4e0d\u80fd\u5199\u5165\u914d\u7f6e\u4fe1\u606f\u5230\u6587\u4ef6\uff1a" + configFile, ex);
        }
        if (scheduleManagerFactory == null) {
            ConsoleManager.initial();
        } else {
            scheduleManagerFactory.reInit(p);
        }
    }

    public static void setScheduleManagerFactory(TBScheduleManagerFactory scheduleManagerFactory) {
        ConsoleManager.scheduleManagerFactory = scheduleManagerFactory;
    }
}

