/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pamirs.schedule.strategy;

import com.taobao.pamirs.schedule.ConsoleManager;
import com.taobao.pamirs.schedule.IScheduleTaskDeal;
import com.taobao.pamirs.schedule.ScheduleUtil;
import com.taobao.pamirs.schedule.strategy.IStrategyTask;
import com.taobao.pamirs.schedule.strategy.InitialThread;
import com.taobao.pamirs.schedule.strategy.ManagerFactoryInfo;
import com.taobao.pamirs.schedule.strategy.ManagerFactoryTimerTask;
import com.taobao.pamirs.schedule.strategy.ScheduleStrategy;
import com.taobao.pamirs.schedule.strategy.ScheduleStrategyRunntime;
import com.taobao.pamirs.schedule.taskmanager.IScheduleDataManager;
import com.taobao.pamirs.schedule.taskmanager.TBScheduleManagerStatic;
import com.taobao.pamirs.schedule.zk.ScheduleDataManager4ZK;
import com.taobao.pamirs.schedule.zk.ScheduleStrategyDataManager4ZK;
import com.taobao.pamirs.schedule.zk.ZKManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class TBScheduleManagerFactory
implements ApplicationContextAware {
    protected static transient Log logger = LogFactory.getLog(TBScheduleManagerFactory.class);
    private Map<String, String> zkConfig;
    protected ZKManager zkManager;
    public boolean start = true;
    private int timerInterval = 2000;
    private IScheduleDataManager scheduleDataManager;
    private ScheduleStrategyDataManager4ZK scheduleStrategyManager;
    private Map<String, List<IStrategyTask>> managerMap = new ConcurrentHashMap<String, List<IStrategyTask>>();
    private ApplicationContext applicationcontext;
    private String uuid;
    private String ip;
    private String hostName;
    private Timer timer;
    private ManagerFactoryTimerTask timerTask;
    protected Lock lock = new ReentrantLock();
    volatile String errorMessage = "No config Zookeeper connect infomation";
    private InitialThread initialThread;

    public TBScheduleManagerFactory() {
        this.ip = ScheduleUtil.getLocalIP();
        this.hostName = ScheduleUtil.getLocalHostName();
    }

    public void init() throws Exception {
        Properties properties = new Properties();
        for (Map.Entry<String, String> e : this.zkConfig.entrySet()) {
            properties.put(e.getKey(), e.getValue());
        }
        this.init(properties);
    }

    public void reInit(Properties p) throws Exception {
        if (this.start || this.timer != null || this.managerMap.size() > 0) {
            throw new Exception("\u8c03\u5ea6\u5668\u6709\u4efb\u52a1\u5904\u7406\uff0c\u4e0d\u80fd\u91cd\u65b0\u521d\u59cb\u5316");
        }
        this.init(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Properties p) throws Exception {
        if (this.initialThread != null) {
            this.initialThread.stopThread();
        }
        this.lock.lock();
        try {
            this.scheduleDataManager = null;
            this.scheduleStrategyManager = null;
            ConsoleManager.setScheduleManagerFactory(this);
            if (this.zkManager != null) {
                this.zkManager.close();
            }
            this.zkManager = new ZKManager(p);
            this.errorMessage = "Zookeeper connecting ......" + this.zkManager.getConnectStr();
            this.initialThread = new InitialThread(this);
            this.initialThread.setName("TBScheduleManagerFactory-initialThread");
            this.initialThread.start();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void initialData() throws Exception {
        this.zkManager.initial();
        this.scheduleDataManager = new ScheduleDataManager4ZK(this.zkManager);
        this.scheduleStrategyManager = new ScheduleStrategyDataManager4ZK(this.zkManager);
        if (this.start) {
            this.scheduleStrategyManager.registerManagerFactory(this);
            if (this.timer == null) {
                this.timer = new Timer("TBScheduleManagerFactory-Timer");
            }
            if (this.timerTask == null) {
                this.timerTask = new ManagerFactoryTimerTask(this);
                this.timer.schedule((TimerTask)this.timerTask, 2000L, (long)this.timerInterval);
            }
        }
    }

    public IStrategyTask createStrategyTask(ScheduleStrategy strategy) throws Exception {
        IStrategyTask result = null;
        if (ScheduleStrategy.Kind.Schedule == strategy.getKind()) {
            String baseTaskType = ScheduleUtil.splitBaseTaskTypeFromTaskType(strategy.getTaskName());
            String ownSign = ScheduleUtil.splitOwnsignFromTaskType(strategy.getTaskName());
            result = new TBScheduleManagerStatic(this, baseTaskType, ownSign, this.scheduleDataManager);
        } else if (ScheduleStrategy.Kind.Java == strategy.getKind()) {
            result = (IStrategyTask)Class.forName(strategy.getTaskName()).newInstance();
            result.initialTaskParameter(strategy.getTaskParameter());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        block11: {
            this.lock.lock();
            try {
                ManagerFactoryInfo stsInfo = null;
                boolean isException = false;
                try {
                    stsInfo = this.getScheduleStrategyManager().loadManagerFactoryInfo(this.getUuid());
                }
                catch (Exception e) {
                    isException = true;
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                if (isException) {
                    try {
                        this.stopServer(null);
                        this.getScheduleStrategyManager().unRregisterManagerFactory(this);
                        break block11;
                    }
                    finally {
                        this.reRegisterManagerFactory();
                    }
                }
                if (!stsInfo.isStart()) {
                    this.stopServer(null);
                    this.getScheduleStrategyManager().unRregisterManagerFactory(this);
                } else {
                    this.reRegisterManagerFactory();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void reRegisterManagerFactory() throws Exception {
        List<String> stopList = this.getScheduleStrategyManager().registerManagerFactory(this);
        for (String strategyName : stopList) {
            this.stopServer(strategyName);
        }
        this.assignScheduleServer();
        this.reRunScheduleServer();
    }

    public void assignScheduleServer() throws Exception {
        for (ScheduleStrategyRunntime run : this.scheduleStrategyManager.loadAllScheduleStrategyRunntimeByUUID(this.uuid)) {
            List<ScheduleStrategyRunntime> factoryList = this.scheduleStrategyManager.loadAllScheduleStrategyRunntimeByTaskType(run.getStrategyName());
            if (factoryList.size() == 0 || !this.isLeader(this.uuid, factoryList)) continue;
            ScheduleStrategy scheduleStrategy = this.scheduleStrategyManager.loadStrategy(run.getStrategyName());
            int[] nums = ScheduleUtil.assignTaskNumber(factoryList.size(), scheduleStrategy.getAssignNum(), scheduleStrategy.getNumOfSingleServer());
            for (int i = 0; i < factoryList.size(); ++i) {
                ScheduleStrategyRunntime factory = factoryList.get(i);
                this.scheduleStrategyManager.updateStrategyRunntimeReqestNum(run.getStrategyName(), factory.getUuid(), nums[i]);
            }
        }
    }

    public boolean isLeader(String uuid, List<ScheduleStrategyRunntime> factoryList) {
        long no = Long.parseLong(uuid.substring(uuid.lastIndexOf("$") + 1));
        for (ScheduleStrategyRunntime server : factoryList) {
            if (no <= Long.parseLong(server.getUuid().substring(server.getUuid().lastIndexOf("$") + 1))) continue;
            return false;
        }
        return true;
    }

    public void reRunScheduleServer() throws Exception {
        for (ScheduleStrategyRunntime run : this.scheduleStrategyManager.loadAllScheduleStrategyRunntimeByUUID(this.uuid)) {
            List<IStrategyTask> list = this.managerMap.get(run.getStrategyName());
            if (list == null) {
                list = new ArrayList<IStrategyTask>();
                this.managerMap.put(run.getStrategyName(), list);
            }
            while (list.size() > run.getRequestNum() && list.size() > 0) {
                IStrategyTask task = list.remove(list.size() - 1);
                try {
                    task.stop();
                }
                catch (Throwable e) {
                    logger.error((Object)("\u6ce8\u9500\u4efb\u52a1\u9519\u8bef\uff1a" + e.getMessage()), e);
                }
            }
            ScheduleStrategy strategy = this.scheduleStrategyManager.loadStrategy(run.getStrategyName());
            while (list.size() < run.getRequestNum()) {
                IStrategyTask result = this.createStrategyTask(strategy);
                list.add(result);
            }
        }
    }

    public void stopServer(String strategyName) throws Exception {
        if (strategyName == null) {
            String[] nameList;
            for (String name : nameList = this.managerMap.keySet().toArray(new String[0])) {
                for (IStrategyTask task : this.managerMap.get(name)) {
                    try {
                        task.stop();
                    }
                    catch (Throwable e) {
                        logger.error((Object)("\u6ce8\u9500\u4efb\u52a1\u9519\u8bef\uff1a" + e.getMessage()), e);
                    }
                }
                this.managerMap.remove(name);
            }
        } else {
            List<IStrategyTask> list = this.managerMap.get(strategyName);
            if (list != null) {
                for (IStrategyTask task : list) {
                    try {
                        task.stop();
                    }
                    catch (Throwable e) {
                        logger.error((Object)("\u6ce8\u9500\u4efb\u52a1\u9519\u8bef\uff1a" + e.getMessage()), e);
                    }
                }
                this.managerMap.remove(strategyName);
            }
        }
    }

    public void reStart() throws Exception {
        try {
            if (this.timer != null) {
                if (this.timerTask != null) {
                    this.timerTask.cancel();
                    this.timerTask = null;
                }
                this.timer.purge();
            }
            this.stopServer(null);
            this.zkManager.close();
            this.uuid = null;
            this.init();
        }
        catch (Throwable e) {
            logger.error((Object)("\u91cd\u542f\u670d\u52a1\u5931\u8d25\uff1a" + e.getMessage()), e);
        }
    }

    public boolean isZookeeperInitialSucess() throws Exception {
        return this.zkManager.checkZookeeperState();
    }

    public String[] getScheduleTaskDealList() {
        return this.applicationcontext.getBeanNamesForType(IScheduleTaskDeal.class);
    }

    public IScheduleDataManager getScheduleDataManager() {
        if (this.scheduleDataManager == null) {
            throw new RuntimeException(this.errorMessage);
        }
        return this.scheduleDataManager;
    }

    public ScheduleStrategyDataManager4ZK getScheduleStrategyManager() {
        if (this.scheduleStrategyManager == null) {
            throw new RuntimeException(this.errorMessage);
        }
        return this.scheduleStrategyManager;
    }

    public void setApplicationContext(ApplicationContext aApplicationcontext) throws BeansException {
        this.applicationcontext = aApplicationcontext;
    }

    public Object getBean(String beanName) {
        return this.applicationcontext.getBean(beanName);
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getIp() {
        return this.ip;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setStart(boolean isStart) {
        this.start = isStart;
    }

    public void setTimerInterval(int timerInterval) {
        this.timerInterval = timerInterval;
    }

    public void setZkConfig(Map<String, String> zkConfig) {
        this.zkConfig = zkConfig;
    }

    public Map<String, String> getZkConfig() {
        return this.zkConfig;
    }
}

