/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pamirs.schedule.taskmanager;

import com.taobao.pamirs.schedule.CronExpression;
import com.taobao.pamirs.schedule.ScheduleUtil;
import com.taobao.pamirs.schedule.taskmanager.HeartBeatTimerTask;
import com.taobao.pamirs.schedule.taskmanager.TBScheduleManager;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class PauseOrResumeScheduleTask
extends TimerTask {
    private static transient Log log = LogFactory.getLog(HeartBeatTimerTask.class);
    public static int TYPE_PAUSE = 1;
    public static int TYPE_RESUME = 2;
    TBScheduleManager manager;
    Timer timer;
    int type;
    String cronTabExpress;

    public PauseOrResumeScheduleTask(TBScheduleManager aManager, Timer aTimer, int aType, String aCronTabExpress) {
        this.manager = aManager;
        this.timer = aTimer;
        this.type = aType;
        this.cronTabExpress = aCronTabExpress;
    }

    @Override
    public void run() {
        try {
            Thread.currentThread().setPriority(10);
            this.cancel();
            Date current = new Date(this.manager.scheduleCenter.getSystemTime());
            CronExpression cexp = new CronExpression(this.cronTabExpress);
            Date nextTime = cexp.getNextValidTimeAfter(current);
            if (this.type == TYPE_PAUSE) {
                this.manager.pause("\u5230\u8fbe\u7ec8\u6b62\u65f6\u95f4,pause\u8c03\u5ea6");
                this.manager.getScheduleServer().setNextRunEndTime(ScheduleUtil.transferDataToString(nextTime));
            } else {
                this.manager.resume("\u5230\u8fbe\u5f00\u59cb\u65f6\u95f4,resume\u8c03\u5ea6");
                this.manager.getScheduleServer().setNextRunStartTime(ScheduleUtil.transferDataToString(nextTime));
            }
            this.timer.schedule((TimerTask)new PauseOrResumeScheduleTask(this.manager, this.timer, this.type, this.cronTabExpress), nextTime);
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }
}

