/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pamirs.schedule.taskmanager;

import com.taobao.pamirs.schedule.ScheduleUtil;
import com.taobao.pamirs.schedule.taskmanager.IScheduleDataManager;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;

public class ScheduleServer {
    private String uuid;
    private long id;
    private String taskType;
    private String baseTaskType;
    private String ownSign;
    private String ip;
    private String hostName;
    private int threadNum;
    private Timestamp registerTime;
    private Timestamp heartBeatTime;
    private Timestamp lastFetchDataTime;
    private String dealInfoDesc;
    private String nextRunStartTime;
    private String nextRunEndTime;
    private Timestamp centerServerTime;
    private long version;
    private boolean isRegister;
    private String managerFactoryUUID;

    public static ScheduleServer createScheduleServer(IScheduleDataManager aScheduleCenter, String aBaseTaskType, String aOwnSign, int aThreadNum) throws Exception {
        ScheduleServer result = new ScheduleServer();
        result.baseTaskType = aBaseTaskType;
        result.ownSign = aOwnSign;
        result.taskType = ScheduleUtil.getTaskTypeByBaseAndOwnSign(aBaseTaskType, aOwnSign);
        result.ip = ScheduleUtil.getLocalIP();
        result.hostName = ScheduleUtil.getLocalHostName();
        result.registerTime = new Timestamp(aScheduleCenter.getSystemTime());
        result.threadNum = aThreadNum;
        result.heartBeatTime = null;
        result.dealInfoDesc = "\u8c03\u5ea6\u521d\u59cb\u5316";
        result.version = 0L;
        result.uuid = result.ip + "$" + UUID.randomUUID().toString().replaceAll("-", "").toUpperCase();
        SimpleDateFormat DATA_FORMAT_yyyyMMdd = new SimpleDateFormat("yyMMdd");
        String s = DATA_FORMAT_yyyyMMdd.format(new Date(aScheduleCenter.getSystemTime()));
        result.id = Long.parseLong(s) * 100000000L + (long)Math.abs(result.uuid.hashCode() % 100000000);
        return result;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public int getThreadNum() {
        return this.threadNum;
    }

    public void setThreadNum(int threadNum) {
        this.threadNum = threadNum;
    }

    public Timestamp getRegisterTime() {
        return this.registerTime;
    }

    public void setRegisterTime(Timestamp registerTime) {
        this.registerTime = registerTime;
    }

    public Timestamp getHeartBeatTime() {
        return this.heartBeatTime;
    }

    public void setHeartBeatTime(Timestamp heartBeatTime) {
        this.heartBeatTime = heartBeatTime;
    }

    public Timestamp getLastFetchDataTime() {
        return this.lastFetchDataTime;
    }

    public void setLastFetchDataTime(Timestamp lastFetchDataTime) {
        this.lastFetchDataTime = lastFetchDataTime;
    }

    public String getDealInfoDesc() {
        return this.dealInfoDesc;
    }

    public void setDealInfoDesc(String dealInfoDesc) {
        this.dealInfoDesc = dealInfoDesc;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public Timestamp getCenterServerTime() {
        return this.centerServerTime;
    }

    public void setCenterServerTime(Timestamp centerServerTime) {
        this.centerServerTime = centerServerTime;
    }

    public String getNextRunStartTime() {
        return this.nextRunStartTime;
    }

    public void setNextRunStartTime(String nextRunStartTime) {
        this.nextRunStartTime = nextRunStartTime;
    }

    public String getNextRunEndTime() {
        return this.nextRunEndTime;
    }

    public void setNextRunEndTime(String nextRunEndTime) {
        this.nextRunEndTime = nextRunEndTime;
    }

    public String getOwnSign() {
        return this.ownSign;
    }

    public void setOwnSign(String ownSign) {
        this.ownSign = ownSign;
    }

    public String getBaseTaskType() {
        return this.baseTaskType;
    }

    public void setBaseTaskType(String baseTaskType) {
        this.baseTaskType = baseTaskType;
    }

    public long getId() {
        return this.id;
    }

    public void setRegister(boolean isRegister) {
        this.isRegister = isRegister;
    }

    public boolean isRegister() {
        return this.isRegister;
    }

    public void setManagerFactoryUUID(String managerFactoryUUID) {
        this.managerFactoryUUID = managerFactoryUUID;
    }

    public String getManagerFactoryUUID() {
        return this.managerFactoryUUID;
    }
}

