/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pamirs.schedule.taskmanager;

import com.taobao.pamirs.schedule.CronExpression;
import com.taobao.pamirs.schedule.IScheduleTaskDeal;
import com.taobao.pamirs.schedule.ScheduleUtil;
import com.taobao.pamirs.schedule.TaskItemDefine;
import com.taobao.pamirs.schedule.strategy.IStrategyTask;
import com.taobao.pamirs.schedule.strategy.TBScheduleManagerFactory;
import com.taobao.pamirs.schedule.taskmanager.HeartBeatTimerTask;
import com.taobao.pamirs.schedule.taskmanager.IScheduleDataManager;
import com.taobao.pamirs.schedule.taskmanager.IScheduleProcessor;
import com.taobao.pamirs.schedule.taskmanager.PauseOrResumeScheduleTask;
import com.taobao.pamirs.schedule.taskmanager.ScheduleServer;
import com.taobao.pamirs.schedule.taskmanager.ScheduleTaskType;
import com.taobao.pamirs.schedule.taskmanager.StatisticsInfo;
import com.taobao.pamirs.schedule.taskmanager.TBScheduleProcessorNotSleep;
import com.taobao.pamirs.schedule.taskmanager.TBScheduleProcessorSleep;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class TBScheduleManager
implements IStrategyTask {
    private static transient Log log = LogFactory.getLog(TBScheduleManager.class);
    private static int nextSerialNumber = 0;
    protected int currentSerialNumber = 0;
    protected ScheduleTaskType taskTypeInfo;
    protected ScheduleServer currenScheduleServer;
    IScheduleTaskDeal taskDealBean;
    IScheduleProcessor processor;
    StatisticsInfo statisticsInfo = new StatisticsInfo();
    boolean isPauseSchedule = true;
    String pauseMessage = "";
    protected List<TaskItemDefine> currentTaskItemList = new ArrayList<TaskItemDefine>();
    protected long lastReloadTaskItemListTime = 0L;
    protected boolean isNeedReloadTaskItem = true;
    private String mBeanName;
    private Timer heartBeatTimer;
    protected IScheduleDataManager scheduleCenter;
    protected String startErrorInfo = null;
    protected boolean isStopSchedule = false;
    protected Lock registerLock = new ReentrantLock();
    protected boolean isRuntimeInfoInitial = false;
    TBScheduleManagerFactory factory;

    TBScheduleManager(TBScheduleManagerFactory aFactory, String baseTaskType, String ownSign, IScheduleDataManager aScheduleCenter) throws Exception {
        this.factory = aFactory;
        this.currentSerialNumber = TBScheduleManager.serialNumber();
        this.scheduleCenter = aScheduleCenter;
        this.taskTypeInfo = this.scheduleCenter.loadTaskTypeBaseInfo(baseTaskType);
        this.scheduleCenter.clearExpireTaskTypeRunningInfo(baseTaskType, ScheduleUtil.getLocalIP() + "\u6e05\u9664\u8fc7\u671fOWN_SIGN\u4fe1\u606f", this.taskTypeInfo.getExpireOwnSignInterval());
        Object dealBean = aFactory.getBean(this.taskTypeInfo.getDealBeanName());
        if (dealBean == null) {
            throw new Exception("SpringBean " + this.taskTypeInfo.getDealBeanName() + " \u4e0d\u5b58\u5728");
        }
        if (!(dealBean instanceof IScheduleTaskDeal)) {
            throw new Exception("SpringBean " + this.taskTypeInfo.getDealBeanName() + " \u6ca1\u6709\u5b9e\u73b0 IScheduleTaskDeal\u63a5\u53e3");
        }
        this.taskDealBean = (IScheduleTaskDeal)dealBean;
        if (this.taskTypeInfo.getJudgeDeadInterval() < this.taskTypeInfo.getHeartBeatRate() * 5L) {
            throw new Exception("\u6570\u636e\u914d\u7f6e\u5b58\u5728\u95ee\u9898\uff0c\u6b7b\u4ea1\u7684\u65f6\u95f4\u95f4\u9694\uff0c\u81f3\u5c11\u8981\u5927\u4e8e\u5fc3\u8df3\u7ebf\u7a0b\u76845\u500d\u3002\u5f53\u524d\u914d\u7f6e\u6570\u636e\uff1aJudgeDeadInterval = " + this.taskTypeInfo.getJudgeDeadInterval() + ",HeartBeatRate = " + this.taskTypeInfo.getHeartBeatRate());
        }
        this.currenScheduleServer = ScheduleServer.createScheduleServer(this.scheduleCenter, baseTaskType, ownSign, this.taskTypeInfo.getThreadNumber());
        this.currenScheduleServer.setManagerFactoryUUID(this.factory.getUuid());
        this.scheduleCenter.registerScheduleServer(this.currenScheduleServer);
        this.mBeanName = "pamirs:name=schedule.ServerMananger." + this.currenScheduleServer.getUuid();
        this.heartBeatTimer = new Timer(this.currenScheduleServer.getTaskType() + "-" + this.currentSerialNumber + "-HeartBeat");
        this.heartBeatTimer.schedule((TimerTask)new HeartBeatTimerTask(this), new Date(this.scheduleCenter.getSystemTime() + 500L), this.taskTypeInfo.getHeartBeatRate());
        this.initial();
    }

    public abstract void initial() throws Exception;

    public abstract void refreshScheduleServerInfo() throws Exception;

    public abstract void assignScheduleTask() throws Exception;

    public abstract List<TaskItemDefine> getCurrentScheduleTaskItemList();

    public abstract int getTaskItemCount();

    public String getTaskType() {
        return this.currenScheduleServer.getTaskType();
    }

    @Override
    public void initialTaskParameter(String taskParameter) {
    }

    private static synchronized int serialNumber() {
        return nextSerialNumber++;
    }

    public int getCurrentSerialNumber() {
        return this.currentSerialNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMemoInfo() {
        try {
            this.currentTaskItemList.clear();
            if (this.processor != null) {
                this.processor.clearAllHasFetchData();
            }
        }
        finally {
            this.isNeedReloadTaskItem = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewriteScheduleInfo() throws Exception {
        this.registerLock.lock();
        try {
            if (this.isStopSchedule) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\u5916\u90e8\u547d\u4ee4\u7ec8\u6b62\u8c03\u5ea6,\u4e0d\u5728\u6ce8\u518c\u8c03\u5ea6\u670d\u52a1\uff0c\u907f\u514d\u9057\u7559\u5783\u573e\u6570\u636e\uff1a" + this.currenScheduleServer.getUuid()));
                }
                return;
            }
            if (this.startErrorInfo == null) {
                this.currenScheduleServer.setDealInfoDesc(this.pauseMessage + ":" + this.statisticsInfo.getDealDescription());
            } else {
                this.currenScheduleServer.setDealInfoDesc(this.startErrorInfo);
            }
            if (!this.scheduleCenter.refreshScheduleServer(this.currenScheduleServer)) {
                this.clearMemoInfo();
                this.scheduleCenter.registerScheduleServer(this.currenScheduleServer);
            }
        }
        finally {
            this.registerLock.unlock();
        }
    }

    public void computerStart() throws Exception {
        boolean isRunNow = false;
        if (this.taskTypeInfo.getPermitRunStartTime() == null) {
            isRunNow = true;
        } else {
            String tmpStr = this.taskTypeInfo.getPermitRunStartTime();
            if (tmpStr.toLowerCase().startsWith("startrun:")) {
                isRunNow = true;
                tmpStr = tmpStr.substring("startrun:".length());
            }
            CronExpression cexpStart = new CronExpression(tmpStr);
            Date current = new Date(this.scheduleCenter.getSystemTime());
            Date firstStartTime = cexpStart.getNextValidTimeAfter(current);
            this.heartBeatTimer.schedule((TimerTask)new PauseOrResumeScheduleTask(this, this.heartBeatTimer, PauseOrResumeScheduleTask.TYPE_RESUME, tmpStr), firstStartTime);
            this.currenScheduleServer.setNextRunStartTime(ScheduleUtil.transferDataToString(firstStartTime));
            if (this.taskTypeInfo.getPermitRunEndTime() == null || this.taskTypeInfo.getPermitRunEndTime().equals("-1")) {
                this.currenScheduleServer.setNextRunEndTime("\u5f53\u4e0d\u80fd\u83b7\u53d6\u5230\u6570\u636e\u7684\u65f6\u5019pause");
            } else {
                String tmpEndStr = this.taskTypeInfo.getPermitRunEndTime();
                CronExpression cexpEnd = new CronExpression(tmpEndStr);
                Date firstEndTime = cexpEnd.getNextValidTimeAfter(firstStartTime);
                Date nowEndTime = cexpEnd.getNextValidTimeAfter(current);
                if (!nowEndTime.equals(firstEndTime) && current.before(nowEndTime)) {
                    isRunNow = true;
                    firstEndTime = nowEndTime;
                }
                this.heartBeatTimer.schedule((TimerTask)new PauseOrResumeScheduleTask(this, this.heartBeatTimer, PauseOrResumeScheduleTask.TYPE_PAUSE, tmpEndStr), firstEndTime);
                this.currenScheduleServer.setNextRunEndTime(ScheduleUtil.transferDataToString(firstEndTime));
            }
        }
        if (isRunNow) {
            this.resume("\u5f00\u542f\u670d\u52a1\u7acb\u5373\u542f\u52a8");
        }
        this.rewriteScheduleInfo();
    }

    public boolean isContinueWhenData() throws Exception {
        if (this.isPauseWhenNoData()) {
            this.pause("\u6ca1\u6709\u6570\u636e,\u6682\u505c\u8c03\u5ea6");
            return false;
        }
        return true;
    }

    public boolean isPauseWhenNoData() {
        if (this.currentTaskItemList.size() > 0 && this.taskTypeInfo.getPermitRunStartTime() != null) {
            return this.taskTypeInfo.getPermitRunEndTime() == null || this.taskTypeInfo.getPermitRunEndTime().equals("-1");
        }
        return false;
    }

    public void pause(String message) throws Exception {
        if (!this.isPauseSchedule) {
            this.isPauseSchedule = true;
            this.pauseMessage = message;
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u6682\u505c\u8c03\u5ea6 \uff1a" + this.currenScheduleServer.getUuid() + ":" + this.statisticsInfo.getDealDescription()));
            }
            if (this.processor != null) {
                this.processor.stopSchedule();
            }
            this.rewriteScheduleInfo();
        }
    }

    public void resume(String message) throws Exception {
        if (this.isPauseSchedule) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u6062\u590d\u8c03\u5ea6:" + this.currenScheduleServer.getUuid()));
            }
            this.isPauseSchedule = false;
            this.pauseMessage = message;
            if (this.taskDealBean != null) {
                if (this.taskTypeInfo.getProcessorType() != null && this.taskTypeInfo.getProcessorType().equalsIgnoreCase("NOTSLEEP")) {
                    this.taskTypeInfo.setProcessorType("NOTSLEEP");
                    this.processor = new TBScheduleProcessorNotSleep(this, this.taskDealBean, this.statisticsInfo);
                } else {
                    this.processor = new TBScheduleProcessorSleep(this, this.taskDealBean, this.statisticsInfo);
                    this.taskTypeInfo.setProcessorType("SLEEP");
                }
            }
            this.rewriteScheduleInfo();
        }
    }

    @Override
    public void stop() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u505c\u6b62\u670d\u52a1\u5668 \uff1a" + this.currenScheduleServer.getUuid()));
        }
        this.isPauseSchedule = false;
        if (this.processor != null) {
            this.processor.stopSchedule();
        } else {
            this.unRegisterScheduleServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unRegisterScheduleServer() throws Exception {
        this.registerLock.lock();
        try {
            if (this.processor != null) {
                this.processor = null;
            }
            if (this.isPauseSchedule) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("\u6ce8\u9500\u670d\u52a1\u5668 \uff1a" + this.currenScheduleServer.getUuid()));
            }
            this.isStopSchedule = true;
            this.heartBeatTimer.cancel();
            this.scheduleCenter.unRegisterScheduleServer(this.currenScheduleServer.getTaskType(), this.currenScheduleServer.getUuid());
        }
        finally {
            this.registerLock.unlock();
        }
    }

    public ScheduleTaskType getTaskTypeInfo() {
        return this.taskTypeInfo;
    }

    public StatisticsInfo getStatisticsInfo() {
        return this.statisticsInfo;
    }

    public void printScheduleServerInfo(String taskType) {
    }

    public ScheduleServer getScheduleServer() {
        return this.currenScheduleServer;
    }

    public String getmBeanName() {
        return this.mBeanName;
    }
}

