/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pamirs.schedule.taskmanager;

import com.taobao.pamirs.schedule.TaskItemDefine;
import com.taobao.pamirs.schedule.strategy.TBScheduleManagerFactory;
import com.taobao.pamirs.schedule.taskmanager.IScheduleDataManager;
import com.taobao.pamirs.schedule.taskmanager.TBScheduleManager;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TBScheduleManagerStatic
extends TBScheduleManager {
    private static transient Log log = LogFactory.getLog(TBScheduleManagerStatic.class);
    protected int taskItemCount = 0;
    protected long lastFetchVersion = -1L;

    public TBScheduleManagerStatic(TBScheduleManagerFactory aFactory, String baseTaskType, String ownSign, IScheduleDataManager aScheduleCenter) throws Exception {
        super(aFactory, baseTaskType, ownSign, aScheduleCenter);
    }

    public void initialRunningInfo() throws Exception {
        this.scheduleCenter.clearExpireScheduleServer(this.currenScheduleServer.getTaskType(), this.taskTypeInfo.getJudgeDeadInterval());
        List<String> list = this.scheduleCenter.loadScheduleServerNames(this.currenScheduleServer.getTaskType());
        if (this.scheduleCenter.isLeader(this.currenScheduleServer.getUuid(), list)) {
            log.debug((Object)(this.currenScheduleServer.getUuid() + ":" + list.size()));
            this.scheduleCenter.initialRunningInfo4Static(this.currenScheduleServer.getBaseTaskType(), this.currenScheduleServer.getOwnSign(), this.currenScheduleServer.getUuid());
        }
    }

    @Override
    public void initial() throws Exception {
        new Thread(this.currenScheduleServer.getTaskType() + "-" + this.currentSerialNumber + "-StartProcess"){

            @Override
            public void run() {
                try {
                    log.info((Object)("\u5f00\u59cb\u83b7\u53d6\u8c03\u5ea6\u4efb\u52a1\u961f\u5217...... of " + TBScheduleManagerStatic.this.currenScheduleServer.getUuid()));
                    while (!TBScheduleManagerStatic.this.isRuntimeInfoInitial) {
                        if (TBScheduleManagerStatic.this.isStopSchedule) {
                            log.debug((Object)("\u5916\u90e8\u547d\u4ee4\u7ec8\u6b62\u8c03\u5ea6,\u9000\u51fa\u8c03\u5ea6\u961f\u5217\u83b7\u53d6\uff1a" + TBScheduleManagerStatic.this.currenScheduleServer.getUuid()));
                            return;
                        }
                        try {
                            TBScheduleManagerStatic.this.initialRunningInfo();
                            TBScheduleManagerStatic.this.isRuntimeInfoInitial = TBScheduleManagerStatic.this.scheduleCenter.isInitialRunningInfoSucuss(TBScheduleManagerStatic.this.currenScheduleServer.getBaseTaskType(), TBScheduleManagerStatic.this.currenScheduleServer.getOwnSign());
                        }
                        catch (Exception e) {
                            log.error((Object)e.getMessage(), (Throwable)e);
                        }
                        if (TBScheduleManagerStatic.this.isRuntimeInfoInitial) continue;
                        Thread.currentThread();
                        Thread.sleep(1000L);
                    }
                    int count = 0;
                    TBScheduleManagerStatic.this.lastReloadTaskItemListTime = TBScheduleManagerStatic.this.scheduleCenter.getSystemTime();
                    while (TBScheduleManagerStatic.this.getCurrentScheduleTaskItemListNow().size() <= 0) {
                        if (TBScheduleManagerStatic.this.isStopSchedule) {
                            log.debug((Object)("\u5916\u90e8\u547d\u4ee4\u7ec8\u6b62\u8c03\u5ea6,\u9000\u51fa\u8c03\u5ea6\u961f\u5217\u83b7\u53d6\uff1a" + TBScheduleManagerStatic.this.currenScheduleServer.getUuid()));
                            return;
                        }
                        Thread.currentThread();
                        Thread.sleep(1000L);
                        ++count;
                    }
                    String tmpStr = "";
                    for (int i = 0; i < TBScheduleManagerStatic.this.currentTaskItemList.size(); ++i) {
                        if (i > 0) {
                            tmpStr = tmpStr + ",";
                        }
                        tmpStr = tmpStr + TBScheduleManagerStatic.this.currentTaskItemList.get(i);
                    }
                    log.info((Object)("\u83b7\u53d6\u5230\u4efb\u52a1\u5904\u7406\u961f\u5217\uff0c\u5f00\u59cb\u8c03\u5ea6\uff1a" + tmpStr + "  of  " + TBScheduleManagerStatic.this.currenScheduleServer.getUuid()));
                    TBScheduleManagerStatic.this.taskItemCount = TBScheduleManagerStatic.this.scheduleCenter.loadAllTaskItem(TBScheduleManagerStatic.this.currenScheduleServer.getTaskType()).size();
                    TBScheduleManagerStatic.this.computerStart();
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    String str = e.getMessage();
                    if (str.length() > 300) {
                        str = str.substring(0, 300);
                    }
                    TBScheduleManagerStatic.this.startErrorInfo = "\u542f\u52a8\u5904\u7406\u5f02\u5e38\uff1a" + str;
                }
            }
        }.start();
    }

    @Override
    public void refreshScheduleServerInfo() throws Exception {
        try {
            this.rewriteScheduleInfo();
            if (!this.isRuntimeInfoInitial) {
                return;
            }
            this.assignScheduleTask();
            boolean tmpBoolean = this.isNeedReLoadTaskItemList();
            if (tmpBoolean != this.isNeedReloadTaskItem) {
                this.isNeedReloadTaskItem = true;
                this.rewriteScheduleInfo();
            }
            if (this.isPauseSchedule || this.processor != null && this.processor.isSleeping()) {
                this.getCurrentScheduleTaskItemListNow();
            }
        }
        catch (Throwable e) {
            this.clearMemoInfo();
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw new Exception(e.getMessage(), e);
        }
    }

    public boolean isNeedReLoadTaskItemList() throws Exception {
        return this.lastFetchVersion < this.scheduleCenter.getReloadTaskItemFlag(this.currenScheduleServer.getTaskType());
    }

    @Override
    public void assignScheduleTask() throws Exception {
        this.scheduleCenter.clearExpireScheduleServer(this.currenScheduleServer.getTaskType(), this.taskTypeInfo.getJudgeDeadInterval());
        List<String> serverList = this.scheduleCenter.loadScheduleServerNames(this.currenScheduleServer.getTaskType());
        if (!this.scheduleCenter.isLeader(this.currenScheduleServer.getUuid(), serverList)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.currenScheduleServer.getUuid() + ":\u4e0d\u662f\u8d1f\u8d23\u4efb\u52a1\u5206\u914d\u7684Leader,\u76f4\u63a5\u8fd4\u56de"));
            }
            return;
        }
        this.scheduleCenter.setInitialRunningInfoSucuss(this.currenScheduleServer.getBaseTaskType(), this.currenScheduleServer.getTaskType(), this.currenScheduleServer.getUuid());
        this.scheduleCenter.clearTaskItem(this.currenScheduleServer.getTaskType(), serverList);
        this.scheduleCenter.assignTaskItem(this.currenScheduleServer.getTaskType(), this.currenScheduleServer.getUuid(), this.taskTypeInfo.getMaxTaskItemsOfOneThreadGroup(), serverList);
    }

    @Override
    public List<TaskItemDefine> getCurrentScheduleTaskItemList() {
        try {
            if (this.isNeedReloadTaskItem) {
                if (this.processor != null) {
                    while (!this.processor.isDealFinishAllData()) {
                        Thread.sleep(50L);
                    }
                }
                this.getCurrentScheduleTaskItemListNow();
            }
            this.lastReloadTaskItemListTime = this.scheduleCenter.getSystemTime();
            return this.currentTaskItemList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected List<TaskItemDefine> getCurrentScheduleTaskItemListNow() throws Exception {
        this.lastFetchVersion = this.scheduleCenter.getReloadTaskItemFlag(this.currenScheduleServer.getTaskType());
        try {
            this.scheduleCenter.releaseDealTaskItem(this.currenScheduleServer.getTaskType(), this.currenScheduleServer.getUuid());
            this.currentTaskItemList.clear();
            this.currentTaskItemList = this.scheduleCenter.reloadDealTaskItem(this.currenScheduleServer.getTaskType(), this.currenScheduleServer.getUuid());
            if (this.currentTaskItemList.size() == 0 && this.scheduleCenter.getSystemTime() - this.lastReloadTaskItemListTime > this.taskTypeInfo.getHeartBeatRate() * 10L) {
                String message = "\u8c03\u5ea6\u670d\u52a1\u5668" + this.currenScheduleServer.getUuid() + "[TASK_TYPE=" + this.currenScheduleServer.getTaskType() + "]\u81ea\u542f\u52a8\u4ee5\u6765\uff0c\u8d85\u8fc710\u4e2a\u5fc3\u8df3\u5468\u671f\uff0c\u8fd8 \u6ca1\u6709\u83b7\u53d6\u5230\u5206\u914d\u7684\u4efb\u52a1\u961f\u5217";
                log.warn((Object)message);
            }
            if (this.currentTaskItemList.size() > 0) {
                this.lastReloadTaskItemListTime = this.scheduleCenter.getSystemTime();
            }
            return this.currentTaskItemList;
        }
        catch (Throwable e) {
            this.lastFetchVersion = -1L;
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw new Exception(e);
        }
    }

    @Override
    public int getTaskItemCount() {
        return this.taskItemCount;
    }
}

