/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pamirs.schedule.taskmanager;

import com.taobao.pamirs.schedule.IScheduleTaskDeal;
import com.taobao.pamirs.schedule.IScheduleTaskDealMulti;
import com.taobao.pamirs.schedule.IScheduleTaskDealSingle;
import com.taobao.pamirs.schedule.TaskItemDefine;
import com.taobao.pamirs.schedule.taskmanager.IScheduleProcessor;
import com.taobao.pamirs.schedule.taskmanager.ScheduleTaskType;
import com.taobao.pamirs.schedule.taskmanager.StatisticsInfo;
import com.taobao.pamirs.schedule.taskmanager.TBScheduleManager;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class TBScheduleProcessorNotSleep<T>
implements IScheduleProcessor,
Runnable {
    private static transient Log logger = LogFactory.getLog(TBScheduleProcessorNotSleep.class);
    List<Thread> threadList = Collections.synchronizedList(new ArrayList());
    protected TBScheduleManager scheduleManager;
    ScheduleTaskType taskTypeInfo;
    protected IScheduleTaskDeal<T> taskDealBean;
    Comparator<T> taskComparator;
    StatisticsInfo statisticsInfo;
    protected List<T> taskList = Collections.synchronizedList(new ArrayList());
    protected List<Object> runningTaskList = Collections.synchronizedList(new ArrayList());
    protected List<T> maybeRepeatTaskList = Collections.synchronizedList(new ArrayList());
    Lock lockFetchID = new ReentrantLock();
    Lock lockFetchMutilID = new ReentrantLock();
    Lock lockLoadData = new ReentrantLock();
    boolean isMutilTask = false;
    boolean isStopSchedule = false;
    boolean isSleeping = false;

    public TBScheduleProcessorNotSleep(TBScheduleManager aManager, IScheduleTaskDeal<T> aTaskDealBean, StatisticsInfo aStatisticsInfo) throws Exception {
        this.scheduleManager = aManager;
        this.statisticsInfo = aStatisticsInfo;
        this.taskTypeInfo = this.scheduleManager.getTaskTypeInfo();
        this.taskDealBean = aTaskDealBean;
        this.taskComparator = new MYComparator(this.taskDealBean.getComparator());
        if (this.taskDealBean instanceof IScheduleTaskDealSingle) {
            if (this.taskTypeInfo.getExecuteNumber() > 1) {
                this.taskTypeInfo.setExecuteNumber(1);
            }
            this.isMutilTask = false;
        } else {
            this.isMutilTask = true;
        }
        if (this.taskTypeInfo.getFetchDataNumber() < this.taskTypeInfo.getThreadNumber() * 10) {
            logger.warn((Object)"\u53c2\u6570\u8bbe\u7f6e\u4e0d\u5408\u7406\uff0c\u7cfb\u7edf\u6027\u80fd\u4e0d\u4f73\u3002\u3010\u6bcf\u6b21\u4ece\u6570\u636e\u5e93\u83b7\u53d6\u7684\u6570\u91cffetchnum\u3011 >= \u3010\u7ebf\u7a0b\u6570\u91cfthreadnum\u3011 *\u3010\u6700\u5c11\u5faa\u73af\u6b21\u657010\u3011 ");
        }
        for (int i = 0; i < this.taskTypeInfo.getThreadNumber(); ++i) {
            this.startThread(i);
        }
    }

    @Override
    public void stopSchedule() throws Exception {
        this.isStopSchedule = true;
        this.taskList.clear();
    }

    private void startThread(int index) {
        Thread thread = new Thread(this);
        this.threadList.add(thread);
        String threadName = this.scheduleManager.getScheduleServer().getTaskType() + "-" + this.scheduleManager.getCurrentSerialNumber() + "-exe" + index;
        thread.setName(threadName);
        thread.start();
    }

    protected boolean isDealing(T aTask) {
        if (this.maybeRepeatTaskList.size() == 0) {
            return false;
        }
        Object[] tmpList = this.maybeRepeatTaskList.toArray();
        for (int i = 0; i < tmpList.length; ++i) {
            if (this.taskComparator.compare(aTask, tmpList[i]) != 0) continue;
            this.maybeRepeatTaskList.remove(tmpList[i]);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getScheduleTaskId() {
        this.lockFetchID.lock();
        try {
            T result = null;
            do {
                if (this.taskList.size() <= 0) {
                    T t = null;
                    return t;
                }
                result = this.taskList.remove(0);
            } while (this.isDealing(result));
            T t = result;
            return t;
        }
        finally {
            this.lockFetchID.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T[] getScheduleTaskIdMulti() {
        this.lockFetchMutilID.lock();
        try {
            if (this.taskList.size() == 0) {
                T[] TArray = null;
                return TArray;
            }
            int size = this.taskList.size() > this.taskTypeInfo.getExecuteNumber() ? this.taskTypeInfo.getExecuteNumber() : this.taskList.size();
            ArrayList result = new ArrayList();
            Object tmpObject = null;
            for (int point = 0; point < size; ++point) {
                T t = this.getScheduleTaskId();
                tmpObject = t;
                if (t == null) break;
                result.add(tmpObject);
            }
            if (result.size() == 0) {
                T[] TArray = null;
                return TArray;
            }
            Object[] objectArray = result.toArray();
            return objectArray;
        }
        finally {
            this.lockFetchMutilID.unlock();
        }
    }

    @Override
    public void clearAllHasFetchData() {
        this.taskList.clear();
    }

    @Override
    public boolean isDealFinishAllData() {
        return this.taskList.size() == 0 && this.runningTaskList.size() == 0;
    }

    @Override
    public boolean isSleeping() {
        return this.isSleeping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int loadScheduleData() {
        this.lockLoadData.lock();
        try {
            if (this.taskList.size() > 0 || this.isStopSchedule) {
                int n = this.taskList.size();
                return n;
            }
            try {
                if (this.taskTypeInfo.getSleepTimeInterval() > 0) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("\u5904\u7406\u5b8c\u4e00\u6279\u6570\u636e\u540e\u4f11\u7720\uff1a" + this.taskTypeInfo.getSleepTimeInterval()));
                    }
                    this.isSleeping = true;
                    Thread.sleep(this.taskTypeInfo.getSleepTimeInterval());
                    this.isSleeping = false;
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)"\u5904\u7406\u5b8c\u4e00\u6279\u6570\u636e\u540e\u4f11\u7720\u540e\u6062\u590d");
                    }
                }
            }
            catch (Throwable ex) {
                logger.error((Object)"\u4f11\u7720\u65f6\u9519\u8bef", ex);
            }
            this.putLastRunningTaskList();
            try {
                List<TaskItemDefine> taskItems = this.scheduleManager.getCurrentScheduleTaskItemList();
                if (taskItems.size() > 0) {
                    List<T> tmpList = this.taskDealBean.selectTasks(this.taskTypeInfo.getTaskParameter(), this.scheduleManager.getScheduleServer().getOwnSign(), this.scheduleManager.getTaskItemCount(), taskItems, this.taskTypeInfo.getFetchDataNumber());
                    this.scheduleManager.getScheduleServer().setLastFetchDataTime(new Timestamp(this.scheduleManager.scheduleCenter.getSystemTime()));
                    if (tmpList != null) {
                        this.taskList.addAll(tmpList);
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)"\u6ca1\u6709\u4efb\u52a1\u5206\u914d");
                }
                this.addFetchNum(this.taskList.size(), "TBScheduleProcessor.loadScheduleData");
                if (this.taskList.size() <= 0 && this.scheduleManager.isContinueWhenData() && this.taskTypeInfo.getSleepTimeNoData() > 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("\u6ca1\u6709\u8bfb\u53d6\u5230\u9700\u8981\u5904\u7406\u7684\u6570\u636e,sleep " + this.taskTypeInfo.getSleepTimeNoData()));
                    }
                    this.isSleeping = true;
                    Thread.sleep(this.taskTypeInfo.getSleepTimeNoData());
                    this.isSleeping = false;
                }
                int n = this.taskList.size();
                return n;
            }
            catch (Throwable ex) {
                logger.error((Object)"\u83b7\u53d6\u4efb\u52a1\u6570\u636e\u9519\u8bef", ex);
                int n = 0;
                this.lockLoadData.unlock();
                return n;
            }
        }
        finally {
            this.lockLoadData.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putLastRunningTaskList() {
        this.lockFetchID.lock();
        try {
            this.maybeRepeatTaskList.clear();
            if (this.runningTaskList.size() == 0) {
                return;
            }
            Object[] tmpList = this.runningTaskList.toArray();
            for (int i = 0; i < tmpList.length; ++i) {
                if (!this.isMutilTask) {
                    this.maybeRepeatTaskList.add(tmpList[i]);
                    continue;
                }
                Object[] aTasks = (Object[])tmpList[i];
                for (int j = 0; j < aTasks.length; ++j) {
                    this.maybeRepeatTaskList.add(aTasks[j]);
                }
            }
        }
        finally {
            this.lockFetchID.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        startTime = 0L;
        sequence = 0L;
        executeTask = null;
        try {
            while (true) lbl-1000:
            // 8 sources

            {
                if (this.isStopSchedule) {
                    var6_5 = this.threadList;
                    synchronized (var6_5) {
                        this.threadList.remove(Thread.currentThread());
                        if (this.threadList.size() == 0) {
                            this.scheduleManager.unRegisterScheduleServer();
                        }
                    }
                    return;
                }
                executeTask = this.isMutilTask == false ? (T[])this.getScheduleTaskId() : this.getScheduleTaskIdMulti();
                if (executeTask == null) {
                    this.loadScheduleData();
                    continue;
                }
                try {
                    this.runningTaskList.add(executeTask);
                    startTime = this.scheduleManager.scheduleCenter.getSystemTime();
                    ++sequence;
                    if (!this.isMutilTask) {
                        if (((IScheduleTaskDealSingle)this.taskDealBean).execute(executeTask, this.scheduleManager.getScheduleServer().getOwnSign())) {
                            this.addSuccessNum(1L, this.scheduleManager.scheduleCenter.getSystemTime() - startTime, "com.taobao.pamirs.schedule.TBScheduleProcessorNotSleep.run");
                        }
                        this.addFailNum(1L, this.scheduleManager.scheduleCenter.getSystemTime() - startTime, "com.taobao.pamirs.schedule.TBScheduleProcessorNotSleep.run");
                    }
                    if (((IScheduleTaskDealMulti)this.taskDealBean).execute(executeTask, this.scheduleManager.getScheduleServer().getOwnSign())) {
                        this.addSuccessNum(executeTask.length, this.scheduleManager.scheduleCenter.getSystemTime() - startTime, "com.taobao.pamirs.schedule.TBScheduleProcessorNotSleep.run");
                    }
                    this.addFailNum(executeTask.length, this.scheduleManager.scheduleCenter.getSystemTime() - startTime, "com.taobao.pamirs.schedule.TBScheduleProcessorNotSleep.run");
                }
                catch (Throwable ex) {
                    if (!this.isMutilTask) {
                        this.addFailNum(1L, this.scheduleManager.scheduleCenter.getSystemTime() - startTime, "TBScheduleProcessor.run");
                    } else {
                        this.addFailNum(executeTask.length, this.scheduleManager.scheduleCenter.getSystemTime() - startTime, "TBScheduleProcessor.run");
                    }
                    TBScheduleProcessorNotSleep.logger.error((Object)("Task :" + executeTask + " \u5904\u7406\u5931\u8d25"), ex);
                }
                finally {
                    this.runningTaskList.remove(executeTask);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        ** GOTO lbl-1000
    }

    public void addFetchNum(long num, String addr) {
        this.statisticsInfo.addFetchDataCount(1L);
        this.statisticsInfo.addFetchDataNum(num);
    }

    public void addSuccessNum(long num, long spendTime, String addr) {
        this.statisticsInfo.addDealDataSucess(num);
        this.statisticsInfo.addDealSpendTime(spendTime);
    }

    public void addFailNum(long num, long spendTime, String addr) {
        this.statisticsInfo.addDealDataFail(num);
        this.statisticsInfo.addDealSpendTime(spendTime);
    }

    class MYComparator
    implements Comparator<T> {
        Comparator<T> comparator;

        public MYComparator(Comparator<T> aComparator) {
            this.comparator = aComparator;
        }

        @Override
        public int compare(T o1, T o2) {
            TBScheduleProcessorNotSleep.this.statisticsInfo.addOtherCompareCount(1L);
            return this.comparator.compare(o1, o2);
        }

        @Override
        public boolean equals(Object obj) {
            return ((Object)this.comparator).equals(obj);
        }
    }
}

