/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pamirs.schedule.taskmanager;

import com.taobao.pamirs.schedule.IScheduleTaskDeal;
import com.taobao.pamirs.schedule.IScheduleTaskDealMulti;
import com.taobao.pamirs.schedule.IScheduleTaskDealSingle;
import com.taobao.pamirs.schedule.TaskItemDefine;
import com.taobao.pamirs.schedule.taskmanager.IScheduleProcessor;
import com.taobao.pamirs.schedule.taskmanager.LockObject;
import com.taobao.pamirs.schedule.taskmanager.ScheduleTaskType;
import com.taobao.pamirs.schedule.taskmanager.StatisticsInfo;
import com.taobao.pamirs.schedule.taskmanager.TBScheduleManager;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class TBScheduleProcessorSleep<T>
implements IScheduleProcessor,
Runnable {
    private static transient Log logger = LogFactory.getLog(TBScheduleProcessorSleep.class);
    final LockObject m_lockObject = new LockObject();
    List<Thread> threadList = Collections.synchronizedList(new ArrayList());
    protected TBScheduleManager scheduleManager;
    ScheduleTaskType taskTypeInfo;
    protected IScheduleTaskDeal<T> taskDealBean;
    protected long taskListVersion = 0L;
    final Object lockVersionObject = new Object();
    final Object lockRunningList = new Object();
    protected List<T> taskList = Collections.synchronizedList(new ArrayList());
    boolean isMutilTask = false;
    boolean isStopSchedule = false;
    boolean isSleeping = false;
    StatisticsInfo statisticsInfo;

    public TBScheduleProcessorSleep(TBScheduleManager aManager, IScheduleTaskDeal<T> aTaskDealBean, StatisticsInfo aStatisticsInfo) throws Exception {
        this.scheduleManager = aManager;
        this.statisticsInfo = aStatisticsInfo;
        this.taskTypeInfo = this.scheduleManager.getTaskTypeInfo();
        this.taskDealBean = aTaskDealBean;
        if (this.taskDealBean instanceof IScheduleTaskDealSingle) {
            if (this.taskTypeInfo.getExecuteNumber() > 1) {
                this.taskTypeInfo.setExecuteNumber(1);
            }
            this.isMutilTask = false;
        } else {
            this.isMutilTask = true;
        }
        if (this.taskTypeInfo.getFetchDataNumber() < this.taskTypeInfo.getThreadNumber() * 10) {
            logger.warn((Object)"\u53c2\u6570\u8bbe\u7f6e\u4e0d\u5408\u7406\uff0c\u7cfb\u7edf\u6027\u80fd\u4e0d\u4f73\u3002\u3010\u6bcf\u6b21\u4ece\u6570\u636e\u5e93\u83b7\u53d6\u7684\u6570\u91cffetchnum\u3011 >= \u3010\u7ebf\u7a0b\u6570\u91cfthreadnum\u3011 *\u3010\u6700\u5c11\u5faa\u73af\u6b21\u657010\u3011 ");
        }
        for (int i = 0; i < this.taskTypeInfo.getThreadNumber(); ++i) {
            this.startThread(i);
        }
    }

    @Override
    public void stopSchedule() throws Exception {
        this.isStopSchedule = true;
        this.taskList.clear();
    }

    private void startThread(int index) {
        Thread thread = new Thread(this);
        this.threadList.add(thread);
        String threadName = this.scheduleManager.getScheduleServer().getTaskType() + "-" + this.scheduleManager.getCurrentSerialNumber() + "-exe" + index;
        thread.setName(threadName);
        thread.start();
    }

    public synchronized Object getScheduleTaskId() {
        if (this.taskList.size() > 0) {
            return this.taskList.remove(0);
        }
        return null;
    }

    public synchronized Object[] getScheduleTaskIdMulti() {
        if (this.taskList.size() == 0) {
            return null;
        }
        int size = this.taskList.size() > this.taskTypeInfo.getExecuteNumber() ? this.taskTypeInfo.getExecuteNumber() : this.taskList.size();
        Object[] result = new Object[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.taskList.remove(0);
        }
        return result;
    }

    @Override
    public void clearAllHasFetchData() {
        this.taskList.clear();
    }

    @Override
    public boolean isDealFinishAllData() {
        return this.taskList.size() == 0;
    }

    @Override
    public boolean isSleeping() {
        return this.isSleeping;
    }

    protected int loadScheduleData() {
        try {
            List<TaskItemDefine> taskItems;
            if (this.taskTypeInfo.getSleepTimeInterval() > 0) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("\u5904\u7406\u5b8c\u4e00\u6279\u6570\u636e\u540e\u4f11\u7720\uff1a" + this.taskTypeInfo.getSleepTimeInterval()));
                }
                this.isSleeping = true;
                Thread.sleep(this.taskTypeInfo.getSleepTimeInterval());
                this.isSleeping = false;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"\u5904\u7406\u5b8c\u4e00\u6279\u6570\u636e\u540e\u4f11\u7720\u540e\u6062\u590d");
                }
            }
            if ((taskItems = this.scheduleManager.getCurrentScheduleTaskItemList()).size() > 0) {
                List<T> tmpList = this.taskDealBean.selectTasks(this.taskTypeInfo.getTaskParameter(), this.scheduleManager.getScheduleServer().getOwnSign(), this.scheduleManager.getTaskItemCount(), taskItems, this.taskTypeInfo.getFetchDataNumber());
                this.scheduleManager.getScheduleServer().setLastFetchDataTime(new Timestamp(this.scheduleManager.scheduleCenter.getSystemTime()));
                if (tmpList != null) {
                    this.taskList.addAll(tmpList);
                }
            } else if (logger.isTraceEnabled()) {
                logger.trace((Object)"\u6ca1\u6709\u83b7\u53d6\u5230\u9700\u8981\u5904\u7406\u7684\u6570\u636e\u961f\u5217");
            }
            this.addFetchNum(this.taskList.size(), "TBScheduleProcessor.loadScheduleData");
            return this.taskList.size();
        }
        catch (Throwable ex) {
            logger.error((Object)"Get tasks error.", ex);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            long startTime = 0L;
            while (true) {
                this.m_lockObject.addThread();
                while (true) {
                    if (this.isStopSchedule) {
                        this.m_lockObject.realseThread();
                        this.m_lockObject.notifyOtherThread();
                        List<Thread> list = this.threadList;
                        synchronized (list) {
                            this.threadList.remove(Thread.currentThread());
                            if (this.threadList.size() == 0) {
                                this.scheduleManager.unRegisterScheduleServer();
                            }
                        }
                        return;
                    }
                    Object[] executeTask = !this.isMutilTask ? this.getScheduleTaskId() : this.getScheduleTaskIdMulti();
                    if (executeTask == null) break;
                    try {
                        startTime = this.scheduleManager.scheduleCenter.getSystemTime();
                        if (!this.isMutilTask) {
                            if (((IScheduleTaskDealSingle)this.taskDealBean).execute(executeTask, this.scheduleManager.getScheduleServer().getOwnSign())) {
                                this.addSuccessNum(1L, this.scheduleManager.scheduleCenter.getSystemTime() - startTime, "com.taobao.pamirs.schedule.TBScheduleProcessorSleep.run");
                                continue;
                            }
                            this.addFailNum(1L, this.scheduleManager.scheduleCenter.getSystemTime() - startTime, "com.taobao.pamirs.schedule.TBScheduleProcessorSleep.run");
                            continue;
                        }
                        if (((IScheduleTaskDealMulti)this.taskDealBean).execute(executeTask, this.scheduleManager.getScheduleServer().getOwnSign())) {
                            this.addSuccessNum(executeTask.length, this.scheduleManager.scheduleCenter.getSystemTime() - startTime, "com.taobao.pamirs.schedule.TBScheduleProcessorSleep.run");
                            continue;
                        }
                        this.addFailNum(executeTask.length, this.scheduleManager.scheduleCenter.getSystemTime() - startTime, "com.taobao.pamirs.schedule.TBScheduleProcessorSleep.run");
                    }
                    catch (Throwable ex) {
                        if (!this.isMutilTask) {
                            this.addFailNum(1L, this.scheduleManager.scheduleCenter.getSystemTime() - startTime, "TBScheduleProcessor.run");
                        } else {
                            this.addFailNum(executeTask.length, this.scheduleManager.scheduleCenter.getSystemTime() - startTime, "TBScheduleProcessor.run");
                        }
                        logger.warn((Object)("Task :" + executeTask + " \u5904\u7406\u5931\u8d25"), ex);
                    }
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)(Thread.currentThread().getName() + "\uff1a\u5f53\u524d\u8fd0\u884c\u7ebf\u7a0b\u6570\u91cf:" + this.m_lockObject.count()));
                }
                if (!this.m_lockObject.realseThreadButNotLast()) {
                    int size = 0;
                    Thread.currentThread();
                    Thread.sleep(100L);
                    startTime = this.scheduleManager.scheduleCenter.getSystemTime();
                    size = this.loadScheduleData();
                    if (size > 0) {
                        this.m_lockObject.notifyOtherThread();
                    } else if (!this.isStopSchedule && this.scheduleManager.isContinueWhenData()) {
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)"\u6ca1\u6709\u88c5\u8f7d\u5230\u6570\u636e\uff0cstart sleep");
                        }
                        this.isSleeping = true;
                        Thread.currentThread();
                        Thread.sleep(this.scheduleManager.getTaskTypeInfo().getSleepTimeNoData());
                        this.isSleeping = false;
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)"Sleep end");
                        }
                    } else {
                        this.m_lockObject.notifyOtherThread();
                    }
                    this.m_lockObject.realseThread();
                    continue;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"\u4e0d\u662f\u6700\u540e\u4e00\u4e2a\u7ebf\u7a0b\uff0csleep");
                }
                this.m_lockObject.waitCurrentThread();
            }
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
            return;
        }
    }

    public void addFetchNum(long num, String addr) {
        this.statisticsInfo.addFetchDataCount(1L);
        this.statisticsInfo.addFetchDataNum(num);
    }

    public void addSuccessNum(long num, long spendTime, String addr) {
        this.statisticsInfo.addDealDataSucess(num);
        this.statisticsInfo.addDealSpendTime(spendTime);
    }

    public void addFailNum(long num, long spendTime, String addr) {
        this.statisticsInfo.addDealDataFail(num);
        this.statisticsInfo.addDealSpendTime(spendTime);
    }
}

