/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pamirs.schedule.zk;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.taobao.pamirs.schedule.ScheduleUtil;
import com.taobao.pamirs.schedule.TaskItemDefine;
import com.taobao.pamirs.schedule.taskmanager.IScheduleDataManager;
import com.taobao.pamirs.schedule.taskmanager.ScheduleServer;
import com.taobao.pamirs.schedule.taskmanager.ScheduleTaskItem;
import com.taobao.pamirs.schedule.taskmanager.ScheduleTaskType;
import com.taobao.pamirs.schedule.taskmanager.ScheduleTaskTypeRunningInfo;
import com.taobao.pamirs.schedule.zk.ScheduleServerComparator;
import com.taobao.pamirs.schedule.zk.TimestampTypeAdapter;
import com.taobao.pamirs.schedule.zk.ZKManager;
import com.taobao.pamirs.schedule.zk.ZKTools;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class ScheduleDataManager4ZK
implements IScheduleDataManager {
    private static transient Log log = LogFactory.getLog(ScheduleDataManager4ZK.class);
    private Gson gson;
    private ZKManager zkManager;
    private String PATH_BaseTaskType;
    private String PATH_TaskItem = "taskItem";
    private String PATH_Server = "server";
    private long zkBaseTime = 0L;
    private long loclaBaseTime = 0L;

    public ScheduleDataManager4ZK(ZKManager aZkManager) throws Exception {
        this.zkManager = aZkManager;
        this.gson = new GsonBuilder().registerTypeAdapter(Timestamp.class, (Object)new TimestampTypeAdapter()).setDateFormat("yyyy-MM-dd HH:mm:ss").create();
        this.PATH_BaseTaskType = this.zkManager.getRootPath() + "/baseTaskType";
        if (this.getZooKeeper().exists(this.PATH_BaseTaskType, false) == null) {
            ZKTools.createPath(this.getZooKeeper(), this.PATH_BaseTaskType, CreateMode.PERSISTENT, this.zkManager.getAcl());
        }
        this.loclaBaseTime = System.currentTimeMillis();
        String tempPath = this.zkManager.getZooKeeper().create(this.zkManager.getRootPath() + "/systime", null, this.zkManager.getAcl(), CreateMode.EPHEMERAL_SEQUENTIAL);
        Stat tempStat = this.zkManager.getZooKeeper().exists(tempPath, false);
        this.zkBaseTime = tempStat.getCtime();
        ZKTools.deleteTree(this.getZooKeeper(), tempPath);
        if (Math.abs(this.zkBaseTime - this.loclaBaseTime) > 5000L) {
            log.fatal((Object)("\u8bf7\u6ce8\u610f\uff0cZookeeper\u670d\u52a1\u5668\u65f6\u95f4\u4e0e\u672c\u5730\u65f6\u95f4\u76f8\u5dee \uff1a " + Math.abs(this.zkBaseTime - this.loclaBaseTime) + " ms"));
        }
    }

    public ZooKeeper getZooKeeper() throws Exception {
        return this.zkManager.getZooKeeper();
    }

    @Override
    public void createBaseTaskType(ScheduleTaskType baseTaskType) throws Exception {
        if (baseTaskType.getBaseTaskType().indexOf("$") > 0) {
            throw new Exception("\u8c03\u5ea6\u4efb\u52a1" + baseTaskType.getBaseTaskType() + "\u540d\u79f0\u4e0d\u80fd\u5305\u62ec\u7279\u6b8a\u5b57\u7b26 $");
        }
        String zkPath = this.PATH_BaseTaskType + "/" + baseTaskType.getBaseTaskType();
        String valueString = this.gson.toJson((Object)baseTaskType);
        if (this.getZooKeeper().exists(zkPath, false) != null) {
            throw new Exception("\u8c03\u5ea6\u4efb\u52a1" + baseTaskType.getBaseTaskType() + "\u5df2\u7ecf\u5b58\u5728,\u5982\u679c\u786e\u8ba4\u9700\u8981\u91cd\u5efa\uff0c\u8bf7\u5148\u8c03\u7528deleteTaskType(String baseTaskType)\u5220\u9664");
        }
        this.getZooKeeper().create(zkPath, valueString.getBytes(), this.zkManager.getAcl(), CreateMode.PERSISTENT);
    }

    @Override
    public void updateBaseTaskType(ScheduleTaskType baseTaskType) throws Exception {
        if (baseTaskType.getBaseTaskType().indexOf("$") > 0) {
            throw new Exception("\u8c03\u5ea6\u4efb\u52a1" + baseTaskType.getBaseTaskType() + "\u540d\u79f0\u4e0d\u80fd\u5305\u62ec\u7279\u6b8a\u5b57\u7b26 $");
        }
        String zkPath = this.PATH_BaseTaskType + "/" + baseTaskType.getBaseTaskType();
        String valueString = this.gson.toJson((Object)baseTaskType);
        if (this.getZooKeeper().exists(zkPath, false) == null) {
            this.getZooKeeper().create(zkPath, valueString.getBytes(), this.zkManager.getAcl(), CreateMode.PERSISTENT);
        } else {
            this.getZooKeeper().setData(zkPath, valueString.getBytes(), -1);
        }
    }

    @Override
    public void initialRunningInfo4Dynamic(String baseTaskType, String ownSign) throws Exception {
        String taskType = ScheduleUtil.getTaskTypeByBaseAndOwnSign(baseTaskType, ownSign);
        String zkPath = this.PATH_BaseTaskType + "/" + baseTaskType + "/" + taskType;
        if (this.getZooKeeper().exists(zkPath, false) == null) {
            this.getZooKeeper().create(zkPath, null, this.zkManager.getAcl(), CreateMode.PERSISTENT);
        }
    }

    @Override
    public void initialRunningInfo4Static(String baseTaskType, String ownSign, String uuid) throws Exception {
        String taskType = ScheduleUtil.getTaskTypeByBaseAndOwnSign(baseTaskType, ownSign);
        String zkPath = this.PATH_BaseTaskType + "/" + baseTaskType + "/" + taskType + "/" + this.PATH_TaskItem;
        ZKTools.deleteTree(this.getZooKeeper(), zkPath);
        this.getZooKeeper().create(zkPath, null, this.zkManager.getAcl(), CreateMode.PERSISTENT);
        this.createScheduleTaskItem(baseTaskType, ownSign, this.loadTaskTypeBaseInfo(baseTaskType).getTaskItems());
        this.setInitialRunningInfoSucuss(baseTaskType, taskType, uuid);
    }

    @Override
    public void setInitialRunningInfoSucuss(String baseTaskType, String taskType, String uuid) throws Exception {
        String zkPath = this.PATH_BaseTaskType + "/" + baseTaskType + "/" + taskType + "/" + this.PATH_TaskItem;
        this.getZooKeeper().setData(zkPath, uuid.getBytes(), -1);
    }

    @Override
    public boolean isInitialRunningInfoSucuss(String baseTaskType, String ownSign) throws Exception {
        byte[] curContent;
        String taskType = ScheduleUtil.getTaskTypeByBaseAndOwnSign(baseTaskType, ownSign);
        String leader = this.getLeader(this.loadScheduleServerNames(taskType));
        String zkPath = this.PATH_BaseTaskType + "/" + baseTaskType + "/" + taskType + "/" + this.PATH_TaskItem;
        return this.getZooKeeper().exists(zkPath, false) != null && (curContent = this.getZooKeeper().getData(zkPath, false, null)) != null && new String(curContent).equals(leader);
    }

    @Override
    public long updateReloadTaskItemFlag(String taskType) throws Exception {
        String baseTaskType = ScheduleUtil.splitBaseTaskTypeFromTaskType(taskType);
        String zkPath = this.PATH_BaseTaskType + "/" + baseTaskType + "/" + taskType + "/" + this.PATH_Server;
        Stat stat = this.getZooKeeper().setData(zkPath, "reload=true".getBytes(), -1);
        return stat.getVersion();
    }

    @Override
    public long getReloadTaskItemFlag(String taskType) throws Exception {
        String baseTaskType = ScheduleUtil.splitBaseTaskTypeFromTaskType(taskType);
        String zkPath = this.PATH_BaseTaskType + "/" + baseTaskType + "/" + taskType + "/" + this.PATH_Server;
        Stat stat = new Stat();
        this.getZooKeeper().getData(zkPath, false, stat);
        return stat.getVersion();
    }

    public void createScheduleTaskItem(String baseTaskType, String ownSign, String[] baseTaskItems) throws Exception {
        ScheduleTaskItem[] taskItems = new ScheduleTaskItem[baseTaskItems.length];
        Pattern p = Pattern.compile("\\s*:\\s*\\{");
        for (int i = 0; i < baseTaskItems.length; ++i) {
            taskItems[i] = new ScheduleTaskItem();
            taskItems[i].setBaseTaskType(baseTaskType);
            taskItems[i].setTaskType(ScheduleUtil.getTaskTypeByBaseAndOwnSign(baseTaskType, ownSign));
            taskItems[i].setOwnSign(ownSign);
            Matcher matcher = p.matcher(baseTaskItems[i]);
            if (matcher.find()) {
                taskItems[i].setTaskItem(baseTaskItems[i].substring(0, matcher.start()).trim());
                taskItems[i].setDealParameter(baseTaskItems[i].substring(matcher.end(), baseTaskItems[i].length() - 1).trim());
            } else {
                taskItems[i].setTaskItem(baseTaskItems[i]);
            }
            taskItems[i].setSts(ScheduleTaskItem.TaskItemSts.ACTIVTE);
        }
        this.createScheduleTaskItem(taskItems);
    }

    @Override
    public void createScheduleTaskItem(ScheduleTaskItem[] taskItems) throws Exception {
        for (ScheduleTaskItem taskItem : taskItems) {
            String zkPath = this.PATH_BaseTaskType + "/" + taskItem.getBaseTaskType() + "/" + taskItem.getTaskType() + "/" + this.PATH_TaskItem;
            if (this.getZooKeeper().exists(zkPath, false) == null) {
                ZKTools.createPath(this.getZooKeeper(), zkPath, CreateMode.PERSISTENT, this.zkManager.getAcl());
            }
            String zkTaskItemPath = zkPath + "/" + taskItem.getTaskItem();
            this.getZooKeeper().create(zkTaskItemPath, null, this.zkManager.getAcl(), CreateMode.PERSISTENT);
            this.getZooKeeper().create(zkTaskItemPath + "/cur_server", null, this.zkManager.getAcl(), CreateMode.PERSISTENT);
            this.getZooKeeper().create(zkTaskItemPath + "/req_server", null, this.zkManager.getAcl(), CreateMode.PERSISTENT);
            this.getZooKeeper().create(zkTaskItemPath + "/sts", taskItem.getSts().toString().getBytes(), this.zkManager.getAcl(), CreateMode.PERSISTENT);
            this.getZooKeeper().create(zkTaskItemPath + "/parameter", taskItem.getDealParameter().getBytes(), this.zkManager.getAcl(), CreateMode.PERSISTENT);
            this.getZooKeeper().create(zkTaskItemPath + "/deal_desc", taskItem.getDealDesc().getBytes(), this.zkManager.getAcl(), CreateMode.PERSISTENT);
        }
    }

    @Override
    public void updateScheduleTaskItemStatus(String taskType, String taskItem, ScheduleTaskItem.TaskItemSts sts, String message) throws Exception {
        String baseTaskType = ScheduleUtil.splitBaseTaskTypeFromTaskType(taskType);
        String zkPath = this.PATH_BaseTaskType + "/" + baseTaskType + "/" + taskType + "/" + this.PATH_TaskItem + "/" + taskItem;
        if (this.getZooKeeper().exists(zkPath + "/sts", false) == null) {
            this.getZooKeeper().setData(zkPath + "/sts", sts.toString().getBytes(), -1);
        }
        if (this.getZooKeeper().exists(zkPath + "/deal_desc", false) == null) {
            if (message == null) {
                message = "";
            }
            this.getZooKeeper().setData(zkPath + "/deal_desc", message.getBytes(), -1);
        }
    }

    @Override
    public void deleteScheduleTaskItem(String taskType, String taskItem) throws Exception {
        String baseTaskType = ScheduleUtil.splitBaseTaskTypeFromTaskType(taskType);
        String zkPath = this.PATH_BaseTaskType + "/" + baseTaskType + "/" + taskType + "/" + this.PATH_TaskItem + "/" + taskItem;
        ZKTools.deleteTree(this.getZooKeeper(), zkPath);
    }

    @Override
    public List<ScheduleTaskItem> loadAllTaskItem(String taskType) throws Exception {
        ArrayList<ScheduleTaskItem> result = new ArrayList<ScheduleTaskItem>();
        String baseTaskType = ScheduleUtil.splitBaseTaskTypeFromTaskType(taskType);
        String zkPath = this.PATH_BaseTaskType + "/" + baseTaskType + "/" + taskType + "/" + this.PATH_TaskItem;
        if (this.getZooKeeper().exists(zkPath, false) == null) {
            return result;
        }
        List taskItems = this.getZooKeeper().getChildren(zkPath, false);
        Collections.sort(taskItems);
        for (String taskItem : taskItems) {
            byte[] dealDescContent;
            byte[] parameterContent;
            byte[] stsContent;
            byte[] reqContent;
            ScheduleTaskItem info = new ScheduleTaskItem();
            info.setTaskType(taskType);
            info.setTaskItem(taskItem);
            String zkTaskItemPath = zkPath + "/" + taskItem;
            byte[] curContent = this.getZooKeeper().getData(zkTaskItemPath + "/cur_server", false, null);
            if (curContent != null) {
                info.setCurrentScheduleServer(new String(curContent));
            }
            if ((reqContent = this.getZooKeeper().getData(zkTaskItemPath + "/req_server", false, null)) != null) {
                info.setRequestScheduleServer(new String(reqContent));
            }
            if ((stsContent = this.getZooKeeper().getData(zkTaskItemPath + "/sts", false, null)) != null) {
                info.setSts(ScheduleTaskItem.TaskItemSts.valueOf(new String(stsContent)));
            }
            if ((parameterContent = this.getZooKeeper().getData(zkTaskItemPath + "/parameter", false, null)) != null) {
                info.setDealParameter(new String(parameterContent));
            }
            if ((dealDescContent = this.getZooKeeper().getData(zkTaskItemPath + "/deal_desc", false, null)) != null) {
                info.setDealDesc(new String(dealDescContent));
            }
            result.add(info);
        }
        return result;
    }

    @Override
    public ScheduleTaskType loadTaskTypeBaseInfo(String baseTaskType) throws Exception {
        String zkPath = this.PATH_BaseTaskType + "/" + baseTaskType;
        if (this.getZooKeeper().exists(zkPath, false) == null) {
            return null;
        }
        String valueString = new String(this.getZooKeeper().getData(zkPath, false, null));
        ScheduleTaskType result = (ScheduleTaskType)this.gson.fromJson(valueString, ScheduleTaskType.class);
        return result;
    }

    @Override
    public List<ScheduleTaskType> getAllTaskTypeBaseInfo() throws Exception {
        String zkPath = this.PATH_BaseTaskType;
        ArrayList<ScheduleTaskType> result = new ArrayList<ScheduleTaskType>();
        List names = this.getZooKeeper().getChildren(zkPath, false);
        Collections.sort(names);
        for (String name : names) {
            result.add(this.loadTaskTypeBaseInfo(name));
        }
        return result;
    }

    @Override
    public void clearTaskType(String baseTaskType) throws Exception {
        String zkPath = this.PATH_BaseTaskType + "/" + baseTaskType;
        List list = this.getZooKeeper().getChildren(zkPath, false);
        for (String name : list) {
            ZKTools.deleteTree(this.getZooKeeper(), zkPath + "/" + name);
        }
    }

    @Override
    public List<ScheduleTaskTypeRunningInfo> getAllTaskTypeRunningInfo(String baseTaskType) throws Exception {
        ArrayList<ScheduleTaskTypeRunningInfo> result = new ArrayList<ScheduleTaskTypeRunningInfo>();
        String zkPath = this.PATH_BaseTaskType + "/" + baseTaskType;
        if (this.getZooKeeper().exists(zkPath, false) == null) {
            return result;
        }
        List list = this.getZooKeeper().getChildren(zkPath, false);
        Collections.sort(list);
        for (String name : list) {
            ScheduleTaskTypeRunningInfo info = new ScheduleTaskTypeRunningInfo();
            info.setBaseTaskType(baseTaskType);
            info.setTaskType(name);
            info.setOwnSign(ScheduleUtil.splitOwnsignFromTaskType(name));
            result.add(info);
        }
        return result;
    }

    @Override
    public void deleteTaskType(String baseTaskType) throws Exception {
        ZKTools.deleteTree(this.getZooKeeper(), this.PATH_BaseTaskType + "/" + baseTaskType);
    }

    @Override
    public List<ScheduleServer> selectScheduleServer(String baseTaskType, String ownSign, String ip, String orderStr) throws Exception {
        ArrayList<String> names = new ArrayList<String>();
        if (baseTaskType != null && ownSign != null) {
            names.add(baseTaskType + "$" + ownSign);
        } else if (baseTaskType != null && ownSign == null) {
            if (this.getZooKeeper().exists(this.PATH_BaseTaskType + "/" + baseTaskType, false) != null) {
                for (String name : this.getZooKeeper().getChildren(this.PATH_BaseTaskType + "/" + baseTaskType, false)) {
                    names.add(name);
                }
            }
        } else if (baseTaskType == null) {
            for (String name : this.getZooKeeper().getChildren(this.PATH_BaseTaskType, false)) {
                if (ownSign != null) {
                    names.add(name + "$" + ownSign);
                    continue;
                }
                for (String str : this.getZooKeeper().getChildren(this.PATH_BaseTaskType + "/" + name, false)) {
                    names.add(str);
                }
            }
        }
        ArrayList<ScheduleServer> result = new ArrayList<ScheduleServer>();
        for (String name : names) {
            List<ScheduleServer> tempList = this.selectAllValidScheduleServer(name);
            if (ip == null) {
                result.addAll(tempList);
                continue;
            }
            for (ScheduleServer server : tempList) {
                if (!ip.equals(server.getIp())) continue;
                result.add(server);
            }
        }
        Collections.sort(result, new ScheduleServerComparator(orderStr));
        return result;
    }

    @Override
    public List<ScheduleServer> selectHistoryScheduleServer(String baseTaskType, String ownSign, String ip, String orderStr) throws Exception {
        throw new Exception("\u6ca1\u6709\u5b9e\u73b0\u7684\u65b9\u6cd5");
    }

    @Override
    public List<TaskItemDefine> reloadDealTaskItem(String taskType, String uuid) throws Exception {
        String baseTaskType = ScheduleUtil.splitBaseTaskTypeFromTaskType(taskType);
        String zkPath = this.PATH_BaseTaskType + "/" + baseTaskType + "/" + taskType + "/" + this.PATH_TaskItem;
        List taskItems = this.getZooKeeper().getChildren(zkPath, false);
        Collections.sort(taskItems);
        ArrayList<TaskItemDefine> result = new ArrayList<TaskItemDefine>();
        for (String name : taskItems) {
            byte[] value = this.getZooKeeper().getData(zkPath + "/" + name + "/cur_server", false, null);
            if (value == null || !uuid.equals(new String(value))) continue;
            TaskItemDefine item = new TaskItemDefine();
            item.setTaskItemId(name);
            byte[] parameterValue = this.getZooKeeper().getData(zkPath + "/" + name + "/parameter", false, null);
            if (parameterValue != null) {
                item.setParameter(new String(parameterValue));
            }
            result.add(item);
        }
        return result;
    }

    @Override
    public void releaseDealTaskItem(String taskType, String uuid) throws Exception {
        String baseTaskType = ScheduleUtil.splitBaseTaskTypeFromTaskType(taskType);
        String zkPath = this.PATH_BaseTaskType + "/" + baseTaskType + "/" + taskType + "/" + this.PATH_TaskItem;
        boolean isModify = false;
        for (String name : this.getZooKeeper().getChildren(zkPath, false)) {
            byte[] curServerValue = this.getZooKeeper().getData(zkPath + "/" + name + "/cur_server", false, null);
            byte[] reqServerValue = this.getZooKeeper().getData(zkPath + "/" + name + "/req_server", false, null);
            if (reqServerValue == null || curServerValue == null || !uuid.equals(new String(curServerValue))) continue;
            this.getZooKeeper().setData(zkPath + "/" + name + "/cur_server", reqServerValue, -1);
            this.getZooKeeper().setData(zkPath + "/" + name + "/req_server", null, -1);
            isModify = true;
        }
        if (isModify) {
            this.updateReloadTaskItemFlag(taskType);
        }
    }

    @Override
    public int queryTaskItemCount(String taskType) throws Exception {
        String baseTaskType = ScheduleUtil.splitBaseTaskTypeFromTaskType(taskType);
        String zkPath = this.PATH_BaseTaskType + "/" + baseTaskType + "/" + taskType + "/" + this.PATH_TaskItem;
        return this.getZooKeeper().getChildren(zkPath, false).size();
    }

    @Override
    public void clearExpireTaskTypeRunningInfo(String baseTaskType, String serverUUID, double expireDateInternal) throws Exception {
        for (String name : this.getZooKeeper().getChildren(this.PATH_BaseTaskType + "/" + baseTaskType, false)) {
            Stat stat = this.getZooKeeper().exists(this.PATH_BaseTaskType + "/" + baseTaskType + "/" + name, false);
            if (this.getSystemTime() - stat.getMtime() <= (long)(expireDateInternal * 24.0 * 3600.0 * 1000.0)) continue;
            ZKTools.deleteTree(this.getZooKeeper(), this.PATH_BaseTaskType + "/" + baseTaskType + "/" + name);
        }
    }

    @Override
    public int clearExpireScheduleServer(String taskType, long expireTime) throws Exception {
        int result = 0;
        String baseTaskType = ScheduleUtil.splitBaseTaskTypeFromTaskType(taskType);
        String zkPath = this.PATH_BaseTaskType + "/" + baseTaskType + "/" + taskType + "/" + this.PATH_Server;
        if (this.getZooKeeper().exists(zkPath, false) == null) {
            String tempPath = this.PATH_BaseTaskType + "/" + baseTaskType + "/" + taskType;
            if (this.getZooKeeper().exists(tempPath, false) == null) {
                this.getZooKeeper().create(tempPath, null, this.zkManager.getAcl(), CreateMode.PERSISTENT);
            }
            this.getZooKeeper().create(zkPath, null, this.zkManager.getAcl(), CreateMode.PERSISTENT);
        }
        for (String name : this.getZooKeeper().getChildren(zkPath, false)) {
            try {
                Stat stat = this.getZooKeeper().exists(zkPath + "/" + name, false);
                if (this.getSystemTime() - stat.getMtime() <= expireTime) continue;
                ZKTools.deleteTree(this.getZooKeeper(), zkPath + "/" + name);
                ++result;
            }
            catch (Exception e) {
                ++result;
            }
        }
        return result;
    }

    @Override
    public int clearTaskItem(String taskType, List<String> serverList) throws Exception {
        String baseTaskType = ScheduleUtil.splitBaseTaskTypeFromTaskType(taskType);
        String zkPath = this.PATH_BaseTaskType + "/" + baseTaskType + "/" + taskType + "/" + this.PATH_TaskItem;
        int result = 0;
        for (String name : this.getZooKeeper().getChildren(zkPath, false)) {
            byte[] curServerValue = this.getZooKeeper().getData(zkPath + "/" + name + "/cur_server", false, null);
            if (curServerValue != null) {
                String curServer = new String(curServerValue);
                boolean isFind = false;
                for (String server : serverList) {
                    if (!curServer.equals(server)) continue;
                    isFind = true;
                    break;
                }
                if (isFind) continue;
                this.getZooKeeper().setData(zkPath + "/" + name + "/cur_server", null, -1);
                ++result;
                continue;
            }
            ++result;
        }
        return result;
    }

    @Override
    public List<String> loadScheduleServerNames(String taskType) throws Exception {
        String baseTaskType = ScheduleUtil.splitBaseTaskTypeFromTaskType(taskType);
        String zkPath = this.PATH_BaseTaskType + "/" + baseTaskType + "/" + taskType + "/" + this.PATH_Server;
        if (this.getZooKeeper().exists(zkPath, false) == null) {
            return new ArrayList<String>();
        }
        List serverList = this.getZooKeeper().getChildren(zkPath, false);
        Collections.sort(serverList, new Comparator<String>(){

            @Override
            public int compare(String u1, String u2) {
                return u1.substring(u1.lastIndexOf("$") + 1).compareTo(u2.substring(u2.lastIndexOf("$") + 1));
            }
        });
        return serverList;
    }

    @Override
    public List<ScheduleServer> selectAllValidScheduleServer(String taskType) throws Exception {
        ArrayList<ScheduleServer> result = new ArrayList<ScheduleServer>();
        String baseTaskType = ScheduleUtil.splitBaseTaskTypeFromTaskType(taskType);
        String zkPath = this.PATH_BaseTaskType + "/" + baseTaskType + "/" + taskType + "/" + this.PATH_Server;
        if (this.getZooKeeper().exists(zkPath, false) == null) {
            return result;
        }
        List serverList = this.getZooKeeper().getChildren(zkPath, false);
        Collections.sort(serverList, new Comparator<String>(){

            @Override
            public int compare(String u1, String u2) {
                return u1.substring(u1.lastIndexOf("$") + 1).compareTo(u2.substring(u2.lastIndexOf("$") + 1));
            }
        });
        for (String name : serverList) {
            try {
                String valueString = new String(this.getZooKeeper().getData(zkPath + "/" + name, false, null));
                ScheduleServer server = (ScheduleServer)this.gson.fromJson(valueString, ScheduleServer.class);
                server.setCenterServerTime(new Timestamp(this.getSystemTime()));
                result.add(server);
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
        }
        return result;
    }

    @Override
    public List<ScheduleServer> selectScheduleServerByManagerFactoryUUID(String factoryUUID) throws Exception {
        ArrayList<ScheduleServer> result = new ArrayList<ScheduleServer>();
        for (String baseTaskType : this.getZooKeeper().getChildren(this.PATH_BaseTaskType, false)) {
            for (String taskType : this.getZooKeeper().getChildren(this.PATH_BaseTaskType + "/" + baseTaskType, false)) {
                String zkPath = this.PATH_BaseTaskType + "/" + baseTaskType + "/" + taskType + "/" + this.PATH_Server;
                for (String uuid : this.getZooKeeper().getChildren(zkPath, false)) {
                    String valueString = new String(this.getZooKeeper().getData(zkPath + "/" + uuid, false, null));
                    ScheduleServer server = (ScheduleServer)this.gson.fromJson(valueString, ScheduleServer.class);
                    server.setCenterServerTime(new Timestamp(this.getSystemTime()));
                    if (!server.getManagerFactoryUUID().equals(factoryUUID)) continue;
                    result.add(server);
                }
            }
        }
        Collections.sort(result, new Comparator<ScheduleServer>(){

            @Override
            public int compare(ScheduleServer u1, ScheduleServer u2) {
                int result = u1.getTaskType().compareTo(u2.getTaskType());
                if (result == 0) {
                    String s1 = u1.getUuid();
                    String s2 = u2.getUuid();
                    result = s1.substring(s1.lastIndexOf("$") + 1).compareTo(s2.substring(s2.lastIndexOf("$") + 1));
                }
                return result;
            }
        });
        return result;
    }

    @Override
    public String getLeader(List<String> serverList) {
        if (serverList == null || serverList.size() == 0) {
            return "";
        }
        long no = Long.MAX_VALUE;
        long tmpNo = -1L;
        String leader = null;
        for (String server : serverList) {
            tmpNo = Long.parseLong(server.substring(server.lastIndexOf("$") + 1));
            if (no <= tmpNo) continue;
            no = tmpNo;
            leader = server;
        }
        return leader;
    }

    @Override
    public boolean isLeader(String uuid, List<String> serverList) {
        return uuid.equals(this.getLeader(serverList));
    }

    @Override
    public void assignTaskItem(String taskType, String currentUuid, int maxNumOfOneServer, List<String> taskServerList) throws Exception {
        if (!this.isLeader(currentUuid, taskServerList)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(currentUuid + ":\u4e0d\u662f\u8d1f\u8d23\u4efb\u52a1\u5206\u914d\u7684Leader,\u76f4\u63a5\u8fd4\u56de"));
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(currentUuid + ":\u5f00\u59cb\u91cd\u65b0\u5206\u914d\u4efb\u52a1......"));
        }
        if (taskServerList.size() <= 0) {
            return;
        }
        String baseTaskType = ScheduleUtil.splitBaseTaskTypeFromTaskType(taskType);
        String zkPath = this.PATH_BaseTaskType + "/" + baseTaskType + "/" + taskType + "/" + this.PATH_TaskItem;
        List children = this.getZooKeeper().getChildren(zkPath, false);
        Collections.sort(children);
        int unModifyCount = 0;
        int[] taskNums = ScheduleUtil.assignTaskNumber(taskServerList.size(), children.size(), maxNumOfOneServer);
        int point = 0;
        int count = 0;
        String NO_SERVER_DEAL = "\u6ca1\u6709\u5206\u914d\u5230\u670d\u52a1\u5668";
        for (int i = 0; i < children.size(); ++i) {
            String name = (String)children.get(i);
            if (point < taskServerList.size() && i >= count + taskNums[point]) {
                count += taskNums[point];
                ++point;
            }
            String serverName = NO_SERVER_DEAL;
            if (point < taskServerList.size()) {
                serverName = taskServerList.get(point);
            }
            byte[] curServerValue = this.getZooKeeper().getData(zkPath + "/" + name + "/cur_server", false, null);
            byte[] reqServerValue = this.getZooKeeper().getData(zkPath + "/" + name + "/req_server", false, null);
            if (curServerValue == null || new String(curServerValue).equals(NO_SERVER_DEAL)) {
                this.getZooKeeper().setData(zkPath + "/" + name + "/cur_server", serverName.getBytes(), -1);
                this.getZooKeeper().setData(zkPath + "/" + name + "/req_server", null, -1);
                continue;
            }
            if (new String(curServerValue).equals(serverName) && reqServerValue == null) {
                ++unModifyCount;
                continue;
            }
            this.getZooKeeper().setData(zkPath + "/" + name + "/req_server", serverName.getBytes(), -1);
        }
        if (unModifyCount < children.size()) {
            this.updateReloadTaskItemFlag(taskType);
        }
        if (log.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            for (ScheduleTaskItem taskItem : this.loadAllTaskItem(taskType)) {
                buffer.append("\n").append(taskItem.toString());
            }
            log.debug((Object)buffer);
        }
    }

    public void assignTaskItem22(String taskType, String currentUuid, List<String> serverList) throws Exception {
        if (!this.isLeader(currentUuid, serverList)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(currentUuid + ":\u4e0d\u662f\u8d1f\u8d23\u4efb\u52a1\u5206\u914d\u7684Leader,\u76f4\u63a5\u8fd4\u56de"));
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(currentUuid + ":\u5f00\u59cb\u91cd\u65b0\u5206\u914d\u4efb\u52a1......"));
        }
        if (serverList.size() <= 0) {
            return;
        }
        String baseTaskType = ScheduleUtil.splitBaseTaskTypeFromTaskType(taskType);
        String zkPath = this.PATH_BaseTaskType + "/" + baseTaskType + "/" + taskType + "/" + this.PATH_TaskItem;
        int point = 0;
        List children = this.getZooKeeper().getChildren(zkPath, false);
        Collections.sort(children);
        int unModifyCount = 0;
        for (String name : children) {
            byte[] curServerValue = this.getZooKeeper().getData(zkPath + "/" + name + "/cur_server", false, null);
            byte[] reqServerValue = this.getZooKeeper().getData(zkPath + "/" + name + "/req_server", false, null);
            if (curServerValue == null) {
                this.getZooKeeper().setData(zkPath + "/" + name + "/cur_server", serverList.get(point).getBytes(), -1);
                this.getZooKeeper().setData(zkPath + "/" + name + "/req_server", null, -1);
            } else if (new String(curServerValue).equals(serverList.get(point)) && reqServerValue == null) {
                ++unModifyCount;
            } else {
                this.getZooKeeper().setData(zkPath + "/" + name + "/req_server", serverList.get(point).getBytes(), -1);
            }
            point = (point + 1) % serverList.size();
        }
        if (unModifyCount < children.size()) {
            this.updateReloadTaskItemFlag(taskType);
        }
        if (log.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            for (ScheduleTaskItem taskItem : this.loadAllTaskItem(taskType)) {
                buffer.append("\n").append(taskItem.toString());
            }
            log.debug((Object)buffer);
        }
    }

    @Override
    public void registerScheduleServer(ScheduleServer server) throws Exception {
        if (server.isRegister()) {
            throw new Exception(server.getUuid() + " \u88ab\u91cd\u590d\u6ce8\u518c");
        }
        String zkPath = this.PATH_BaseTaskType + "/" + server.getBaseTaskType() + "/" + server.getTaskType();
        if (this.getZooKeeper().exists(zkPath, false) == null) {
            this.getZooKeeper().create(zkPath, null, this.zkManager.getAcl(), CreateMode.PERSISTENT);
        }
        zkPath = zkPath + "/" + this.PATH_Server;
        if (this.getZooKeeper().exists(zkPath, false) == null) {
            this.getZooKeeper().create(zkPath, null, this.zkManager.getAcl(), CreateMode.PERSISTENT);
        }
        String realPath = null;
        String zkServerPath = zkPath + "/" + server.getTaskType() + "$" + server.getIp() + "$" + UUID.randomUUID().toString().replaceAll("-", "").toUpperCase() + "$";
        realPath = this.getZooKeeper().create(zkServerPath, null, this.zkManager.getAcl(), CreateMode.PERSISTENT_SEQUENTIAL);
        server.setUuid(realPath.substring(realPath.lastIndexOf("/") + 1));
        Timestamp heartBeatTime = new Timestamp(this.getSystemTime());
        server.setHeartBeatTime(heartBeatTime);
        String valueString = this.gson.toJson((Object)server);
        this.getZooKeeper().setData(realPath, valueString.getBytes(), -1);
        server.setRegister(true);
    }

    @Override
    public boolean refreshScheduleServer(ScheduleServer server) throws Exception {
        Timestamp heartBeatTime = new Timestamp(this.getSystemTime());
        String zkPath = this.PATH_BaseTaskType + "/" + server.getBaseTaskType() + "/" + server.getTaskType() + "/" + this.PATH_Server + "/" + server.getUuid();
        if (this.getZooKeeper().exists(zkPath, false) == null) {
            server.setRegister(false);
            return false;
        }
        Timestamp oldHeartBeatTime = server.getHeartBeatTime();
        server.setHeartBeatTime(heartBeatTime);
        server.setVersion(server.getVersion() + 1L);
        String valueString = this.gson.toJson((Object)server);
        try {
            this.getZooKeeper().setData(zkPath, valueString.getBytes(), -1);
        }
        catch (Exception e) {
            server.setHeartBeatTime(oldHeartBeatTime);
            server.setVersion(server.getVersion() - 1L);
            throw e;
        }
        return true;
    }

    @Override
    public void unRegisterScheduleServer(String taskType, String serverUUID) throws Exception {
        String baseTaskType = ScheduleUtil.splitBaseTaskTypeFromTaskType(taskType);
        String zkPath = this.PATH_BaseTaskType + "/" + baseTaskType + "/" + taskType + "/" + this.PATH_Server + "/" + serverUUID;
        if (this.getZooKeeper().exists(zkPath, false) != null) {
            this.getZooKeeper().delete(zkPath, -1);
        }
    }

    @Override
    public void pauseAllServer(String baseTaskType) throws Exception {
        ScheduleTaskType taskType = this.loadTaskTypeBaseInfo(baseTaskType);
        taskType.setSts(ScheduleTaskType.STS_PAUSE);
        this.updateBaseTaskType(taskType);
    }

    @Override
    public void resumeAllServer(String baseTaskType) throws Exception {
        ScheduleTaskType taskType = this.loadTaskTypeBaseInfo(baseTaskType);
        taskType.setSts(ScheduleTaskType.STS_RESUME);
        this.updateBaseTaskType(taskType);
    }

    @Override
    public long getSystemTime() {
        return this.zkBaseTime + (System.currentTimeMillis() - this.loclaBaseTime);
    }
}

