/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pamirs.schedule.zk;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.taobao.pamirs.schedule.strategy.ManagerFactoryInfo;
import com.taobao.pamirs.schedule.strategy.ScheduleStrategy;
import com.taobao.pamirs.schedule.strategy.ScheduleStrategyRunntime;
import com.taobao.pamirs.schedule.strategy.TBScheduleManagerFactory;
import com.taobao.pamirs.schedule.zk.ConfigNode;
import com.taobao.pamirs.schedule.zk.TimestampTypeAdapter;
import com.taobao.pamirs.schedule.zk.ZKManager;
import com.taobao.pamirs.schedule.zk.ZKTools;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooKeeper;

public class ScheduleStrategyDataManager4ZK {
    private ZKManager zkManager;
    private String PATH_Strategy;
    private String PATH_ManagerFactory;
    private Gson gson;

    public ScheduleStrategyDataManager4ZK(ZKManager aZkManager) throws Exception {
        this.zkManager = aZkManager;
        this.gson = new GsonBuilder().registerTypeAdapter(Timestamp.class, (Object)new TimestampTypeAdapter()).setDateFormat("yyyy-MM-dd HH:mm:ss").create();
        this.PATH_Strategy = this.zkManager.getRootPath() + "/strategy";
        this.PATH_ManagerFactory = this.zkManager.getRootPath() + "/factory";
        if (this.getZooKeeper().exists(this.PATH_Strategy, false) == null) {
            ZKTools.createPath(this.getZooKeeper(), this.PATH_Strategy, CreateMode.PERSISTENT, this.zkManager.getAcl());
        }
        if (this.getZooKeeper().exists(this.PATH_ManagerFactory, false) == null) {
            ZKTools.createPath(this.getZooKeeper(), this.PATH_ManagerFactory, CreateMode.PERSISTENT, this.zkManager.getAcl());
        }
    }

    public ScheduleStrategy loadStrategy(String strategyName) throws Exception {
        String zkPath = this.PATH_Strategy + "/" + strategyName;
        if (this.getZooKeeper().exists(zkPath, false) == null) {
            return null;
        }
        String valueString = new String(this.getZooKeeper().getData(zkPath, false, null));
        ScheduleStrategy result = (ScheduleStrategy)this.gson.fromJson(valueString, ScheduleStrategy.class);
        return result;
    }

    public void createScheduleStrategy(ScheduleStrategy scheduleStrategy) throws Exception {
        String zkPath = this.PATH_Strategy + "/" + scheduleStrategy.getStrategyName();
        String valueString = this.gson.toJson((Object)scheduleStrategy);
        if (this.getZooKeeper().exists(zkPath, false) != null) {
            throw new Exception("\u8c03\u5ea6\u7b56\u7565" + scheduleStrategy.getStrategyName() + "\u5df2\u7ecf\u5b58\u5728,\u5982\u679c\u786e\u8ba4\u9700\u8981\u91cd\u5efa\uff0c\u8bf7\u5148\u8c03\u7528deleteMachineStrategy(String taskType)\u5220\u9664");
        }
        this.getZooKeeper().create(zkPath, valueString.getBytes(), this.zkManager.getAcl(), CreateMode.PERSISTENT);
    }

    public void updateScheduleStrategy(ScheduleStrategy scheduleStrategy) throws Exception {
        String zkPath = this.PATH_Strategy + "/" + scheduleStrategy.getStrategyName();
        String valueString = this.gson.toJson((Object)scheduleStrategy);
        if (this.getZooKeeper().exists(zkPath, false) == null) {
            this.getZooKeeper().create(zkPath, valueString.getBytes(), this.zkManager.getAcl(), CreateMode.PERSISTENT);
        } else {
            this.getZooKeeper().setData(zkPath, valueString.getBytes(), -1);
        }
    }

    public void deleteMachineStrategy(String taskType) throws Exception {
        this.deleteMachineStrategy(taskType, false);
    }

    public void pause(String strategyName) throws Exception {
        ScheduleStrategy strategy = this.loadStrategy(strategyName);
        strategy.setSts(ScheduleStrategy.STS_PAUSE);
        this.updateScheduleStrategy(strategy);
    }

    public void resume(String strategyName) throws Exception {
        ScheduleStrategy strategy = this.loadStrategy(strategyName);
        strategy.setSts(ScheduleStrategy.STS_RESUME);
        this.updateScheduleStrategy(strategy);
    }

    public void deleteMachineStrategy(String taskType, boolean isForce) throws Exception {
        String zkPath = this.PATH_Strategy + "/" + taskType;
        if (!isForce && this.getZooKeeper().getChildren(zkPath, null).size() > 0) {
            throw new Exception("\u4e0d\u80fd\u5220\u9664" + taskType + "\u7684\u8fd0\u884c\u7b56\u7565\uff0c\u4f1a\u5bfc\u81f4\u5fc5\u987b\u91cd\u542f\u6574\u4e2a\u5e94\u7528\u624d\u80fd\u505c\u6b62\u5931\u53bb\u63a7\u5236\u7684\u8c03\u5ea6\u8fdb\u7a0b\u3002" + "\u53ef\u4ee5\u5148\u6e05\u7a7aIP\u5730\u5740\uff0c\u7b49\u6240\u6709\u7684\u8c03\u5ea6\u5668\u90fd\u505c\u6b62\u540e\u518d\u5220\u9664\u8c03\u5ea6\u7b56\u7565");
        }
        ZKTools.deleteTree(this.getZooKeeper(), zkPath);
    }

    public List<ScheduleStrategy> loadAllScheduleStrategy() throws Exception {
        String zkPath = this.PATH_Strategy;
        ArrayList<ScheduleStrategy> result = new ArrayList<ScheduleStrategy>();
        List names = this.getZooKeeper().getChildren(zkPath, false);
        Collections.sort(names);
        for (String name : names) {
            result.add(this.loadStrategy(name));
        }
        return result;
    }

    public List<String> registerManagerFactory(TBScheduleManagerFactory managerFactory) throws Exception {
        if (managerFactory.getUuid() == null) {
            String uuid = managerFactory.getIp() + "$" + managerFactory.getHostName() + "$" + UUID.randomUUID().toString().replaceAll("-", "").toUpperCase();
            String zkPath = this.PATH_ManagerFactory + "/" + uuid + "$";
            zkPath = this.getZooKeeper().create(zkPath, null, this.zkManager.getAcl(), CreateMode.EPHEMERAL_SEQUENTIAL);
            managerFactory.setUuid(zkPath.substring(zkPath.lastIndexOf("/") + 1));
        } else {
            String zkPath = this.PATH_ManagerFactory + "/" + managerFactory.getUuid();
            if (this.getZooKeeper().exists(zkPath, false) == null) {
                zkPath = this.getZooKeeper().create(zkPath, null, this.zkManager.getAcl(), CreateMode.EPHEMERAL);
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        for (ScheduleStrategy scheduleStrategy : this.loadAllScheduleStrategy()) {
            boolean isFind = false;
            if (!ScheduleStrategy.STS_PAUSE.equalsIgnoreCase(scheduleStrategy.getSts()) && scheduleStrategy.getIPList() != null) {
                for (String ip : scheduleStrategy.getIPList()) {
                    if (!ip.equals("127.0.0.1") && !ip.equalsIgnoreCase("localhost") && !ip.equals(managerFactory.getIp()) && !ip.equalsIgnoreCase(managerFactory.getHostName())) continue;
                    String zkPath = this.PATH_Strategy + "/" + scheduleStrategy.getStrategyName() + "/" + managerFactory.getUuid();
                    if (this.getZooKeeper().exists(zkPath, false) == null) {
                        zkPath = this.getZooKeeper().create(zkPath, null, this.zkManager.getAcl(), CreateMode.EPHEMERAL);
                    }
                    isFind = true;
                    break;
                }
            }
            if (isFind) continue;
            String zkPath = this.PATH_Strategy + "/" + scheduleStrategy.getStrategyName() + "/" + managerFactory.getUuid();
            if (this.getZooKeeper().exists(zkPath, false) == null) continue;
            ZKTools.deleteTree(this.getZooKeeper(), zkPath);
            result.add(scheduleStrategy.getStrategyName());
        }
        return result;
    }

    public void unRregisterManagerFactory(TBScheduleManagerFactory managerFactory) throws Exception {
        for (String taskName : this.getZooKeeper().getChildren(this.PATH_Strategy, false)) {
            String zkPath = this.PATH_Strategy + "/" + taskName + "/" + managerFactory.getUuid();
            if (this.getZooKeeper().exists(zkPath, false) == null) continue;
            ZKTools.deleteTree(this.getZooKeeper(), zkPath);
        }
    }

    public ScheduleStrategyRunntime loadScheduleStrategyRunntime(String strategyName, String uuid) throws Exception {
        String zkPath = this.PATH_Strategy + "/" + strategyName + "/" + uuid;
        ScheduleStrategyRunntime result = null;
        if (this.getZooKeeper().exists(zkPath, false) != null) {
            byte[] value = this.getZooKeeper().getData(zkPath, false, null);
            if (value != null) {
                String valueString = new String(this.getZooKeeper().getData(zkPath, false, null));
                result = (ScheduleStrategyRunntime)this.gson.fromJson(valueString, ScheduleStrategyRunntime.class);
            } else {
                result = new ScheduleStrategyRunntime();
                result.setStrategyName(strategyName);
                result.setUuid(uuid);
                result.setRequestNum(0);
                result.setMessage("");
            }
        }
        return result;
    }

    public List<ScheduleStrategyRunntime> loadAllScheduleStrategyRunntime() throws Exception {
        ArrayList<ScheduleStrategyRunntime> result = new ArrayList<ScheduleStrategyRunntime>();
        String zkPath = this.PATH_Strategy;
        for (String taskType : this.getZooKeeper().getChildren(zkPath, false)) {
            for (String uuid : this.getZooKeeper().getChildren(zkPath + "/" + taskType, false)) {
                result.add(this.loadScheduleStrategyRunntime(taskType, uuid));
            }
        }
        return result;
    }

    public List<ScheduleStrategyRunntime> loadAllScheduleStrategyRunntimeByUUID(String managerFactoryUUID) throws Exception {
        ArrayList<ScheduleStrategyRunntime> result = new ArrayList<ScheduleStrategyRunntime>();
        String zkPath = this.PATH_Strategy;
        List taskTypeList = this.getZooKeeper().getChildren(zkPath, false);
        Collections.sort(taskTypeList);
        for (String taskType : taskTypeList) {
            if (this.getZooKeeper().exists(zkPath + "/" + taskType + "/" + managerFactoryUUID, false) == null) continue;
            result.add(this.loadScheduleStrategyRunntime(taskType, managerFactoryUUID));
        }
        return result;
    }

    public List<ScheduleStrategyRunntime> loadAllScheduleStrategyRunntimeByTaskType(String strategyName) throws Exception {
        ArrayList<ScheduleStrategyRunntime> result = new ArrayList<ScheduleStrategyRunntime>();
        String zkPath = this.PATH_Strategy;
        if (this.getZooKeeper().exists(zkPath + "/" + strategyName, false) == null) {
            return result;
        }
        List uuidList = this.getZooKeeper().getChildren(zkPath + "/" + strategyName, false);
        Collections.sort(uuidList, new Comparator<String>(){

            @Override
            public int compare(String u1, String u2) {
                return u1.substring(u1.lastIndexOf("$") + 1).compareTo(u2.substring(u2.lastIndexOf("$") + 1));
            }
        });
        for (String uuid : uuidList) {
            result.add(this.loadScheduleStrategyRunntime(strategyName, uuid));
        }
        return result;
    }

    public void updateStrategyRunntimeReqestNum(String strategyName, String manangerFactoryUUID, int requestNum) throws Exception {
        String zkPath = this.PATH_Strategy + "/" + strategyName + "/" + manangerFactoryUUID;
        ScheduleStrategyRunntime result = null;
        if (this.getZooKeeper().exists(zkPath, false) != null) {
            result = this.loadScheduleStrategyRunntime(strategyName, manangerFactoryUUID);
        } else {
            result = new ScheduleStrategyRunntime();
            result.setStrategyName(strategyName);
            result.setUuid(manangerFactoryUUID);
            result.setRequestNum(requestNum);
            result.setMessage("");
        }
        result.setRequestNum(requestNum);
        String valueString = this.gson.toJson((Object)result);
        this.getZooKeeper().setData(zkPath, valueString.getBytes(), -1);
    }

    public void updateStrategyRunntimeErrorMessage(String strategyName, String manangerFactoryUUID, String message) throws Exception {
        String zkPath = this.PATH_Strategy + "/" + strategyName + "/" + manangerFactoryUUID;
        ScheduleStrategyRunntime result = null;
        if (this.getZooKeeper().exists(zkPath, false) != null) {
            result = this.loadScheduleStrategyRunntime(strategyName, manangerFactoryUUID);
        } else {
            result = new ScheduleStrategyRunntime();
            result.setStrategyName(strategyName);
            result.setUuid(manangerFactoryUUID);
            result.setRequestNum(0);
        }
        result.setMessage(message);
        String valueString = this.gson.toJson((Object)result);
        this.getZooKeeper().setData(zkPath, valueString.getBytes(), -1);
    }

    public void updateManagerFactoryInfo(String uuid, boolean isStart) throws Exception {
        String zkPath = this.PATH_ManagerFactory + "/" + uuid;
        if (this.getZooKeeper().exists(zkPath, false) == null) {
            throw new Exception("\u4efb\u52a1\u7ba1\u7406\u5668\u4e0d\u5b58\u5728:" + uuid);
        }
        this.getZooKeeper().setData(zkPath, Boolean.toString(isStart).getBytes(), -1);
    }

    public ManagerFactoryInfo loadManagerFactoryInfo(String uuid) throws Exception {
        String zkPath = this.PATH_ManagerFactory + "/" + uuid;
        if (this.getZooKeeper().exists(zkPath, false) == null) {
            throw new Exception("\u4efb\u52a1\u7ba1\u7406\u5668\u4e0d\u5b58\u5728:" + uuid);
        }
        byte[] value = this.getZooKeeper().getData(zkPath, false, null);
        ManagerFactoryInfo result = new ManagerFactoryInfo();
        result.setUuid(uuid);
        if (value == null) {
            result.setStart(true);
        } else {
            result.setStart(Boolean.parseBoolean(new String(value)));
        }
        return result;
    }

    public void importConfig(String config, Writer writer, boolean isUpdate) throws Exception {
        ConfigNode configNode = (ConfigNode)this.gson.fromJson(config, ConfigNode.class);
        if (configNode != null) {
            String path = configNode.getRootPath() + "/" + configNode.getConfigType();
            ZKTools.createPath(this.getZooKeeper(), path, CreateMode.PERSISTENT, this.zkManager.getAcl());
            String y_node = path + "/" + configNode.getName();
            if (this.getZooKeeper().exists(y_node, false) == null) {
                writer.append("<font color=\"red\">\u6210\u529f\u5bfc\u5165\u65b0\u914d\u7f6e\u4fe1\u606f\n</font>");
                this.getZooKeeper().create(y_node, configNode.getValue().getBytes(), this.zkManager.getAcl(), CreateMode.PERSISTENT);
            } else if (isUpdate) {
                writer.append("<font color=\"red\">\u8be5\u914d\u7f6e\u4fe1\u606f\u5df2\u7ecf\u5b58\u5728\uff0c\u5e76\u4e14\u5f3a\u5236\u66f4\u65b0\u4e86\n</font>");
                this.getZooKeeper().setData(y_node, configNode.getValue().getBytes(), -1);
            } else {
                writer.append("<font color=\"red\">\u8be5\u914d\u7f6e\u4fe1\u606f\u5df2\u7ecf\u5b58\u5728\uff0c\u5982\u679c\u9700\u8981\u66f4\u65b0\uff0c\u8bf7\u914d\u7f6e\u5f3a\u5236\u66f4\u65b0\n</font>");
            }
        }
        writer.append(configNode.toString());
    }

    public StringBuffer exportConfig(String rootPath, Writer writer) throws Exception {
        StringBuffer buffer = new StringBuffer();
        for (String type : new String[]{"baseTaskType", "strategy"}) {
            if (type.equals("baseTaskType")) {
                writer.write("<h2>\u57fa\u672c\u4efb\u52a1\u914d\u7f6e\u5217\u8868\uff1a</h2>\n");
            } else {
                writer.write("<h2>\u57fa\u672c\u7b56\u7565\u914d\u7f6e\u5217\u8868\uff1a</h2>\n");
            }
            String bTTypePath = rootPath + "/" + type;
            List fNodeList = this.getZooKeeper().getChildren(bTTypePath, false);
            for (int i = 0; i < fNodeList.size(); ++i) {
                String fNode = (String)fNodeList.get(i);
                ConfigNode configNode = new ConfigNode(rootPath, type, fNode);
                configNode.setValue(new String(this.getZooKeeper().getData(bTTypePath + "/" + fNode, false, null)));
                buffer.append(this.gson.toJson((Object)configNode));
                buffer.append("\n");
                writer.write(configNode.toString());
            }
            writer.write("\n\n");
        }
        if (buffer.length() > 0) {
            String str = buffer.toString();
            return new StringBuffer(str.substring(0, str.length() - 1));
        }
        return buffer;
    }

    public List<ManagerFactoryInfo> loadAllManagerFactoryInfo() throws Exception {
        String zkPath = this.PATH_ManagerFactory;
        ArrayList<ManagerFactoryInfo> result = new ArrayList<ManagerFactoryInfo>();
        List names = this.getZooKeeper().getChildren(zkPath, false);
        Collections.sort(names, new Comparator<String>(){

            @Override
            public int compare(String u1, String u2) {
                return u1.substring(u1.lastIndexOf("$") + 1).compareTo(u2.substring(u2.lastIndexOf("$") + 1));
            }
        });
        for (String name : names) {
            ManagerFactoryInfo info = new ManagerFactoryInfo();
            info.setUuid(name);
            byte[] value = this.getZooKeeper().getData(zkPath + "/" + name, false, null);
            if (value == null) {
                info.setStart(true);
            } else {
                info.setStart(Boolean.parseBoolean(new String(value)));
            }
            result.add(info);
        }
        return result;
    }

    public void printTree(String path, Writer writer, String lineSplitChar) throws Exception {
        ZKTools.printTree(this.getZooKeeper(), path, writer, lineSplitChar);
    }

    public void deleteTree(String path) throws Exception {
        ZKTools.deleteTree(this.getZooKeeper(), path);
    }

    public ZooKeeper getZooKeeper() throws Exception {
        return this.zkManager.getZooKeeper();
    }

    public String getRootPath() {
        return this.zkManager.getRootPath();
    }
}

