/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pamirs.schedule.zk;

import com.taobao.pamirs.schedule.zk.Version;
import com.taobao.pamirs.schedule.zk.ZKTools;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.server.auth.DigestAuthenticationProvider;

public class ZKManager
implements Watcher {
    private static transient Log log = LogFactory.getLog(ZKManager.class);
    private ZooKeeper zk;
    private List<ACL> acl = new ArrayList<ACL>();
    private Properties properties;
    private boolean isCheckParentPath = true;

    public ZKManager(Properties aProperties) throws Exception {
        this.properties = aProperties;
        this.createZooKeeper();
    }

    private void createZooKeeper() throws Exception {
        String authString = this.properties.getProperty(keys.userName.toString()) + ":" + this.properties.getProperty(keys.password.toString());
        this.zk = new ZooKeeper(this.properties.getProperty(keys.zkConnectString.toString()), Integer.parseInt(this.properties.getProperty(keys.zkSessionTimeout.toString())), (Watcher)this);
        this.isCheckParentPath = Boolean.parseBoolean(this.properties.getProperty(keys.isCheckParentPath.toString(), "true"));
        this.zk.addAuthInfo("digest", authString.getBytes());
        this.acl.add(new ACL(31, new Id("digest", DigestAuthenticationProvider.generateDigest((String)authString))));
        this.acl.add(new ACL(1, ZooDefs.Ids.ANYONE_ID_UNSAFE));
    }

    public synchronized void reConnection() throws Exception {
        if (this.zk.getState() == ZooKeeper.States.CLOSED) {
            if (this.zk != null) {
                this.zk.close();
                this.zk = null;
            }
            this.createZooKeeper();
        }
    }

    public void process(WatchedEvent event) {
        if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
            log.info((Object)"\u6536\u5230ZK\u8fde\u63a5\u6210\u529f\u4e8b\u4ef6\uff01");
        } else if (event.getState() == Watcher.Event.KeeperState.Expired) {
            log.error((Object)"\u4f1a\u8bdd\u8d85\u65f6\uff0c\u7b49\u5f85\u91cd\u65b0\u5efa\u7acbZK\u8fde\u63a5...");
            try {
                this.reConnection();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            log.info((Object)("\u5df2\u7ecf\u89e6\u53d1\u4e86" + event.getType() + ":" + event.getState() + "\u4e8b\u4ef6\uff01" + event.getPath()));
        }
    }

    public void close() throws InterruptedException {
        log.info((Object)"\u5173\u95edzookeeper\u8fde\u63a5");
        this.zk.close();
    }

    public static Properties createProperties() {
        Properties result = new Properties();
        result.setProperty(keys.zkConnectString.toString(), "localhost:2181");
        result.setProperty(keys.rootPath.toString(), "/taobao-pamirs-schedule/huijin");
        result.setProperty(keys.userName.toString(), "ScheduleAdmin");
        result.setProperty(keys.password.toString(), "password");
        result.setProperty(keys.zkSessionTimeout.toString(), "60000");
        result.setProperty(keys.isCheckParentPath.toString(), "true");
        return result;
    }

    public String getRootPath() {
        return this.properties.getProperty(keys.rootPath.toString());
    }

    public String getConnectStr() {
        return this.properties.getProperty(keys.zkConnectString.toString());
    }

    public boolean checkZookeeperState() throws Exception {
        return this.zk.getState() == ZooKeeper.States.CONNECTED;
    }

    public void initial() throws Exception {
        if (this.zk.exists(this.getRootPath(), false) == null) {
            ZKTools.createPath(this.zk, this.getRootPath(), CreateMode.PERSISTENT, this.acl);
            if (this.isCheckParentPath) {
                ZKManager.checkParent(this.zk, this.getRootPath());
            }
            this.zk.setData(this.getRootPath(), Version.getVersion().getBytes(), -1);
        } else {
            byte[] value;
            if (this.isCheckParentPath) {
                ZKManager.checkParent(this.zk, this.getRootPath());
            }
            if ((value = this.zk.getData(this.getRootPath(), false, null)) == null) {
                this.zk.setData(this.getRootPath(), Version.getVersion().getBytes(), -1);
            } else {
                String dataVersion = new String(value);
                if (!Version.isCompatible(dataVersion)) {
                    throw new Exception("Pamirs-Schedule\u7a0b\u5e8f\u7248\u672c " + Version.getVersion() + " \u4e0d\u517c\u5bb9Zookeeper\u4e2d\u7684\u6570\u636e\u7248\u672c " + dataVersion);
                }
                log.info((Object)("\u5f53\u524d\u7684\u7a0b\u5e8f\u7248\u672c:" + Version.getVersion() + " \u6570\u636e\u7248\u672c: " + dataVersion));
            }
        }
    }

    public static void checkParent(ZooKeeper zk, String path) throws Exception {
        String[] list = path.split("/");
        String zkPath = "";
        for (int i = 0; i < list.length - 1; ++i) {
            String tmpVersion;
            byte[] value;
            String str = list[i];
            if (str.equals("") || zk.exists(zkPath = zkPath + "/" + str, false) == null || (value = zk.getData(zkPath, false, null)) == null || (tmpVersion = new String(value)).indexOf("taobao-pamirs-schedule-") < 0) continue;
            throw new Exception("\"" + zkPath + "\"  is already a schedule instance's root directory, its any subdirectory cannot as the root directory of others");
        }
    }

    public List<ACL> getAcl() {
        return this.acl;
    }

    public ZooKeeper getZooKeeper() throws Exception {
        if (!this.checkZookeeperState()) {
            throw new Exception("Zookeeper[" + this.getConnectStr() + "] connect error :" + this.zk.getState());
        }
        return this.zk;
    }

    public static enum keys {
        zkConnectString,
        rootPath,
        userName,
        password,
        zkSessionTimeout,
        isCheckParentPath;

    }
}

