/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pamirs.schedule.zk;

import com.taobao.pamirs.schedule.zk.ScheduleWatcher;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public class ZKTools {
    public static void main(String[] args) throws Exception {
        ArrayList acl = ZooDefs.Ids.OPEN_ACL_UNSAFE;
        ZooKeeper zk = new ZooKeeper("localhost:2181", 3000, (Watcher)new ScheduleWatcher());
        String path = "/pamirs-schedule";
        for (String s : ZKTools.getTree(zk, path)) {
            System.out.println(s);
        }
        ZKTools.createPath(zk, "/dd/aa/bb", CreateMode.PERSISTENT, acl);
    }

    public static void createPath(ZooKeeper zk, String path, CreateMode createMode, List<ACL> acl) throws Exception {
        String[] list = path.split("/");
        String zkPath = "";
        for (String str : list) {
            if (str.equals("") || zk.exists(zkPath = zkPath + "/" + str, false) != null) continue;
            zk.create(zkPath, null, acl, createMode);
        }
    }

    public static void printTree(ZooKeeper zk, String path, Writer writer, String lineSplitChar) throws Exception {
        String[] list = ZKTools.getTree(zk, path);
        Stat stat = new Stat();
        for (String name : list) {
            byte[] value = zk.getData(name, false, stat);
            if (value == null) {
                writer.write(name + lineSplitChar);
                continue;
            }
            writer.write(name + "[v." + stat.getVersion() + "]" + "[" + new String(value) + "]" + lineSplitChar);
        }
    }

    public static void deleteTree(ZooKeeper zk, String path) throws Exception {
        String[] list = ZKTools.getTree(zk, path);
        for (int i = list.length - 1; i >= 0; --i) {
            zk.delete(list[i], -1);
        }
    }

    public static String[] getTree(ZooKeeper zk, String path) throws Exception {
        if (zk.exists(path, false) == null) {
            return new String[0];
        }
        ArrayList<String> dealList = new ArrayList<String>();
        dealList.add(path);
        for (int index = 0; index < dealList.size(); ++index) {
            String tempPath = (String)dealList.get(index);
            List children = zk.getChildren(tempPath, false);
            if (!tempPath.equalsIgnoreCase("/")) {
                tempPath = tempPath + "/";
            }
            Collections.sort(children);
            for (int i = children.size() - 1; i >= 0; --i) {
                dealList.add(index + 1, tempPath + (String)children.get(i));
            }
        }
        return dealList.toArray(new String[0]);
    }
}

