/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.iconloader.util;

import com.bulenkov.iconloader.IconLoader;
import com.bulenkov.iconloader.RetinaImage;
import com.bulenkov.iconloader.util.BufferExposingByteArrayOutputStream;
import com.bulenkov.iconloader.util.ConcurrentSoftValueHashMap;
import com.bulenkov.iconloader.util.ImageUtil;
import com.bulenkov.iconloader.util.JBUI;
import com.bulenkov.iconloader.util.Pair;
import com.bulenkov.iconloader.util.ReflectionUtil;
import com.bulenkov.iconloader.util.Scalr;
import com.bulenkov.iconloader.util.UIUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageLoader
implements Serializable {
    private static final ConcurrentMap<String, Image> ourCache = new ConcurrentSoftValueHashMap<String, Image>();
    public static final Component ourComponent = new Component(){};

    private static boolean waitForImage(Image image) {
        if (image == null) {
            return false;
        }
        if (image.getWidth(null) > 0) {
            return true;
        }
        MediaTracker mediatracker = new MediaTracker(ourComponent);
        mediatracker.addImage(image, 1);
        try {
            mediatracker.waitForID(1, 5000L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        return !mediatracker.isErrorID(1);
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url) {
        if (url == null) {
            ImageLoader.$$$reportNull$$$0(0);
        }
        return ImageLoader.loadFromUrl(url, true);
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url, boolean allowFloatScaling) {
        if (url == null) {
            ImageLoader.$$$reportNull$$$0(1);
        }
        return ImageLoader.loadFromUrl(url, allowFloatScaling, null);
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url, boolean allowFloatScaling, ImageFilter filter) {
        float scaleFactor;
        if (url == null) {
            ImageLoader.$$$reportNull$$$0(2);
        }
        final boolean scaleImages = (scaleFactor = ImageLoader.calcScaleFactor(allowFloatScaling)) > 1.0f && !UIUtil.isRetina();
        boolean loadRetinaImages = UIUtil.isRetina() || scaleImages;
        return ImageDescList.create(url.toString(), null, UIUtil.isUnderDarcula(), loadRetinaImages, allowFloatScaling).load(ImageConverterChain.create().withFilter(filter).withRetina().with(new ImageConverter(){

            @Override
            public Image convert(Image source, ImageDesc desc) {
                if (source != null && scaleImages) {
                    if (desc.path.contains("@2x")) {
                        return ImageLoader.scaleImage(source, scaleFactor / 2.0f);
                    }
                    return ImageLoader.scaleImage(source, scaleFactor);
                }
                return source;
            }
        }));
    }

    private static float calcScaleFactor(boolean allowFloatScaling) {
        float scaleFactor;
        float f = allowFloatScaling ? JBUI.scale(1.0f) : (scaleFactor = JBUI.scale(1.0f) > 1.5f ? 2.0f : 1.0f);
        assert (scaleFactor >= 1.0f) : "By design, only scale factors >= 1.0 are supported";
        return scaleFactor;
    }

    @NotNull
    private static Image scaleImage(Image image, float scale) {
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        if (w <= 0 || h <= 0) {
            Image image2 = image;
            if (image2 == null) {
                ImageLoader.$$$reportNull$$$0(3);
            }
            return image2;
        }
        int width = (int)(scale * (float)w);
        int height = (int)(scale * (float)h);
        BufferedImage bufferedImage = Scalr.resize(ImageUtil.toBufferedImage(image), Scalr.Method.QUALITY, width, height, new BufferedImageOp[0]);
        if (bufferedImage == null) {
            ImageLoader.$$$reportNull$$$0(4);
        }
        return bufferedImage;
    }

    @Nullable
    public static Image loadFromUrl(URL url, boolean dark, boolean retina) {
        return ImageLoader.loadFromUrl(url, dark, retina, null);
    }

    @Nullable
    public static Image loadFromUrl(URL url, boolean dark, boolean retina, ImageFilter filter) {
        return ImageDescList.create(url.toString(), null, dark, retina, true).load(ImageConverterChain.create().withFilter(filter).withRetina());
    }

    @Nullable
    public static Image loadFromResource(@NonNls @NotNull String s) {
        Class callerClass;
        if (s == null) {
            ImageLoader.$$$reportNull$$$0(5);
        }
        if ((callerClass = ReflectionUtil.getGrandCallerClass()) == null) {
            return null;
        }
        return ImageLoader.loadFromResource(s, callerClass);
    }

    @Nullable
    public static Image loadFromResource(@NonNls @NotNull String path, @NotNull Class aClass) {
        if (path == null) {
            ImageLoader.$$$reportNull$$$0(6);
        }
        if (aClass == null) {
            ImageLoader.$$$reportNull$$$0(7);
        }
        return ImageDescList.create(path, aClass, UIUtil.isUnderDarcula(), UIUtil.isRetina() || JBUI.scale(1.0f) >= 1.5f, true).load(ImageConverterChain.create().withRetina());
    }

    public static Image loadFromStream(@NotNull InputStream inputStream) {
        if (inputStream == null) {
            ImageLoader.$$$reportNull$$$0(8);
        }
        return ImageLoader.loadFromStream(inputStream, 1);
    }

    public static Image loadFromStream(@NotNull InputStream inputStream, int scale) {
        if (inputStream == null) {
            ImageLoader.$$$reportNull$$$0(9);
        }
        return ImageLoader.loadFromStream(inputStream, scale, null);
    }

    public static Image loadFromStream(@NotNull InputStream inputStream, int scale, ImageFilter filter) {
        if (inputStream == null) {
            ImageLoader.$$$reportNull$$$0(10);
        }
        Image image = ImageLoader.load(inputStream, scale);
        ImageDesc desc = new ImageDesc("", null, scale, ImageDesc.Type.UNDEFINED);
        return ImageConverterChain.create().withFilter(filter).withRetina().convert(image, desc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image load(@NotNull InputStream inputStream, int scale) {
        if (inputStream == null) {
            ImageLoader.$$$reportNull$$$0(11);
        }
        if (scale <= 0) {
            throw new IllegalArgumentException("Scale must be 1 or greater");
        }
        try {
            BufferExposingByteArrayOutputStream outputStream = new BufferExposingByteArrayOutputStream();
            try {
                int n;
                byte[] buffer = new byte[1024];
                while ((n = inputStream.read(buffer)) >= 0) {
                    outputStream.write(buffer, 0, n);
                }
            }
            finally {
                inputStream.close();
            }
            Image image = Toolkit.getDefaultToolkit().createImage(outputStream.getInternalBuffer(), 0, outputStream.size());
            ImageLoader.waitForImage(image);
            return image;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static boolean isGoodSize(Icon icon) {
        return IconLoader.isGoodSize(icon);
    }

    public static List<Pair<String, Integer>> getFileNames(@NotNull String file) {
        if (file == null) {
            ImageLoader.$$$reportNull$$$0(12);
        }
        return ImageLoader.getFileNames(file, false, false);
    }

    public static List<Pair<String, Integer>> getFileNames(@NotNull String file, boolean dark, boolean retina) {
        if (file == null) {
            ImageLoader.$$$reportNull$$$0(13);
        }
        new UnsupportedOperationException("unsupported method").printStackTrace();
        return new ArrayList<Pair<String, Integer>>();
    }

    @NotNull
    public static String getNameWithoutExtension(@NotNull String name) {
        int i;
        if (name == null) {
            ImageLoader.$$$reportNull$$$0(14);
        }
        if ((i = name.lastIndexOf(46)) != -1) {
            name = name.substring(0, i);
        }
        String string = name;
        if (string == null) {
            ImageLoader.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public static String getExtension(@NotNull String fileName) {
        int index;
        if (fileName == null) {
            ImageLoader.$$$reportNull$$$0(16);
        }
        if ((index = fileName.lastIndexOf(46)) < 0) {
            if ("" == null) {
                ImageLoader.$$$reportNull$$$0(17);
            }
            return "";
        }
        String string = fileName.substring(index + 1);
        if (string == null) {
            ImageLoader.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 15: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 15: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 3: 
            case 4: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/bulenkov/iconloader/util/ImageLoader";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/bulenkov/iconloader/util/ImageLoader";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "scaleImage";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithoutExtension";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadFromUrl";
                break;
            }
            case 3: 
            case 4: 
            case 15: 
            case 17: 
            case 18: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadFromResource";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadFromStream";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFileNames";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNameWithoutExtension";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 15: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ImageConverterChain
    extends ArrayList<ImageConverter> {
        private ImageConverterChain() {
        }

        public static ImageConverterChain create() {
            return new ImageConverterChain();
        }

        public ImageConverterChain withFilter(final ImageFilter filter) {
            return this.with(new ImageConverter(){

                @Override
                public Image convert(Image source, ImageDesc desc) {
                    return ImageUtil.filter(source, filter);
                }
            });
        }

        public ImageConverterChain withRetina() {
            return this.with(new ImageConverter(){

                @Override
                public Image convert(Image source, ImageDesc desc) {
                    if (source != null && UIUtil.isRetina() && desc.scale > 1.0f) {
                        return RetinaImage.createFrom(source, (int)desc.scale, ourComponent);
                    }
                    return source;
                }
            });
        }

        public ImageConverterChain with(ImageConverter f) {
            this.add(f);
            return this;
        }

        public Image convert(Image image, ImageDesc desc) {
            for (ImageConverter f : this) {
                image = f.convert(image, desc);
            }
            return image;
        }
    }

    private static interface ImageConverter {
        public Image convert(@Nullable Image var1, ImageDesc var2);
    }

    private static class ImageDescList
    extends ArrayList<ImageDesc> {
        private ImageDescList() {
        }

        @Nullable
        public Image load() {
            return this.load(ImageConverterChain.create());
        }

        @Nullable
        public Image load(@NotNull ImageConverterChain converters) {
            if (converters == null) {
                ImageDescList.$$$reportNull$$$0(0);
            }
            for (ImageDesc desc : this) {
                try {
                    Image image = desc.load();
                    if (image == null) continue;
                    return converters.convert(image, desc);
                }
                catch (IOException iOException) {
                }
            }
            return null;
        }

        public static ImageDescList create(@NotNull String file, @Nullable Class cls, boolean dark, boolean retina, boolean allowFloatScaling) {
            if (file == null) {
                ImageDescList.$$$reportNull$$$0(1);
            }
            ImageDescList vars = new ImageDescList();
            if (retina || dark) {
                String name = ImageLoader.getNameWithoutExtension(file);
                String ext = ImageLoader.getExtension(file);
                float scale = ImageLoader.calcScaleFactor(allowFloatScaling);
                if (dark && retina) {
                    vars.add(new ImageDesc(name + "@2x_dark." + ext, cls, 2.0f, ImageDesc.Type.PNG));
                }
                if (dark) {
                    vars.add(new ImageDesc(name + "_dark." + ext, cls, 1.0f, ImageDesc.Type.PNG));
                }
                if (retina) {
                    vars.add(new ImageDesc(name + "@2x." + ext, cls, 2.0f, ImageDesc.Type.PNG));
                }
            }
            vars.add(new ImageDesc(file, cls, 1.0f, ImageDesc.Type.PNG, true));
            return vars;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "converters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/bulenkov/iconloader/util/ImageLoader$ImageDescList";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "load";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ImageDesc {
        public final String path;
        @Nullable
        public final Class cls;
        public final float scale;
        public final Type type;
        public final boolean original;

        public ImageDesc(String path, Class cls, float scale, Type type) {
            this(path, cls, scale, type, false);
        }

        public ImageDesc(String path, Class cls, float scale, Type type, boolean original) {
            this.path = path;
            this.cls = cls;
            this.scale = scale;
            this.type = type;
            this.original = original;
        }

        @Nullable
        public Image load() throws IOException {
            Image image;
            String cacheKey = null;
            InputStream stream = null;
            URL url = null;
            if (this.cls != null && (stream = this.cls.getResourceAsStream(this.path)) == null) {
                return null;
            }
            if (stream == null) {
                url = new URL(this.path);
                URLConnection connection = url.openConnection();
                if (connection instanceof HttpURLConnection) {
                    if (!this.original) {
                        return null;
                    }
                    connection.addRequestProperty("User-Agent", "IntelliJ");
                    cacheKey = this.path;
                    Image image2 = (Image)ourCache.get(cacheKey);
                    if (image2 != null) {
                        return image2;
                    }
                }
                stream = connection.getInputStream();
            }
            if ((image = this.type.load(url, stream, this.scale)) != null && cacheKey != null) {
                ourCache.put(cacheKey, image);
            }
            return image;
        }

        public String toString() {
            return this.path + ", scale: " + this.scale + ", type: " + (Object)((Object)this.type);
        }

        public static enum Type {
            PNG,
            UNDEFINED;


            public Image load(URL url, InputStream stream, float scale) throws IOException {
                return ImageLoader.load(stream, (int)scale);
            }
        }
    }
}

