/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.cpdetector.io;

import antlr.ANTLRException;
import info.monitorenter.cpdetector.io.AbstractCodepageDetector;
import info.monitorenter.cpdetector.io.UnknownCharset;
import info.monitorenter.cpdetector.io.UnsupportedCharset;
import info.monitorenter.cpdetector.io.parser.EncodingLexer;
import info.monitorenter.cpdetector.io.parser.EncodingParser;
import info.monitorenter.io.LimitedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;

public class ParsingDetector
extends AbstractCodepageDetector {
    private boolean m_verbose = false;

    public ParsingDetector() {
        this(false);
    }

    public ParsingDetector(boolean verbose) {
        this.m_verbose = verbose;
    }

    public Charset detectCodepage(InputStream in, int length) throws IOException {
        Charset charset;
        block10: {
            charset = null;
            String csName = null;
            LimitedInputStream limitedInputStream = new LimitedInputStream(in, length);
            if (this.m_verbose) {
                System.out.println("  parsing for html-charset/xml-encoding attribute with codepage: US-ASCII");
            }
            try {
                EncodingLexer lexer = new EncodingLexer(new InputStreamReader((InputStream)limitedInputStream, "US-ASCII"));
                EncodingParser parser = new EncodingParser(lexer);
                csName = parser.htmlDocument();
                if (csName != null) {
                    try {
                        charset = Charset.forName(csName);
                    }
                    catch (UnsupportedCharsetException uce) {
                        charset = UnsupportedCharset.forName(csName);
                    }
                } else {
                    charset = UnknownCharset.getInstance();
                }
            }
            catch (ANTLRException ae) {
                if (this.m_verbose) {
                    System.out.println("  ANTLR parser exception: " + ae.getMessage());
                }
            }
            catch (Exception deepdown) {
                if (this.m_verbose) {
                    System.out.println("  Decoding Exception: " + deepdown.getMessage() + " (unsupported java charset).");
                }
                if (charset != null) break block10;
                charset = csName != null ? UnsupportedCharset.forName(csName) : UnknownCharset.getInstance();
            }
        }
        return charset;
    }
}

