/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.cpdetector.util.collections;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public interface ITreeNode {
    public static final ITreeNode ROOT = new DefaultTreeNode();

    public Object getUserObject();

    public void setParent(ITreeNode var1);

    public boolean addChildNode(ITreeNode var1);

    public boolean addChildNodes(ITreeNode[] var1);

    public boolean removeChild(ITreeNode var1);

    public List getAllChildren();

    public void getPathFromRoot(List var1);

    public void getUserObjectPathFromRoot(List var1);

    public boolean equals(Object var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultTreeNode
    implements ITreeNode,
    Comparable<ITreeNode> {
        protected boolean marked = false;
        protected Object m_userObject = "root";
        ITreeNode m_parent = null;
        protected SortedSet m_children = new TreeSet();

        @Override
        public boolean equals(Object obj) {
            boolean ret = false;
            if (obj instanceof DefaultTreeNode) {
                DefaultTreeNode other = (DefaultTreeNode)obj;
                Object myUser = this.getUserObject();
                Object himUser = other.getUserObject();
                ret = myUser == null ? himUser == null : myUser.equals(himUser);
            }
            return ret;
        }

        public DefaultTreeNode() {
        }

        public DefaultTreeNode(Object userObject) {
            this();
            this.m_userObject = userObject;
        }

        @Override
        public boolean addChildNode(ITreeNode node) {
            if (node == null) {
                return false;
            }
            node.setParent(this);
            this.m_children.add(node);
            return true;
        }

        public final Iterator getChilds() {
            return this.m_children.iterator();
        }

        public final ITreeNode getParent() {
            return this.m_parent == null ? ROOT : this.m_parent;
        }

        @Override
        public final Object getUserObject() {
            return this.m_userObject;
        }

        @Override
        public boolean removeChild(ITreeNode node) {
            return this.m_children.remove(node);
        }

        @Override
        public final void setParent(ITreeNode parent) {
            if (this.m_parent != null) {
                this.m_parent.removeChild(this);
            }
            this.m_parent = parent;
        }

        public final boolean isLeaf() {
            return this.m_children.size() == 0;
        }

        public final boolean isRoot() {
            return this.m_parent == null;
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            this.toStringInternal(ret, 1);
            return ret.toString();
        }

        protected void toStringInternal(StringBuffer buf, int depth) {
            if (this.isLeaf()) {
                buf.append("-> ");
            }
            buf.append('(').append(String.valueOf(this.m_userObject)).append(')');
            StringBuffer spaceCollect = new StringBuffer();
            for (int i = depth; i > 0; --i) {
                spaceCollect.append("  ");
            }
            String indent = spaceCollect.toString();
            Iterator it = this.getChilds();
            while (it.hasNext()) {
                buf.append("\n").append(indent);
                ((DefaultTreeNode)it.next()).toStringInternal(buf, depth + 1);
            }
        }

        @Override
        public final boolean addChildNodes(ITreeNode[] nodes) {
            boolean ret = true;
            for (int i = 0; i < nodes.length; ++i) {
                ret &= this.addChildNode(nodes[i]);
            }
            return ret;
        }

        @Override
        public final List getAllChildren() {
            return new LinkedList(this.m_children);
        }

        @Override
        public void getPathFromRoot(List l) {
            if (this.isRoot()) {
                l.add(this);
            } else {
                this.getParent().getPathFromRoot(l);
                l.add(this);
            }
        }

        @Override
        public void getUserObjectPathFromRoot(List l) {
            LinkedList collect = new LinkedList();
            this.getPathFromRoot(collect);
            Iterator it = collect.iterator();
            while (it.hasNext()) {
                l.add(((ITreeNode)it.next()).getUserObject());
            }
        }

        @Override
        public int compareTo(ITreeNode o) throws ClassCastException {
            ITreeNode other = o;
            return ((Comparable)this.m_userObject).compareTo(other.getUserObject());
        }
    }
}

