/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.util;

import info.monitorenter.io.MultiplexingOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;

public final class ExceptionUtil {
    private static ExceptionUtil instance = null;

    public static InputStream captureSystemOutForDebuggingPurposesOnly(boolean teeToOriginalSysOut) throws IOException {
        PipedOutputStream pipeOut = new PipedOutputStream();
        PipedInputStream pipeIn = new PipedInputStream(pipeOut);
        OutputStream out = pipeOut;
        if (teeToOriginalSysOut) {
            out = new MultiplexingOutputStream(System.out, pipeOut);
        }
        PrintStream streamOut = new PrintStream(out);
        System.setOut(streamOut);
        return pipeIn;
    }

    public static InputStreamTracer findMatchInSystemOut(String expectMatch) throws IOException {
        InputStream systemout = ExceptionUtil.captureSystemOutForDebuggingPurposesOnly(true);
        InputStreamTracer result = new InputStreamTracer(systemout, expectMatch, Charset.defaultCharset());
        Thread traceThread = new Thread(result);
        traceThread.setDaemon(true);
        traceThread.start();
        return result;
    }

    public static class InputStreamTracer
    implements Runnable {
        private InputStream m_streamToTrace;
        private String m_match;
        private Charset m_charset;
        private boolean m_matched;

        public boolean isMatched() {
            return this.m_matched;
        }

        public InputStreamTracer(InputStream toTrace, String match, Charset charset) {
            this.m_streamToTrace = toTrace;
            this.m_match = match;
            this.m_charset = charset;
        }

        public void run() {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.m_streamToTrace, this.m_charset));
            try {
                String line;
                do {
                    if ((line = reader.readLine()) == null || !line.contains(this.m_match)) continue;
                    this.m_matched = true;
                    break;
                } while (line != null);
            }
            catch (IOException ioex) {
                throw new RuntimeException(ioex);
            }
        }
    }
}

