/*
 * Decompiled with CFR 0.152.
 */
package org.jb2011.lnf.beautyeye.ch18_spinner;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSpinnerUI;
import org.jb2011.lnf.beautyeye.ch18_spinner.__Icon9Factory__;
import org.jb2011.lnf.beautyeye.utils.BEUtils;

public class BESpinnerUI
extends BasicSpinnerUI {
    public static ComponentUI createUI(JComponent c) {
        return new BESpinnerUI();
    }

    protected JComponent createEditor() {
        JComponent e = super.createEditor();
        e.setOpaque(false);
        Component[] childs = e.getComponents();
        BEUtils.componentsOpaque(childs, false);
        return e;
    }

    public void paint(Graphics g, JComponent c) {
        this.paintXPBackground(g, c);
        super.paint(g, c);
    }

    private void paintXPBackground(Graphics g, JComponent c) {
        if (this.spinner != null && !this.spinner.isEnabled()) {
            __Icon9Factory__.getInstance().getSpinnerDisableBg().draw((Graphics2D)g, 0, 0, c.getWidth(), c.getHeight());
        } else {
            __Icon9Factory__.getInstance().getSpinnerBg().draw((Graphics2D)g, 0, 0, c.getWidth(), c.getHeight());
        }
    }

    protected Component createPreviousButton() {
        GlyphButton xpButton = new GlyphButton(this.spinner, GlyphButton.Type.down);
        Dimension size = UIManager.getDimension("Spinner.arrowButtonSize");
        xpButton.setPreferredSize(size);
        xpButton.setRequestFocusEnabled(false);
        this.installPreviousButtonListeners(xpButton);
        return xpButton;
    }

    protected Component createNextButton() {
        GlyphButton xpButton = new GlyphButton(this.spinner, GlyphButton.Type.up);
        Dimension size = UIManager.getDimension("Spinner.arrowButtonSize");
        xpButton.setPreferredSize(size);
        xpButton.setRequestFocusEnabled(false);
        this.installNextButtonListeners(xpButton);
        return xpButton;
    }

    static class GlyphButton
    extends JButton {
        private Type type = null;

        public GlyphButton(Component parent, Type type) {
            this.type = type;
            this.setBorder(null);
            this.setContentAreaFilled(false);
            this.setMinimumSize(new Dimension(5, 5));
            this.setPreferredSize(new Dimension(16, 16));
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void paintComponent(Graphics g) {
            Dimension d = this.getSize();
            if (this.type == Type.up) {
                if (!this.isEnabled() || this.getModel().isPressed()) {
                    __Icon9Factory__.getInstance().getUpButtonBg_pressed().draw((Graphics2D)g, 0, 0, d.width, d.height);
                } else {
                    __Icon9Factory__.getInstance().getUpButtonBg().draw((Graphics2D)g, 0, 0, d.width, d.height);
                }
            } else if (this.type == Type.down) {
                if (!this.isEnabled() || this.getModel().isPressed()) {
                    __Icon9Factory__.getInstance().getDownButtonBg_pressed().draw((Graphics2D)g, 0, 0, d.width, d.height);
                } else {
                    __Icon9Factory__.getInstance().getDownButtonBg().draw((Graphics2D)g, 0, 0, d.width, d.height);
                }
            }
        }

        protected void paintBorder(Graphics g) {
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            down,
            up;

        }
    }
}

