/*
 * Decompiled with CFR 0.152.
 */
package org.jb2011.lnf.beautyeye.ch9_menu;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;
import org.jb2011.lnf.beautyeye.ch9_menu.__Icon9Factory__;
import org.jb2011.lnf.beautyeye.utils.BEUtils;
import org.jb2011.lnf.beautyeye.winlnfutils.WinUtils;

public class BEMenuUI
extends BasicMenuUI {
    public static final int DECORATED_UNDERLINE_HEIGHT = 2;
    public static final Color MENU_SELECTED_UNDERLINE_COLOR = new Color(37, 147, 217);
    public static final Color MENU_UNSELECTED_UNDERLINE_COLOR = new Color(226, 230, 232);
    protected Integer menuBarHeight;
    protected boolean hotTrackingOn;

    public static ComponentUI createUI(JComponent x) {
        return new BEMenuUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.menuItem.setRolloverEnabled(true);
        this.menuBarHeight = UIManager.getInt("MenuBar.height");
        Object obj = UIManager.get("MenuBar.rolloverEnabled");
        this.hotTrackingOn = obj instanceof Boolean ? (Boolean)obj : true;
    }

    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        JMenu menu = (JMenu)menuItem;
        ButtonModel model = menu.getModel();
        Color oldColor = g.getColor();
        int menuWidth = menu.getWidth();
        int menuHeight = menu.getHeight();
        g.setColor(menu.getBackground());
        g.fillRect(0, 0, menuWidth, menuHeight);
        if (menu.isTopLevelMenu()) {
            g.setColor(MENU_UNSELECTED_UNDERLINE_COLOR);
            g.fillRect(0, menuHeight - 2, menuWidth, menuHeight);
        }
        if (menu.isTopLevelMenu()) {
            if (model.isArmed() || model.isSelected()) {
                Color c = MENU_SELECTED_UNDERLINE_COLOR;
                g.setColor(c);
                int tW = 7;
                int tH = 3;
                int x1 = menuWidth / 2 - tW / 2;
                int y1 = menuHeight - 2;
                int x2 = menuWidth / 2;
                int y2 = menuHeight - 2 - tH;
                int x3 = menuWidth / 2 + tW / 2;
                int y3 = menuHeight - 2;
                BEUtils.setAntiAliasing((Graphics2D)g, true);
                BEUtils.fillTriangle(g, x1, y1, x2, y2, x3, y3, c);
                BEUtils.setAntiAliasing((Graphics2D)g, false);
                g.fillRect(0, menuHeight - 2, menuWidth, 2);
            } else if (model.isRollover() && model.isEnabled()) {
                boolean otherMenuSelected = false;
                MenuElement[] menus = ((JMenuBar)menu.getParent()).getSubElements();
                int i = 0;
                while (i < menus.length) {
                    if (((JMenuItem)menus[i]).isSelected()) {
                        otherMenuSelected = true;
                        break;
                    }
                    ++i;
                }
                if (!otherMenuSelected) {
                    g.setColor(MENU_SELECTED_UNDERLINE_COLOR);
                    g.fillRect(0, menuHeight - 2, menuWidth, 2);
                }
            }
        } else if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
            __Icon9Factory__.getInstance().getBgIcon_ItemSelected().draw((Graphics2D)g, 0, 0, menuWidth, menuHeight);
        }
        g.setColor(oldColor);
    }

    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        JMenu menu = (JMenu)menuItem;
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        boolean paintRollover = model.isRollover();
        if (paintRollover && menu.isTopLevelMenu()) {
            MenuElement[] menus = ((JMenuBar)menu.getParent()).getSubElements();
            int i = 0;
            while (i < menus.length) {
                if (((JMenuItem)menus[i]).isSelected()) {
                    paintRollover = false;
                    break;
                }
                ++i;
            }
        }
        if (model.isSelected() && !menu.isTopLevelMenu() || paintRollover || model.isArmed() || model.isSelected()) {
            g.setColor(this.selectionForeground);
        }
        if (menu.isTopLevelMenu()) {
            g.setColor(new Color(35, 35, 35));
        }
        WinUtils.paintText(g, menuItem, textRect, text, 0);
        g.setColor(oldColor);
    }

    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new BEMouseInputHandler();
    }

    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        Dimension d = super.getPreferredMenuItemSize(c, checkIcon, arrowIcon, defaultTextIconGap);
        if (c instanceof JMenu && ((JMenu)c).isTopLevelMenu() && this.menuBarHeight != null && d.height < this.menuBarHeight) {
            d.height = this.menuBarHeight;
        }
        return d;
    }

    protected class BEMouseInputHandler
    extends BasicMenuUI.MouseInputHandler {
        protected BEMouseInputHandler() {
            super(BEMenuUI.this);
        }

        public void mouseEntered(MouseEvent evt) {
            super.mouseEntered(evt);
            JMenu menu = (JMenu)evt.getSource();
            if (BEMenuUI.this.hotTrackingOn && menu.isTopLevelMenu() && menu.isRolloverEnabled()) {
                menu.getModel().setRollover(true);
                BEMenuUI.this.menuItem.repaint();
            }
        }

        public void mouseExited(MouseEvent evt) {
            super.mouseExited(evt);
            JMenu menu = (JMenu)evt.getSource();
            ButtonModel model = menu.getModel();
            if (menu.isRolloverEnabled()) {
                model.setRollover(false);
                BEMenuUI.this.menuItem.repaint();
            }
        }
    }
}

