/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.date;

import com.alee.extended.date.DateCustomizer;
import com.alee.extended.date.DateSelectionListener;
import com.alee.extended.layout.TableLayout;
import com.alee.extended.transition.ComponentTransition;
import com.alee.extended.transition.TransitionAdapter;
import com.alee.extended.transition.effects.Direction;
import com.alee.extended.transition.effects.slide.SlideTransitionEffect;
import com.alee.extended.transition.effects.slide.SlideType;
import com.alee.global.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.button.WebToggleButton;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.separator.WebSeparator;
import com.alee.utils.CollectionUtils;
import com.alee.utils.CompareUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.TimeUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class WebCalendar
extends WebPanel {
    public static final ImageIcon previousSkipIcon = new ImageIcon(WebCalendar.class.getResource("icons/previous_skip.png"));
    public static final ImageIcon previousIcon = new ImageIcon(WebCalendar.class.getResource("icons/previous.png"));
    public static final ImageIcon nextIcon = new ImageIcon(WebCalendar.class.getResource("icons/next.png"));
    public static final ImageIcon nextSkipIcon = new ImageIcon(WebCalendar.class.getResource("icons/next_skip.png"));
    protected List<DateSelectionListener> dateSelectionListeners = new ArrayList<DateSelectionListener>(1);
    protected SimpleDateFormat titleFormat = new SimpleDateFormat("MMMM yyyy");
    protected boolean startWeekFromSunday = false;
    protected boolean animate = true;
    protected boolean horizontalSlide = true;
    protected Color otherMonthForeground = new Color(90, 90, 90);
    protected Color currentMonthForeground = Color.BLACK;
    protected Color weekendsForeground = new Color(160, 0, 0);
    protected DateCustomizer dateCustomizer;
    protected Date date;
    protected Date shownDate;
    protected Date oldShownDate;
    protected WebButton previousSkip;
    protected WebButton previous;
    protected WebLabel titleLabel;
    protected WebButton next;
    protected WebButton nextSkip;
    protected WebPanel weekHeaders;
    protected WebPanel monthDays;
    protected ComponentTransition monthDaysTransition;
    protected WebToggleButton lastSelectedDayButton;

    public WebCalendar() {
        this((Date)null);
    }

    public WebCalendar(Date date) {
        super(true);
        this.date = date != null ? new Date(date.getTime()) : null;
        this.shownDate = date != null ? new Date(date.getTime()) : new Date();
        this.setPaintFocus(true);
        this.setRound(StyleConstants.smallRound);
        this.setLayout(new BorderLayout(0, 0));
        this.putClientProperty("HANDLES_ENABLE_STATE", true);
        WebPanel centerPanel = new WebPanel();
        centerPanel.setOpaque(false);
        this.add((Component)centerPanel, (Object)"Center");
        WebPanel header = new WebPanel();
        header.setOpaque(false);
        this.add((Component)header, (Object)"North");
        this.previousSkip = WebButton.createIconWebButton(previousSkipIcon, StyleConstants.smallRound, true);
        this.previousSkip.setDrawFocus(false);
        this.previousSkip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebCalendar.this.changeYear(-1);
            }
        });
        this.previous = WebButton.createIconWebButton(previousIcon, StyleConstants.smallRound, true);
        this.previous.setDrawFocus(false);
        this.previous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebCalendar.this.changeMonth(-1);
            }
        });
        WebPanel leftHeader = new WebPanel(new BorderLayout());
        leftHeader.setOpaque(false);
        leftHeader.add((Component)this.previousSkip, (Object)"West");
        leftHeader.add((Component)this.previous, (Object)"East");
        header.add((Component)leftHeader, (Object)"West");
        this.titleLabel = new WebLabel();
        this.updateTitleLabel();
        this.titleLabel.setBoldFont();
        this.titleLabel.setDrawShade(true);
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setVerticalAlignment(0);
        header.add((Component)this.titleLabel, (Object)"Center");
        this.next = WebButton.createIconWebButton(nextIcon, StyleConstants.smallRound, true);
        this.next.setDrawFocus(false);
        this.next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebCalendar.this.changeMonth(1);
            }
        });
        this.nextSkip = WebButton.createIconWebButton(nextSkipIcon, StyleConstants.smallRound, true);
        this.nextSkip.setDrawFocus(false);
        this.nextSkip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebCalendar.this.changeYear(1);
            }
        });
        WebPanel rightHeader = new WebPanel(new BorderLayout());
        rightHeader.setOpaque(false);
        rightHeader.add((Component)this.next, (Object)"West");
        rightHeader.add((Component)this.nextSkip, (Object)"East");
        header.add((Component)rightHeader, (Object)"East");
        this.weekHeaders = new WebPanel();
        this.weekHeaders.setUndecorated(false);
        this.weekHeaders.setPaintSides(true, false, true, false);
        this.weekHeaders.setShadeWidth(0);
        this.weekHeaders.setOpaque(false);
        this.weekHeaders.setMargin(StyleConstants.shadeWidth, StyleConstants.shadeWidth - 1, StyleConstants.shadeWidth + 1, StyleConstants.shadeWidth - 1);
        this.weekHeaders.setLayout(new TableLayout(new double[][]{{-1.0, -2.0, -1.0, -2.0, -1.0, -2.0, -1.0, -2.0, -1.0, -2.0, -1.0, -2.0, -1.0}, {-2.0}}));
        centerPanel.add((Component)this.weekHeaders, (Object)"North");
        this.updateWeekHeaders();
        this.monthDays = this.createMonthPanel();
        this.updateMonth(this.monthDays);
        this.monthDaysTransition = new ComponentTransition(this.monthDays);
        this.monthDaysTransition.setOpaque(false);
        this.monthDaysTransition.addTransitionListener(new TransitionAdapter(){

            @Override
            public void transitionFinished() {
                WebCalendar.this.requestFocusToSelected();
            }
        });
        centerPanel.add((Component)this.monthDaysTransition, (Object)"Center");
    }

    protected void updateTitleLabel() {
        this.titleLabel.setText(this.titleFormat.format(this.shownDate));
    }

    protected void updateMonth(boolean animate) {
        if (animate && this.isAnimate()) {
            this.monthDays = this.createMonthPanel();
            this.updateMonth(this.monthDays);
            boolean ltr = this.getComponentOrientation().isLeftToRight();
            SlideTransitionEffect effect = new SlideTransitionEffect();
            effect.setType(SlideType.moveBoth);
            effect.setDirection(this.oldShownDate.getTime() > this.shownDate.getTime() ? this.getNextDirection(ltr) : this.getPrevDirection(ltr));
            effect.setSpeed(20);
            this.monthDaysTransition.setTransitionEffect(effect);
            this.monthDaysTransition.performTransition(this.monthDays);
        } else {
            this.updateMonth(this.monthDays);
            this.requestFocusToSelected();
        }
    }

    protected void changeMonth(int change) {
        if (!this.getComponentOrientation().isLeftToRight()) {
            change = -change;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.shownDate);
        calendar.set(5, 1);
        calendar.set(2, calendar.get(2) + change);
        this.setShownDate(calendar.getTime());
    }

    protected void changeYear(int change) {
        if (!this.getComponentOrientation().isLeftToRight()) {
            change = -change;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.shownDate);
        calendar.set(5, 1);
        calendar.set(1, calendar.get(1) + change);
        this.setShownDate(calendar.getTime());
    }

    protected WebPanel createMonthPanel() {
        WebPanel monthDays = new WebPanel();
        monthDays.setOpaque(false);
        monthDays.setMargin(StyleConstants.shadeWidth - 1, StyleConstants.shadeWidth - 1, StyleConstants.shadeWidth - 1, StyleConstants.shadeWidth - 1);
        TableLayout layout = new TableLayout(new double[][]{{-1.0, -2.0, -1.0, -2.0, -1.0, -2.0, -1.0, -2.0, -1.0, -2.0, -1.0, -2.0, -1.0}, {-1.0, -1.0, -1.0, -1.0, -1.0, -1.0}});
        layout.setHGap(0);
        layout.setVGap(0);
        monthDays.setLayout(layout);
        return monthDays;
    }

    protected void requestFocusToSelected() {
        if (this.lastSelectedDayButton != null) {
            this.lastSelectedDayButton.requestFocusInWindow();
        }
    }

    protected Direction getNextDirection(boolean ltr) {
        return this.horizontalSlide ? (ltr ? Direction.right : Direction.left) : Direction.up;
    }

    protected Direction getPrevDirection(boolean ltr) {
        return this.horizontalSlide ? (ltr ? Direction.left : Direction.right) : Direction.down;
    }

    protected void updateWeekHeaders() {
        this.weekHeaders.removeAll();
        for (int i = 1; i <= 7; ++i) {
            int day = !this.startWeekFromSunday ? i : (i == 1 ? 7 : i - 1);
            WebLabel dayOfWeekLabel = new WebLabel();
            dayOfWeekLabel.setLanguage("weblaf.ex.calendar.dayOfWeek." + day, new Object[0]);
            dayOfWeekLabel.setDrawShade(true);
            dayOfWeekLabel.setHorizontalAlignment(0);
            dayOfWeekLabel.setFontSizeAndStyle(10, 1);
            this.weekHeaders.add((Component)dayOfWeekLabel, (Object)((i - 1) * 2 + ",0"));
            if (i >= 7) continue;
            this.weekHeaders.add((Component)new WebSeparator(1), (Object)((i - 1) * 2 + 1 + ",0"));
        }
        this.weekHeaders.revalidate();
    }

    protected void updateMonth(JPanel monthDays) {
        WebToggleButton day;
        Date thisDate;
        int shift;
        monthDays.removeAll();
        this.lastSelectedDayButton = null;
        monthDays.add((Component)new WebSeparator(1), "1,0,1,5");
        monthDays.add((Component)new WebSeparator(1), "3,0,3,5");
        monthDays.add((Component)new WebSeparator(1), "5,0,5,5");
        monthDays.add((Component)new WebSeparator(1), "7,0,7,5");
        monthDays.add((Component)new WebSeparator(1), "9,0,9,5");
        monthDays.add((Component)new WebSeparator(1), "11,0,11,5");
        ButtonGroup dates = new ButtonGroup();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.shownDate);
        calendar.set(5, 1);
        int col = 0;
        int row = 0;
        int dayOfWeek = calendar.get(7);
        switch (dayOfWeek) {
            case 2: {
                shift = this.startWeekFromSunday ? 1 : 7;
                break;
            }
            case 3: {
                shift = this.startWeekFromSunday ? 2 : 1;
                break;
            }
            case 4: {
                shift = this.startWeekFromSunday ? 3 : 2;
                break;
            }
            case 5: {
                shift = this.startWeekFromSunday ? 4 : 3;
                break;
            }
            case 6: {
                shift = this.startWeekFromSunday ? 5 : 4;
                break;
            }
            case 7: {
                shift = this.startWeekFromSunday ? 6 : 5;
                break;
            }
            case 1: {
                shift = this.startWeekFromSunday ? 7 : 6;
                break;
            }
            default: {
                shift = 0;
            }
        }
        TimeUtils.changeByDays(calendar, -shift);
        while (calendar.get(5) > 1) {
            final Date thisDate2 = calendar.getTime();
            WebToggleButton day2 = new WebToggleButton();
            day2.setForeground(this.otherMonthForeground);
            day2.setText("" + calendar.get(5));
            day2.setRolloverDecoratedOnly(true);
            day2.setHorizontalAlignment(4);
            day2.setRound(StyleConstants.smallRound);
            day2.setFocusable(false);
            day2.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    WebToggleButton dayButton = (WebToggleButton)e.getSource();
                    if (dayButton.isSelected()) {
                        WebCalendar.this.setDateImpl(thisDate2);
                    }
                }
            });
            if (this.dateCustomizer != null) {
                this.dateCustomizer.customize(day2, thisDate2);
            }
            monthDays.add((Component)day2, col * 2 + "," + row);
            dates.add(day2);
            TimeUtils.increaseByDay(calendar);
            if (++col <= 6) continue;
            col = 0;
            ++row;
        }
        do {
            boolean weekend = calendar.get(7) == 1 || calendar.get(7) == 7;
            boolean selected = this.date != null && TimeUtils.isSameDay(calendar, (Long)this.date.getTime());
            thisDate = calendar.getTime();
            day = new WebToggleButton();
            day.setForeground(weekend ? this.weekendsForeground : this.currentMonthForeground);
            day.setText("" + calendar.get(5));
            day.setSelected(selected);
            day.setRolloverDecoratedOnly(true);
            day.setHorizontalAlignment(4);
            day.setRound(StyleConstants.smallRound);
            day.setFocusable(false);
            day.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebCalendar.this.lastSelectedDayButton = (WebToggleButton)e.getSource();
                    WebCalendar.this.setDateImpl(thisDate);
                }
            });
            if (this.dateCustomizer != null) {
                this.dateCustomizer.customize(day, thisDate);
            }
            monthDays.add((Component)day, col * 2 + "," + row);
            dates.add(day);
            if (selected) {
                this.lastSelectedDayButton = day;
            }
            TimeUtils.increaseByDay(calendar);
            if (++col <= 6) continue;
            col = 0;
            ++row;
        } while (calendar.get(5) > 1);
        int left = 42 - (monthDays.getComponentCount() - 6);
        for (int i = 1; i <= left; ++i) {
            thisDate = calendar.getTime();
            day = new WebToggleButton();
            day.setForeground(this.otherMonthForeground);
            day.setText("" + calendar.get(5));
            day.setRolloverDecoratedOnly(true);
            day.setHorizontalAlignment(4);
            day.setRound(StyleConstants.smallRound);
            day.setFocusable(false);
            day.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    WebToggleButton dayButton = (WebToggleButton)e.getSource();
                    if (dayButton.isSelected()) {
                        WebCalendar.this.setDateImpl(thisDate);
                    }
                }
            });
            if (this.dateCustomizer != null) {
                this.dateCustomizer.customize(day, thisDate);
            }
            monthDays.add((Component)day, col * 2 + "," + row);
            dates.add(day);
            TimeUtils.increaseByDay(calendar);
            if (++col <= 6) continue;
            col = 0;
            ++row;
        }
        monthDays.revalidate();
    }

    public SimpleDateFormat getTitleFormat() {
        return this.titleFormat;
    }

    public void setTitleFormat(SimpleDateFormat titleFormat) {
        this.titleFormat = titleFormat;
        this.updateTitleLabel();
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.setDate(date, this.isAnimate());
    }

    public void setDate(Date date, boolean animate) {
        if (!CompareUtils.equals(this.date, date)) {
            this.setDateImpl(date, animate);
        }
    }

    protected void setDateImpl(Date date) {
        this.setDateImpl(date, this.isAnimate());
    }

    protected void setDateImpl(Date date, boolean animate) {
        this.date = date;
        this.setShownDate(date, animate);
        this.fireDateSelected(date);
    }

    public Date getShownDate() {
        return this.shownDate;
    }

    public void setShownDate(Date date) {
        this.setShownDate(date, this.isAnimate());
    }

    public void setShownDate(Date date, boolean animate) {
        if (date == null) {
            date = new Date();
        }
        this.oldShownDate = this.shownDate;
        this.shownDate = date;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.oldShownDate);
        int oldMonth = calendar.get(2);
        int oldYear = calendar.get(1);
        calendar.setTime(date);
        int newMonth = calendar.get(2);
        int newYear = calendar.get(1);
        if (oldMonth != newMonth || oldYear != newYear) {
            this.updateTitleLabel();
            this.updateMonth(animate);
        }
    }

    public boolean isStartWeekFromSunday() {
        return this.startWeekFromSunday;
    }

    public void setStartWeekFromSunday(boolean startWeekFromSunday) {
        this.startWeekFromSunday = startWeekFromSunday;
        this.updateWeekHeaders();
        this.updateMonth(this.monthDays);
    }

    public boolean isAnimate() {
        return this.animate;
    }

    public void setAnimate(boolean animate) {
        this.animate = animate;
    }

    public boolean isHorizontalSlide() {
        return this.horizontalSlide;
    }

    public void setHorizontalSlide(boolean horizontalSlide) {
        this.horizontalSlide = horizontalSlide;
    }

    public Color getOtherMonthForeground() {
        return this.otherMonthForeground;
    }

    public void setOtherMonthForeground(Color color) {
        this.otherMonthForeground = color;
        this.updateMonth(this.monthDays);
    }

    public Color getCurrentMonthForeground() {
        return this.currentMonthForeground;
    }

    public void setCurrentMonthForeground(Color color) {
        this.currentMonthForeground = color;
        this.updateMonth(this.monthDays);
    }

    public Color getWeekendsForeground() {
        return this.weekendsForeground;
    }

    public void setWeekendsForeground(Color color) {
        this.weekendsForeground = color;
        this.updateMonth(this.monthDays);
    }

    public DateCustomizer getDateCustomizer() {
        return this.dateCustomizer;
    }

    public void setDateCustomizer(DateCustomizer dateCustomizer) {
        this.dateCustomizer = dateCustomizer;
        this.updateMonth(this.monthDays);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        SwingUtils.setEnabledRecursively(this, enabled, true);
    }

    public void addDateSelectionListener(DateSelectionListener listener) {
        this.dateSelectionListeners.add(listener);
    }

    public void removeDateSelectionListener(DateSelectionListener listener) {
        this.dateSelectionListeners.remove(listener);
    }

    public void fireDateSelected(Date date) {
        for (DateSelectionListener listener : CollectionUtils.copy(this.dateSelectionListeners)) {
            listener.dateSelected(date);
        }
    }
}

