/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.filechooser;

import com.alee.extended.drag.FileDragAndDropHandler;
import com.alee.extended.filechooser.FilesSelectionListener;
import com.alee.extended.layout.HorizontalFlowLayout;
import com.alee.extended.panel.CenterPanel;
import com.alee.global.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.filechooser.WebFileChooser;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.filefilter.AbstractFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class WebFileChooserField
extends WebPanel {
    public static final ImageIcon CROSS_ICON = new ImageIcon(WebFileChooserField.class.getResource("icons/cross.png"));
    private final List<FilesSelectionListener> listeners = new ArrayList<FilesSelectionListener>(1);
    private final List<File> selectedFiles = new ArrayList<File>();
    protected boolean multiSelectionEnabled = false;
    private boolean showFileShortName = true;
    private boolean showFileIcon = true;
    private boolean showRemoveButton = true;
    private boolean showFileExtensions = false;
    private boolean showChooseButton = true;
    private boolean filesDropEnabled = true;
    private WebFileChooser webFileChooser = null;
    private final WebPanel contentPanel;
    private final WebScrollPane scroll;
    private WebButton chooseButton;

    public WebFileChooserField() {
        this((Window)null);
    }

    public WebFileChooserField(Window parent) {
        this(parent, true);
    }

    public WebFileChooserField(boolean showChooseButton) {
        this((Window)null, showChooseButton);
    }

    public WebFileChooserField(final Window owner, boolean showChooseButton) {
        super(true);
        this.showChooseButton = showChooseButton;
        this.setOpaque(false);
        this.setLayout(new BorderLayout(0, 0));
        this.setWebColoredBackground(false);
        this.setPaintFocus(true);
        this.setMargin(-1);
        this.setBackground(Color.WHITE);
        this.contentPanel = new WebPanel();
        this.contentPanel.setOpaque(false);
        this.setTransferHandler(new FileDragAndDropHandler(){

            @Override
            public boolean isDropEnabled() {
                return WebFileChooserField.this.filesDropEnabled;
            }

            @Override
            public boolean filesDropped(List<File> files) {
                WebFileChooserField.this.setSelectedFiles(files);
                return WebFileChooserField.this.getSelectedFiles().size() > 0;
            }
        });
        this.contentPanel.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                Rectangle vr = WebFileChooserField.this.contentPanel.getVisibleRect();
                WebFileChooserField.this.contentPanel.scrollRectToVisible(new Rectangle(vr.x + e.getWheelRotation() * 25, vr.y, vr.width, vr.height));
            }
        });
        this.scroll = new WebScrollPane(this.contentPanel, false){

            @Override
            public Dimension getPreferredSize() {
                Dimension ps = super.getPreferredSize();
                ps.height = ((WebFileChooserField)WebFileChooserField.this).contentPanel.getPreferredSize().height;
                return ps;
            }
        };
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.scroll.setVerticalScrollBarPolicy(21);
        this.scroll.setMargin(1);
        this.scroll.setOpaque(false);
        this.scroll.getViewport().setOpaque(false);
        this.add((Component)this.scroll, (Object)"Center");
        if (this.showChooseButton) {
            this.webFileChooser = new WebFileChooser();
            this.webFileChooser.setMultiSelectionEnabled(this.multiSelectionEnabled);
            this.webFileChooser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals("ApproveSelection")) {
                        WebFileChooserField.this.setSelectedFiles(CollectionUtils.toList(WebFileChooserField.this.webFileChooser.getSelectedFiles()));
                    }
                }
            });
            this.chooseButton = new WebButton("...");
            this.chooseButton.setRound(this.getRound());
            this.chooseButton.setLeftRightSpacing(StyleConstants.smallLeftRightSpacing);
            this.chooseButton.setDrawFocus(false);
            this.chooseButton.setDrawLeft(false);
            this.chooseButton.setDrawLeftLine(true);
            this.chooseButton.setRolloverDarkBorderOnly(false);
            this.chooseButton.setShadeWidth(0);
            this.chooseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebFileChooserField.this.webFileChooser.showOpenDialog(owner);
                    WebFileChooserField.this.chooseButton.requestFocusInWindow();
                }
            });
            this.contentPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        WebFileChooserField.this.chooseButton.doClick(0);
                    }
                }
            });
            this.add((Component)this.chooseButton, (Object)"After");
        }
        this.updateContentLayout();
    }

    private void updateContentLayout() {
        this.contentPanel.setLayout(new HorizontalFlowLayout(0, !this.multiSelectionEnabled));
    }

    public WebFileChooser getWebFileChooser() {
        return this.webFileChooser;
    }

    public WebButton getChooseButton() {
        return this.chooseButton;
    }

    public boolean isShowChooseButton() {
        return this.showChooseButton;
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelectionEnabled;
    }

    public void setMultiSelectionEnabled(boolean multiSelectionEnabled) {
        this.multiSelectionEnabled = multiSelectionEnabled;
        if (this.webFileChooser != null) {
            this.webFileChooser.setMultiSelectionEnabled(multiSelectionEnabled);
        }
        this.updateContentLayout();
    }

    public boolean isFilesDropEnabled() {
        return this.filesDropEnabled;
    }

    public void setFilesDropEnabled(boolean filesDropEnabled) {
        this.filesDropEnabled = filesDropEnabled;
    }

    public boolean isShowFileShortName() {
        return this.showFileShortName;
    }

    public void setShowFileShortName(boolean showFileShortName) {
        this.showFileShortName = showFileShortName;
        this.updateSelectedFiles();
    }

    public boolean isShowFileIcon() {
        return this.showFileIcon;
    }

    public void setShowFileIcon(boolean showFileIcon) {
        this.showFileIcon = showFileIcon;
        this.updateSelectedFiles();
    }

    public boolean isShowRemoveButton() {
        return this.showRemoveButton;
    }

    public void setShowRemoveButton(boolean showRemoveButton) {
        this.showRemoveButton = showRemoveButton;
        this.updateSelectedFiles();
    }

    public boolean isShowFileExtensions() {
        return this.showFileExtensions;
    }

    public void setShowFileExtensions(boolean showFileExtensions) {
        this.showFileExtensions = showFileExtensions;
        this.updateSelectedFiles();
    }

    public List<File> getSelectedFiles() {
        return this.selectedFiles;
    }

    public void setSelectedFile(File selectedFile) {
        this.selectedFiles.clear();
        if (selectedFile != null && FileUtils.isFileAccepted(selectedFile, this.getAvailableFilters())) {
            this.selectedFiles.add(selectedFile);
        }
        this.updateSelectedFiles();
        this.fireSelectionChanged(this.selectedFiles);
    }

    public void setSelectedFiles(List<File> selectedFiles) {
        this.selectedFiles.clear();
        if (selectedFiles != null && selectedFiles.size() > 0) {
            if (this.multiSelectionEnabled) {
                for (File file : selectedFiles) {
                    if (!FileUtils.isFileAccepted(file, this.getAvailableFilters())) continue;
                    this.selectedFiles.add(file);
                }
            } else {
                for (File file : selectedFiles) {
                    if (!FileUtils.isFileAccepted(file, this.getAvailableFilters())) continue;
                    this.selectedFiles.add(file);
                    break;
                }
            }
        }
        this.updateSelectedFiles();
        this.fireSelectionChanged(this.selectedFiles);
    }

    public void clearSelectedFiles() {
        this.setSelectedFiles(null);
    }

    private void updateSelectedFiles() {
        this.contentPanel.removeAll();
        for (File file : this.selectedFiles) {
            FilePlate filePlate = new FilePlate(file);
            filePlate.applyComponentOrientation(this.getComponentOrientation());
            this.contentPanel.add((Component)filePlate);
        }
        this.revalidate();
        this.repaint();
    }

    private List<AbstractFileFilter> getAvailableFilters() {
        return this.webFileChooser == null ? null : this.webFileChooser.getAvailableFilters();
    }

    public void addSelectedFilesListener(FilesSelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectedFilesListener(FilesSelectionListener listener) {
        this.listeners.remove(listener);
    }

    private void fireSelectionChanged(List<File> selectedFiles) {
        for (FilesSelectionListener listener : CollectionUtils.copy(this.listeners)) {
            listener.selectionChanged(selectedFiles);
        }
    }

    public class FilePlate
    extends WebPanel {
        public FilePlate(final File file) {
            super(true);
            this.setLayout(new BorderLayout());
            this.setPaintSides(false, false, false, true);
            this.setShadeWidth(0);
            this.setMargin(0, 3, 0, 1);
            this.setFocusable(true);
            String actualFileName = FileUtils.getDisplayFileName(file);
            final String displayFileName = WebFileChooserField.this.showFileExtensions || file.isDirectory() ? actualFileName : FileUtils.getFileNamePart(actualFileName);
            final String absolutePath = file.getAbsolutePath();
            final WebLabel fileName = new WebLabel(WebFileChooserField.this.showFileShortName ? displayFileName : absolutePath);
            fileName.setIcon(WebFileChooserField.this.showFileIcon ? FileUtils.getFileIcon(file, false) : null);
            fileName.setMargin(0, 0, 0, 2);
            this.add((Component)fileName, (Object)"Center");
            this.addMouseListener(new MouseAdapter(){
                private boolean showShortName;
                {
                    this.showShortName = WebFileChooserField.this.showFileShortName;
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    FilePlate.this.requestFocusInWindow();
                    if (SwingUtilities.isRightMouseButton(e)) {
                        if (WebFileChooserField.this.multiSelectionEnabled) {
                            this.showShortName = !this.showShortName;
                            fileName.setText(this.showShortName ? displayFileName : absolutePath);
                        } else {
                            WebFileChooserField.this.setShowFileShortName(!WebFileChooserField.this.isShowFileShortName());
                        }
                    }
                    FilePlate.this.scrollToPlate();
                }
            });
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    FilePlate.this.scrollToPlate();
                }
            });
            if (WebFileChooserField.this.showRemoveButton) {
                WebButton remove = new WebButton(CROSS_ICON);
                remove.setLeftRightSpacing(0);
                remove.setInnerShadeWidth(2);
                remove.setRound(StyleConstants.smallRound);
                remove.setShadeWidth(StyleConstants.shadeWidth);
                remove.setFocusable(false);
                remove.setRolloverDecoratedOnly(true);
                remove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WebFileChooserField.this.selectedFiles.remove(file);
                        WebFileChooserField.this.contentPanel.remove((Component)FilePlate.this);
                        WebFileChooserField.this.revalidate();
                        WebFileChooserField.this.repaint();
                        WebFileChooserField.this.fireSelectionChanged(WebFileChooserField.this.selectedFiles);
                    }
                });
                this.add((Component)new CenterPanel(remove), (Object)"After");
            }
        }

        private void scrollToPlate() {
            Rectangle b = this.getBounds();
            int w = WebFileChooserField.this.scroll.getWidth() - 2;
            b.width = w < b.width ? w : b.width;
            WebFileChooserField.this.contentPanel.scrollRectToVisible(b);
        }
    }
}

