/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.filechooser;

import com.alee.extended.filechooser.WebFileTableCellEditor;
import com.alee.extended.filechooser.WebFileTableCellRenderer;
import com.alee.extended.filechooser.WebFileTableColumns;
import com.alee.extended.filechooser.WebFileTableModel;
import com.alee.extended.filechooser.WebFileTableStyle;
import com.alee.laf.table.WebTable;
import com.alee.utils.FileUtils;
import com.alee.utils.filefilter.AbstractFileFilter;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.table.TableColumn;

public class WebFileTable
extends WebTable
implements WebFileTableColumns {
    private AbstractFileFilter fileFilter = WebFileTableStyle.fileFilter;
    private File displayedDirectory;

    public WebFileTable() {
        this.setVisibleRowCount(18);
        this.setRowHeight(22);
        this.setShowHorizontalLines(true);
        this.setShowVerticalLines(false);
        this.setGridColor(new Color(237, 237, 237));
        this.setModel(new WebFileTableModel());
        this.updateColumnSizes();
        this.setDefaultRenderer(File.class, new WebFileTableCellRenderer());
        this.setEditable(true);
        this.setDefaultEditor(File.class, new WebFileTableCellEditor());
    }

    private void updateColumnSizes() {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            WebFileTableModel model = this.getFileTableModel();
            TableColumn column = this.getColumnModel().getColumn(i);
            column.setIdentifier(model.getColumnId(i));
            if (model.getColumnId(i).equals("weblaf.filechooser.table.column.number")) {
                column.setPreferredWidth(30);
                continue;
            }
            if (model.getColumnId(i).equals("weblaf.filechooser.table.column.name")) {
                column.setPreferredWidth(340);
                continue;
            }
            if (model.getColumnId(i).equals("weblaf.filechooser.table.column.size") || model.getColumnId(i).equals("weblaf.filechooser.table.column.extension")) {
                column.setPreferredWidth(90);
                continue;
            }
            if (!model.getColumnId(i).equals("weblaf.filechooser.table.column.creation.date") && !model.getColumnId(i).equals("weblaf.filechooser.table.column.modification.date")) continue;
            column.setPreferredWidth(130);
        }
    }

    public WebFileTableModel getFileTableModel() {
        return (WebFileTableModel)this.getModel();
    }

    public AbstractFileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(AbstractFileFilter fileFilter) {
        this.fileFilter = fileFilter;
        this.reloadFiles();
    }

    public void reloadFiles() {
        this.setDisplayedDirectory(this.getDisplayedDirectory());
    }

    public File getDisplayedDirectory() {
        return this.displayedDirectory;
    }

    public void setDisplayedDirectory(File file) {
        this.stopCellEditing();
        List<File> oldSelection = this.getSelectedFiles();
        File[] listedFiles = file != null ? FileUtils.listFiles(file, this.fileFilter) : null;
        File[] files = file != null ? FileUtils.sortFiles(listedFiles) : FileUtils.getDiskRoots();
        this.getFileTableModel().setFiles(Arrays.asList(files));
        if (FileUtils.equals(this.displayedDirectory, file)) {
            this.setSelectedFiles(oldSelection);
        }
        this.displayedDirectory = file;
    }

    public void setFiles(Collection<File> files) {
        this.displayedDirectory = null;
        this.getFileTableModel().setFiles(files);
    }

    public void addFiles(Collection<File> files) {
        this.getFileTableModel().addFiles(files);
    }

    public void setColumns(String ... columns) {
        this.setColumns(Arrays.asList(columns));
    }

    public void setColumns(List<String> columns) {
        this.getFileTableModel().setColumns(columns);
        this.updateColumnSizes();
    }

    public File getSelectedFile() {
        int row = this.getSelectedRow();
        return row != -1 ? this.getFileAtRow(this.convertRowIndexToModel(row)) : null;
    }

    public List<File> getSelectedFiles() {
        int[] selectedRows = this.getSelectedRows();
        ArrayList<File> selectedFiles = new ArrayList<File>(selectedRows.length);
        for (int row : selectedRows) {
            selectedFiles.add(this.getFileAtRow(this.convertRowIndexToModel(row)));
        }
        return selectedFiles;
    }

    private File getFileAtRow(int row) {
        return this.getFileTableModel().getFileAtRow(row);
    }

    public void setSelectedFile(File file) {
        this.setSelectedFile(file, true);
    }

    public void setSelectedFile(File file, boolean shouldScroll) {
        int row = this.getFileTableModel().getFileRow(file);
        this.setSelectedRow(row == -1 ? -1 : this.convertRowIndexToView(row), shouldScroll);
    }

    public void setSelectedFiles(File[] files) {
        this.clearSelection();
        for (File file : files) {
            int row = this.getFileTableModel().getFileRow(file);
            if (row == -1) continue;
            this.addSelectedRow(this.convertRowIndexToView(row));
        }
    }

    public boolean isColumnDisplayed(String column) {
        return this.getFileTableModel().isColumnDisplayed(column);
    }

    public void setSelectedFiles(Collection<File> files) {
        this.clearSelection();
        for (File file : files) {
            int row = this.getFileTableModel().getFileRow(file);
            if (row == -1) continue;
            this.addSelectedRow(this.convertRowIndexToView(row));
        }
    }

    public boolean editSelectedFileName() {
        int row = this.getSelectedRow();
        return row != -1 && this.editFileNameAt(this.convertRowIndexToModel(row));
    }

    public boolean editFileName(File file) {
        return this.editFileNameAt(this.getFileTableModel().getFileRow(file));
    }

    public boolean editFileNameAt(int row) {
        return row != 1 && this.isColumnDisplayed("weblaf.filechooser.table.column.name") && this.editCellAt(this.convertRowIndexToView(row), this.getColumnModel().getColumnIndex("weblaf.filechooser.table.column.name"));
    }
}

