/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.global.StyleConstants;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingConstants;

public class ToolbarLayout
extends AbstractLayoutManager
implements SwingConstants {
    public static final String START = "START";
    public static final String MIDDLE = "MIDDLE";
    public static final String FILL = "FILL";
    public static final String END = "END";
    protected Map<Component, String> constraints = new HashMap<Component, String>();
    protected int spacing = StyleConstants.contentSpacing;
    protected int partsSpacing = StyleConstants.largeContentSpacing;
    protected int orientation = 0;
    protected Insets margin = null;

    public ToolbarLayout() {
    }

    public ToolbarLayout(int spacing) {
        this.spacing = spacing;
    }

    public ToolbarLayout(int spacing, int orientation) {
        this.spacing = spacing;
        this.orientation = orientation;
    }

    public ToolbarLayout(int spacing, int partsSpacing, int orientation) {
        this.spacing = spacing;
        this.partsSpacing = partsSpacing;
        this.orientation = orientation;
    }

    public Map<Component, String> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(Map<Component, String> constraints) {
        this.constraints = constraints;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public int getPartsSpacing() {
        return this.partsSpacing;
    }

    public void setPartsSpacing(int partsSpacing) {
        this.partsSpacing = partsSpacing;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets margin) {
        this.margin = margin;
    }

    @Override
    public void addComponent(Component component, Object constraints) {
        String value = (String)constraints;
        if (!(value == null || value.trim().equals("") || value.equals(START) || value.equals(MIDDLE) || value.equals(FILL) || value.equals(END))) {
            throw new IllegalArgumentException("Cannot add to layout: constraint must be null or an empty/'START'/'MIDDLE'/'FILL'/'END' string");
        }
        this.constraints.put(component, value == null || value.trim().equals("") ? START : value);
    }

    @Override
    public void removeComponent(Component component) {
        this.constraints.remove(component);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        boolean addPartsSpacing;
        Insets insets = this.getActualInsets(parent);
        Dimension ps = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        int componentCount = parent.getComponentCount();
        for (int i = 0; i < componentCount; ++i) {
            Component component = parent.getComponent(i);
            Dimension cps = component.getPreferredSize();
            if (this.orientation == 0) {
                ps.width = ps.width + (cps.width + (i < componentCount - 1 ? this.spacing : 0));
                ps.height = Math.max(ps.height, cps.height + insets.top + insets.bottom);
                continue;
            }
            ps.width = Math.max(ps.width, cps.width + insets.left + insets.right);
            ps.height = ps.height + (cps.height + (i < componentCount - 1 ? this.spacing : 0));
        }
        boolean bl = addPartsSpacing = this.hasElement(START) && this.hasElement(END) && !this.hasElement(MIDDLE) && !this.hasElement(FILL);
        if (this.orientation == 0) {
            if (addPartsSpacing) {
                ps.width += this.partsSpacing;
            }
        } else if (addPartsSpacing) {
            ps.height += this.partsSpacing;
        }
        return ps;
    }

    @Override
    public void layoutContainer(Container parent) {
        block18: {
            Insets insets;
            block16: {
                block17: {
                    insets = this.getActualInsets(parent);
                    if (this.orientation != 0) break block16;
                    if (!parent.getComponentOrientation().isLeftToRight()) break block17;
                    int startX = insets.left;
                    for (int i = 0; i < parent.getComponentCount(); ++i) {
                        Component component = parent.getComponent(i);
                        if (this.constraints.get(component) != null && !this.constraints.get(component).trim().equals("") && !this.constraints.get(component).equals(START)) continue;
                        Dimension ps = component.getPreferredSize();
                        component.setBounds(startX, insets.top, ps.width, parent.getHeight() - insets.top - insets.bottom);
                        startX += ps.width + this.spacing;
                    }
                    int endX = parent.getWidth() - insets.right;
                    if (this.hasElement(END)) {
                        for (int i = parent.getComponentCount() - 1; i >= 0; --i) {
                            Component component = parent.getComponent(i);
                            if (this.constraints.get(component) == null || !this.constraints.get(component).equals(END)) continue;
                            Dimension ps = component.getPreferredSize();
                            component.setBounds(endX -= ps.width, insets.top, ps.width, parent.getHeight() - insets.top - insets.bottom);
                            endX -= this.spacing;
                        }
                    }
                    if (endX <= startX || !this.hasElement(MIDDLE) && !this.hasElement(FILL)) break block18;
                    for (Component component : parent.getComponents()) {
                        if (this.constraints.get(component) == null) continue;
                        if (this.constraints.get(component).equals(MIDDLE)) {
                            Dimension ps = component.getPreferredSize();
                            component.setBounds(Math.max(startX, (startX + endX) / 2 - ps.width / 2), insets.top, Math.min(ps.width, endX - startX), parent.getHeight() - insets.top - insets.bottom);
                            continue;
                        }
                        if (!this.constraints.get(component).equals(FILL)) continue;
                        component.setBounds(startX, insets.top, Math.max(0, endX - startX), parent.getHeight() - insets.top - insets.bottom);
                    }
                    break block18;
                }
                int startX = insets.left;
                if (this.hasElement(END)) {
                    for (int i = parent.getComponentCount() - 1; i >= 0; --i) {
                        Component component = parent.getComponent(i);
                        if (this.constraints.get(component) == null || !this.constraints.get(component).equals(END)) continue;
                        Dimension ps = component.getPreferredSize();
                        component.setBounds(startX, insets.top, ps.width, parent.getHeight() - insets.top - insets.bottom);
                        startX += ps.width + this.spacing;
                    }
                }
                int endX = parent.getWidth() - insets.right;
                for (int i = 0; i < parent.getComponentCount(); ++i) {
                    Component component = parent.getComponent(i);
                    if (this.constraints.get(component) != null && !this.constraints.get(component).trim().equals("") && !this.constraints.get(component).equals(START)) continue;
                    Dimension ps = component.getPreferredSize();
                    component.setBounds(endX -= ps.width, insets.top, ps.width, parent.getHeight() - insets.top - insets.bottom);
                    endX -= this.spacing;
                }
                if (endX <= startX || !this.hasElement(MIDDLE) && !this.hasElement(FILL)) break block18;
                for (Component component : parent.getComponents()) {
                    if (this.constraints.get(component) == null) continue;
                    if (this.constraints.get(component).equals(MIDDLE)) {
                        Dimension ps = component.getPreferredSize();
                        component.setBounds(Math.max(startX, (startX + endX) / 2 - ps.width / 2), insets.top, Math.min(ps.width, endX - startX), parent.getHeight() - insets.top - insets.bottom);
                        continue;
                    }
                    if (!this.constraints.get(component).equals(FILL)) continue;
                    component.setBounds(startX, insets.top, Math.max(0, endX - startX), parent.getHeight() - insets.top - insets.bottom);
                }
                break block18;
            }
            int startY = insets.top;
            for (int i = 0; i < parent.getComponentCount(); ++i) {
                Component component = parent.getComponent(i);
                if (this.constraints.get(component) != null && !this.constraints.get(component).equals(START)) continue;
                Dimension ps = component.getPreferredSize();
                component.setBounds(insets.left, startY, parent.getWidth() - insets.left - insets.right, ps.height);
                startY += ps.height + this.spacing;
            }
            int endY = parent.getHeight() - insets.bottom;
            if (this.hasElement(END)) {
                for (int i = parent.getComponentCount() - 1; i >= 0; --i) {
                    Component component = parent.getComponent(i);
                    if (this.constraints.get(component) == null || !this.constraints.get(component).equals(END)) continue;
                    Dimension ps = component.getPreferredSize();
                    component.setBounds(insets.left, endY -= ps.height, parent.getWidth() - insets.left - insets.right, ps.height);
                    endY -= this.spacing;
                }
            }
            if (endY > startY && (this.hasElement(MIDDLE) || this.hasElement(FILL))) {
                for (Component component : parent.getComponents()) {
                    if (this.constraints.get(component) == null) continue;
                    if (this.constraints.get(component).equals(MIDDLE)) {
                        Dimension ps = component.getPreferredSize();
                        component.setBounds(insets.left, Math.max(startY, (startY + endY) / 2 - ps.height / 2), parent.getWidth() - insets.left - insets.right, Math.min(ps.height, endY - startY));
                        continue;
                    }
                    if (!this.constraints.get(component).equals(FILL)) continue;
                    component.setBounds(insets.left, startY, parent.getWidth() - insets.left - insets.right, Math.max(0, endY - startY));
                }
            }
        }
    }

    protected boolean hasElement(String element) {
        return this.constraints.containsValue(element);
    }

    protected Insets getActualInsets(Container container) {
        if (this.margin != null) {
            Insets insets = container.getInsets();
            insets.top += this.margin.top;
            insets.left += this.margin.left;
            insets.bottom += this.margin.bottom;
            insets.right += this.margin.right;
            return insets;
        }
        return container.getInsets();
    }
}

