/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.list;

import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.extended.list.FileElement;
import com.alee.extended.list.FileListViewType;
import com.alee.extended.list.ThumbnailGenerator;
import com.alee.extended.list.WebFileList;
import com.alee.laf.label.WebLabel;
import com.alee.laf.list.WebListCellRenderer;
import com.alee.utils.FileUtils;
import com.alee.utils.file.FileDescription;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;

public class WebFileListCellRenderer
extends WebListCellRenderer {
    public static final Dimension tileCellSize = new Dimension(220, 65);
    public static final Dimension iconCellSize = new Dimension(90, 90);
    public static final Insets tileCellMargin = new Insets(6, 6, 5, 8);
    public static final Insets iconCellMargin = new Insets(5, 5, 8, 5);
    public static final int thumbSize = 50;
    public static final int imageSide = 54;
    public static final int gap = 4;
    protected WebFileList fileList;
    protected WebLabel iconLabel;
    protected WebLabel nameLabel;
    protected WebLabel sizeLabel;
    protected WebLabel descriptionLabel;

    public WebFileListCellRenderer(final WebFileList fileList) {
        this.fileList = fileList;
        this.iconLabel = new WebLabel();
        this.iconLabel.setHorizontalAlignment(0);
        this.iconLabel.setPreferredSize(new Dimension(54, 54));
        this.nameLabel = new WebLabel();
        this.nameLabel.setFont(this.nameLabel.getFont().deriveFont(0));
        this.nameLabel.setForeground(Color.BLACK);
        this.nameLabel.setVerticalAlignment(0);
        this.descriptionLabel = new WebLabel(10);
        this.descriptionLabel.setFont(this.descriptionLabel.getFont().deriveFont(0));
        this.descriptionLabel.setForeground(Color.GRAY);
        this.sizeLabel = new WebLabel(10);
        this.sizeLabel.setFont(this.sizeLabel.getFont().deriveFont(0));
        this.sizeLabel.setForeground(new Color(49, 77, 179));
        this.setLayout(new FileCellLayout());
        this.add(this.iconLabel);
        this.add(this.nameLabel);
        this.add(this.descriptionLabel);
        this.add(this.sizeLabel);
        fileList.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean enabled = fileList.isEnabled();
                WebFileListCellRenderer.this.iconLabel.setEnabled(enabled);
                WebFileListCellRenderer.this.nameLabel.setEnabled(enabled);
                WebFileListCellRenderer.this.descriptionLabel.setEnabled(enabled);
                WebFileListCellRenderer.this.sizeLabel.setEnabled(enabled);
            }
        });
        fileList.addPropertyChangeListener("componentOrientation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ComponentOrientation orientation = fileList.getComponentOrientation();
                WebFileListCellRenderer.this.nameLabel.setComponentOrientation(orientation);
                WebFileListCellRenderer.this.descriptionLabel.setComponentOrientation(orientation);
                WebFileListCellRenderer.this.sizeLabel.setComponentOrientation(orientation);
            }
        });
        this.updateFilesView();
    }

    public Rectangle getDescriptionBounds() {
        return ((FileCellLayout)this.getLayout()).getDescriptionBounds();
    }

    public void updateFilesView() {
        if (this.isTilesView()) {
            this.nameLabel.setHorizontalAlignment(10);
            this.fileList.setFixedCellWidth(WebFileListCellRenderer.tileCellSize.width);
            this.fileList.setFixedCellHeight(WebFileListCellRenderer.tileCellSize.height);
        } else {
            this.nameLabel.setHorizontalAlignment(0);
            this.fileList.setFixedCellWidth(WebFileListCellRenderer.iconCellSize.width);
            this.fileList.setFixedCellHeight(WebFileListCellRenderer.iconCellSize.height);
        }
    }

    public JLabel getIconLabel() {
        return this.iconLabel;
    }

    public JLabel getNameLabel() {
        return this.nameLabel;
    }

    public JLabel getSizeLabel() {
        return this.sizeLabel;
    }

    public JLabel getDescriptionLabel() {
        return this.descriptionLabel;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent(list, "", index, isSelected, cellHasFocus);
        FileElement element = (FileElement)value;
        File file = element.getFile();
        this.setMargin(this.isTilesView() ? tileCellMargin : iconCellMargin);
        String imageSize = null;
        if (this.iconLabel.isEnabled()) {
            ThumbnailGenerator.queueThumbnailLoad(this.fileList, element, false);
            ImageIcon thumbnail = element.getEnabledThumbnail();
            this.iconLabel.setIcon(thumbnail);
            if (thumbnail != null) {
                imageSize = thumbnail.getDescription();
            }
        } else {
            ThumbnailGenerator.queueThumbnailLoad(this.fileList, element, true);
            this.iconLabel.setDisabledIcon(element.getDisabledThumbnail());
        }
        if (this.fileList.getEditedCell() != index) {
            FileDescription fileDescription = FileUtils.getFileDescription(file, imageSize);
            this.nameLabel.setText(fileDescription.getName());
            if (this.isTilesView()) {
                this.descriptionLabel.setText(fileDescription.getDescription());
                if (fileDescription.getSize() != null) {
                    this.sizeLabel.setText(fileDescription.getSize());
                } else {
                    this.sizeLabel.setText(null);
                }
            } else {
                this.descriptionLabel.setText(null);
                this.sizeLabel.setText(null);
            }
        } else {
            this.nameLabel.setText(null);
            this.descriptionLabel.setText(null);
            this.sizeLabel.setText(null);
        }
        return this;
    }

    protected boolean isTilesView() {
        return this.fileList.getFileListViewType().equals((Object)FileListViewType.tiles);
    }

    protected class FileCellLayout
    extends AbstractLayoutManager {
        protected FileCellLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return WebFileListCellRenderer.this.isTilesView() ? tileCellSize : iconCellSize;
        }

        @Override
        public void layoutContainer(Container parent) {
            boolean ltr = WebFileListCellRenderer.this.fileList.getComponentOrientation().isLeftToRight();
            Insets i = WebFileListCellRenderer.this.getInsets();
            boolean tilesView = WebFileListCellRenderer.this.isTilesView();
            boolean hasName = WebFileListCellRenderer.this.nameLabel.getText() != null;
            boolean hasDescription = tilesView && WebFileListCellRenderer.this.descriptionLabel.getText() != null;
            boolean hasFileSize = tilesView && WebFileListCellRenderer.this.sizeLabel.getText() != null;
            WebFileListCellRenderer.this.nameLabel.setVisible(hasName);
            WebFileListCellRenderer.this.descriptionLabel.setVisible(hasDescription);
            WebFileListCellRenderer.this.sizeLabel.setVisible(hasFileSize);
            if (tilesView) {
                WebFileListCellRenderer.this.iconLabel.setBounds(ltr ? i.left : WebFileListCellRenderer.tileCellSize.width - i.right - 54, i.top, 54, 54);
                if (hasName) {
                    Dimension nps = WebFileListCellRenderer.this.nameLabel.getPreferredSize();
                    Dimension dps = hasDescription ? WebFileListCellRenderer.this.descriptionLabel.getPreferredSize() : new Dimension(0, 0);
                    Dimension sps = hasFileSize ? WebFileListCellRenderer.this.sizeLabel.getPreferredSize() : new Dimension(0, 0);
                    int dh = nps.height + (hasDescription ? 4 + dps.height : 0) + (hasFileSize ? 4 + sps.height : 0);
                    int dx = ltr ? i.left + 54 + 4 : i.left;
                    int dw = WebFileListCellRenderer.tileCellSize.width - i.left - i.right - 54 - 4;
                    int dy = i.top + (WebFileListCellRenderer.tileCellSize.height - i.top - i.bottom) / 2 - dh / 2;
                    WebFileListCellRenderer.this.nameLabel.setBounds(dx, dy, dw, nps.height);
                    dy += nps.height + 4;
                    if (hasDescription) {
                        WebFileListCellRenderer.this.descriptionLabel.setBounds(dx, dy, dw, dps.height);
                        dy += dps.height + 4;
                    }
                    if (hasFileSize) {
                        WebFileListCellRenderer.this.sizeLabel.setBounds(dx, dy, dw, sps.height);
                    }
                }
            } else {
                int cw = WebFileListCellRenderer.iconCellSize.width - i.left - i.right;
                WebFileListCellRenderer.this.iconLabel.setBounds(i.left + cw / 2 - 27, i.top, 54, 54);
                if (hasName) {
                    int ny = i.top + 54 + 4;
                    WebFileListCellRenderer.this.nameLabel.setBounds(i.left, ny, cw, WebFileListCellRenderer.iconCellSize.height - ny - i.bottom);
                }
            }
        }

        public Rectangle getDescriptionBounds() {
            boolean ltr = WebFileListCellRenderer.this.fileList.getComponentOrientation().isLeftToRight();
            Insets i = WebFileListCellRenderer.this.getInsets();
            boolean tilesView = WebFileListCellRenderer.this.isTilesView();
            if (tilesView) {
                if (ltr) {
                    int x = i.left + 54 + 4;
                    return new Rectangle(x, i.top, WebFileListCellRenderer.tileCellSize.width - x - i.right, WebFileListCellRenderer.tileCellSize.height - i.top - i.bottom);
                }
                return new Rectangle(i.left, i.top, WebFileListCellRenderer.tileCellSize.width - 4 - 54 - i.right, WebFileListCellRenderer.tileCellSize.height - i.top - i.bottom);
            }
            int ny = i.top + 54 + 4;
            return new Rectangle(i.left, ny, WebFileListCellRenderer.iconCellSize.width - i.left - i.right, WebFileListCellRenderer.iconCellSize.height - ny - i.bottom);
        }
    }
}

