/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.painter;

import com.alee.extended.painter.AbstractPainter;
import com.alee.utils.SwingUtils;
import com.alee.utils.ninepatch.NinePatchIcon;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class NinePatchIconPainter<E extends JComponent>
extends AbstractPainter<E> {
    protected NinePatchIcon icon;

    public NinePatchIconPainter() {
        this((NinePatchIcon)null);
    }

    public NinePatchIconPainter(URL url) {
        this(new NinePatchIcon(url));
    }

    public NinePatchIconPainter(String iconSrc) {
        this(new NinePatchIcon(iconSrc));
    }

    public NinePatchIconPainter(ImageIcon imageIcon) {
        this(new NinePatchIcon(imageIcon));
    }

    public NinePatchIconPainter(Image image) {
        this(new NinePatchIcon(image));
    }

    public NinePatchIconPainter(BufferedImage bufferedImage) {
        this(new NinePatchIcon(bufferedImage));
    }

    public NinePatchIconPainter(NinePatchIcon icon) {
        this.icon = icon;
    }

    public NinePatchIcon getNinePatchIcon() {
        return this.icon;
    }

    public void setNinePatchIcon(NinePatchIcon icon) {
        this.icon = icon;
        this.updateAll();
    }

    @Override
    public Dimension getPreferredSize(E c) {
        if (this.icon != null) {
            this.icon.setComponent((Component)c);
            return this.icon.getPreferredSize();
        }
        return super.getPreferredSize(c);
    }

    @Override
    public Insets getMargin(E c) {
        Insets margin = super.getMargin(c);
        if (this.icon != null) {
            this.icon.setComponent((Component)c);
            return SwingUtils.max(margin, this.icon.getMargin());
        }
        return margin;
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c) {
        if (this.icon != null) {
            this.icon.setComponent((Component)c);
            this.icon.paintIcon((Component)c, g2d);
        }
    }
}

