/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.extended.tree.AbstractTreeTransferHandler;
import com.alee.extended.tree.AsyncTreeAdapter;
import com.alee.extended.tree.AsyncTreeModel;
import com.alee.extended.tree.AsyncTreeQueue;
import com.alee.extended.tree.AsyncUniqueNode;
import com.alee.extended.tree.WebAsyncTree;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;

public abstract class AsyncTreeTransferHandler<N extends AsyncUniqueNode, T extends WebAsyncTree<N>>
extends AbstractTreeTransferHandler<N, T, AsyncTreeModel<N>> {
    protected boolean allowUncheckedDrop = false;

    public boolean isAllowUncheckedDrop() {
        return this.allowUncheckedDrop;
    }

    public void setAllowUncheckedDrop(boolean allowUncheckedDrop) {
        this.allowUncheckedDrop = allowUncheckedDrop;
    }

    @Override
    protected boolean canDropTo(N dropLocation) {
        return super.canDropTo(dropLocation) && !((AsyncUniqueNode)dropLocation).isLoading() && !((AsyncUniqueNode)dropLocation).isFailed();
    }

    @Override
    protected void removeTreeNodes(T tree, List<N> nodesToRemove) {
        ((WebAsyncTree)tree).removeNodes(nodesToRemove);
    }

    @Override
    protected boolean prepareDropOperation(TransferHandler.TransferSupport support, List<N> nodes, int dropIndex, N parent, T tree, AsyncTreeModel<N> model) {
        if (this.allowUncheckedDrop) {
            if (((AsyncUniqueNode)parent).isLoaded()) {
                this.performDropOperation(nodes, parent, tree, model, this.getAdjustedDropIndex(dropIndex, support.getDropAction(), parent));
            } else {
                ((WebAsyncTree)tree).addAsyncTreeListener(new AsyncTreeAdapter((AsyncUniqueNode)parent, nodes, (WebAsyncTree)tree, model){
                    final /* synthetic */ AsyncUniqueNode val$parent;
                    final /* synthetic */ List val$nodes;
                    final /* synthetic */ WebAsyncTree val$tree;
                    final /* synthetic */ AsyncTreeModel val$model;
                    {
                        this.val$parent = asyncUniqueNode;
                        this.val$nodes = list;
                        this.val$tree = webAsyncTree;
                        this.val$model = asyncTreeModel;
                    }

                    @Override
                    public void childsLoadCompleted(AsyncUniqueNode loadedFor, List childs) {
                        if (loadedFor == this.val$parent) {
                            AsyncTreeTransferHandler.this.performDropOperation(this.val$nodes, this.val$parent, this.val$tree, this.val$model, this.val$parent.getChildCount());
                            this.val$tree.removeAsyncTreeListener(this);
                        }
                    }

                    @Override
                    public void childsLoadFailed(AsyncUniqueNode loadedFor, Throwable cause) {
                        if (loadedFor == this.val$parent) {
                            this.val$tree.removeAsyncTreeListener(this);
                        }
                    }
                });
                ((WebAsyncTree)tree).reloadNode(parent);
            }
            return true;
        }
        if (!((AsyncUniqueNode)parent).isLoaded()) {
            ((WebAsyncTree)tree).reloadNodeSync(parent);
        }
        return ((AsyncUniqueNode)parent).isLoaded() && this.performDropOperation(nodes, parent, tree, model, this.getAdjustedDropIndex(dropIndex, support.getDropAction(), parent));
    }

    @Override
    protected boolean performDropOperation(final List<N> nodes, N parent, T tree, final AsyncTreeModel<N> model, int index) {
        SwingUtilities.invokeLater(new Runnable((AsyncUniqueNode)parent, index, (WebAsyncTree)tree){
            final /* synthetic */ AsyncUniqueNode val$parent;
            final /* synthetic */ int val$index;
            final /* synthetic */ WebAsyncTree val$tree;
            {
                this.val$parent = asyncUniqueNode;
                this.val$index = n;
                this.val$tree = webAsyncTree;
            }

            @Override
            public void run() {
                model.insertNodesInto(nodes, this.val$parent, this.val$index);
                if (AsyncTreeTransferHandler.this.expandSingleNode && nodes.size() == 1) {
                    this.val$tree.expandNode((DefaultMutableTreeNode)nodes.get(0));
                } else if (AsyncTreeTransferHandler.this.expandMultiplyNodes) {
                    for (AsyncUniqueNode node : nodes) {
                        this.val$tree.expandNode(node);
                    }
                }
                this.val$tree.setSelectedNodes(nodes);
                AsyncTreeQueue.execute(this.val$tree, new Runnable(){

                    @Override
                    public void run() {
                        AsyncTreeTransferHandler.this.nodesDropped(nodes, val$parent, val$tree, model, val$index);
                    }
                });
            }
        });
        return true;
    }
}

