/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.window;

import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class ComponentMoveAdapter
extends MouseAdapter {
    protected Component toDrag;
    protected boolean dragging = false;
    protected Component dragged = null;
    protected Point initialPoint = null;
    protected Rectangle initialBounds = null;

    public static void install(Component component) {
        ComponentMoveAdapter.install(component, null);
    }

    public static void install(Component component, Component toDrag) {
        ComponentMoveAdapter wma = new ComponentMoveAdapter(toDrag);
        component.addMouseListener(wma);
        component.addMouseMotionListener(wma);
    }

    public ComponentMoveAdapter() {
        this(null);
    }

    public ComponentMoveAdapter(Component toDrag) {
        this.toDrag = toDrag;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            Rectangle dragStartBounds;
            this.dragged = this.getDraggedComponent(e);
            if (this.dragged != null && (dragStartBounds = this.getDragStartBounds(e)) != null && dragStartBounds.contains(e.getPoint())) {
                this.dragging = true;
                this.initialPoint = MouseInfo.getPointerInfo().getLocation();
                this.initialBounds = this.dragged.getBounds();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.dragging) {
            Point point = MouseInfo.getPointerInfo().getLocation();
            this.dragged.setLocation(this.initialBounds.x + (point.x - this.initialPoint.x), this.initialBounds.y + (point.y - this.initialPoint.y));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.dragging = false;
        this.dragged = null;
        this.initialPoint = null;
        this.initialBounds = null;
    }

    protected Component getDraggedComponent(MouseEvent e) {
        return this.toDrag == null ? SwingUtils.getWindowAncestor(e.getComponent()) : this.toDrag;
    }

    protected Rectangle getDragStartBounds(MouseEvent e) {
        return SwingUtils.size(e.getComponent());
    }
}

