/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.window;

import com.alee.extended.image.WebImage;
import com.alee.extended.painter.AlphaLayerPainter;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.rootpane.WebFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ImagePreviewFrame
extends WebFrame {
    public ImagePreviewFrame(String src) {
        this.initializeUI(new WebImage(src));
    }

    public ImagePreviewFrame(Class nearClass, String src) {
        this.initializeUI(new WebImage(nearClass, src));
    }

    public ImagePreviewFrame(URL url) {
        this.initializeUI(new WebImage(url));
    }

    public ImagePreviewFrame(Icon image) {
        this.initializeUI(new WebImage(image));
    }

    public ImagePreviewFrame(ImageIcon image) {
        this.initializeUI(new WebImage(image));
    }

    public ImagePreviewFrame(Image image) {
        this.initializeUI(new WebImage(image));
    }

    public ImagePreviewFrame(BufferedImage image) {
        this.initializeUI(new WebImage(image));
    }

    private void initializeUI(WebImage image) {
        this.setIconImages(WebLookAndFeel.getImages());
        this.setLayout(new BorderLayout());
        WebPanel area = new WebPanel(new AlphaLayerPainter());
        area.setMargin(Math.max(5, 80 - image.getWidth()));
        this.add(area);
        area.add((Component)image);
        this.setDefaultCloseOperation(3);
        this.setResizable(true);
        this.pack();
        this.center();
        this.setVisible(true);
    }
}

