/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.button;

import com.alee.extended.painter.Painter;
import com.alee.global.StyleConstants;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.button.WebButtonStyle;
import com.alee.laf.button.WebButtonUI;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.managers.hotkey.HotkeyInfo;
import com.alee.managers.hotkey.HotkeyManager;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.data.TooltipWay;
import com.alee.managers.language.updaters.LanguageUpdater;
import com.alee.managers.log.Log;
import com.alee.managers.tooltip.ToolTipMethods;
import com.alee.managers.tooltip.TooltipManager;
import com.alee.managers.tooltip.WebCustomTooltip;
import com.alee.utils.EventUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SizeUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.swing.EventMethods;
import com.alee.utils.swing.FocusEventRunnable;
import com.alee.utils.swing.FontMethods;
import com.alee.utils.swing.KeyEventRunnable;
import com.alee.utils.swing.MouseButton;
import com.alee.utils.swing.MouseEventRunnable;
import com.alee.utils.swing.SizeMethods;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;

public class WebButton
extends JButton
implements ShapeProvider,
EventMethods,
ToolTipMethods,
LanguageMethods,
FontMethods<WebButton>,
SizeMethods<WebButton> {
    public WebButton() {
    }

    public WebButton(Icon icon) {
        super(icon);
        this.setRound(WebButtonStyle.iconRound);
        this.setLeftRightSpacing(WebButtonStyle.iconLeftRightSpacing);
    }

    public WebButton(Icon icon, Icon rolloverIcon) {
        super(icon);
        this.setRolloverIcon(rolloverIcon);
        this.setRound(WebButtonStyle.iconRound);
        this.setLeftRightSpacing(WebButtonStyle.iconLeftRightSpacing);
    }

    public WebButton(String text) {
        super(text);
    }

    public WebButton(String text, Icon icon) {
        super(text, icon);
    }

    public WebButton(ActionListener listener) {
        this.addActionListener(listener);
    }

    public WebButton(Icon icon, ActionListener listener) {
        super(icon);
        this.setRound(WebButtonStyle.iconRound);
        this.setLeftRightSpacing(WebButtonStyle.iconLeftRightSpacing);
        this.addActionListener(listener);
    }

    public WebButton(String text, ActionListener listener) {
        super(text);
        this.addActionListener(listener);
    }

    public WebButton(String text, Icon icon, ActionListener listener) {
        super(text, icon);
        this.addActionListener(listener);
    }

    public WebButton(Action a) {
        super(a);
    }

    public WebButton(Painter painter) {
        this.setPainter(painter);
    }

    public HotkeyInfo addHotkey(Integer keyCode) {
        return this.addHotkey(new HotkeyData(keyCode));
    }

    public HotkeyInfo addHotkey(boolean isCtrl, boolean isAlt, boolean isShift, Integer keyCode) {
        return this.addHotkey(new HotkeyData(isCtrl, isAlt, isShift, keyCode));
    }

    public HotkeyInfo addHotkey(HotkeyData hotkeyData) {
        return HotkeyManager.registerHotkey(this, hotkeyData);
    }

    public HotkeyInfo addHotkey(HotkeyData hotkeyData, boolean hidden) {
        return HotkeyManager.registerHotkey((AbstractButton)this, hotkeyData, hidden);
    }

    public HotkeyInfo addHotkey(HotkeyData hotkeyData, TooltipWay tooltipWay) {
        return HotkeyManager.registerHotkey((AbstractButton)this, hotkeyData, tooltipWay);
    }

    public HotkeyInfo addHotkey(Component topComponent, HotkeyData hotkeyData) {
        return HotkeyManager.registerHotkey(topComponent, this, hotkeyData);
    }

    public HotkeyInfo addHotkey(Component topComponent, HotkeyData hotkeyData, boolean hidden) {
        return HotkeyManager.registerHotkey(topComponent, (AbstractButton)this, hotkeyData, hidden);
    }

    public HotkeyInfo addHotkey(Component topComponent, HotkeyData hotkeyData, TooltipWay tooltipWay) {
        return HotkeyManager.registerHotkey(topComponent, (AbstractButton)this, hotkeyData, tooltipWay);
    }

    public List<HotkeyInfo> getHotkeys() {
        return HotkeyManager.getComponentHotkeys(this);
    }

    public void removeHotkey(HotkeyInfo hotkeyInfo) {
        HotkeyManager.unregisterHotkey(hotkeyInfo);
    }

    public void removeHotkeys() {
        HotkeyManager.unregisterHotkeys(this);
    }

    public Color getTopBgColor() {
        return this.getWebUI().getTopBgColor();
    }

    public WebButton setTopBgColor(Color topBgColor) {
        this.getWebUI().setTopBgColor(topBgColor);
        return this;
    }

    public Color getBottomBgColor() {
        return this.getWebUI().getBottomBgColor();
    }

    public WebButton setBottomBgColor(Color bottomBgColor) {
        this.getWebUI().setBottomBgColor(bottomBgColor);
        return this;
    }

    public Color getTopSelectedBgColor() {
        return this.getWebUI().getTopSelectedBgColor();
    }

    public WebButton setTopSelectedBgColor(Color topSelectedBgColor) {
        this.getWebUI().setTopSelectedBgColor(topSelectedBgColor);
        return this;
    }

    public Color getBottomSelectedBgColor() {
        return this.getWebUI().getBottomSelectedBgColor();
    }

    public WebButton setBottomSelectedBgColor(Color bottomSelectedBgColor) {
        this.getWebUI().setBottomSelectedBgColor(bottomSelectedBgColor);
        return this;
    }

    public Color getSelectedForeground() {
        return this.getWebUI().getSelectedForeground();
    }

    public WebButton setSelectedForeground(Color selectedForeground) {
        this.getWebUI().setSelectedForeground(selectedForeground);
        return this;
    }

    public boolean isRolloverDarkBorderOnly() {
        return this.getWebUI().isRolloverDarkBorderOnly();
    }

    public WebButton setRolloverDarkBorderOnly(boolean rolloverDarkBorderOnly) {
        this.getWebUI().setRolloverDarkBorderOnly(rolloverDarkBorderOnly);
        return this;
    }

    public boolean isRolloverShine() {
        return this.getWebUI().isRolloverShine();
    }

    public WebButton setRolloverShine(boolean rolloverShine) {
        this.getWebUI().setRolloverShine(rolloverShine);
        return this;
    }

    public Color getShineColor() {
        return this.getWebUI().getShineColor();
    }

    public WebButton setShineColor(Color shineColor) {
        this.getWebUI().setShineColor(shineColor);
        return this;
    }

    public int getRound() {
        return this.getWebUI().getRound();
    }

    public WebButton setRound(int round) {
        this.getWebUI().setRound(round);
        return this;
    }

    public boolean isDrawShade() {
        return this.getWebUI().isDrawShade();
    }

    public WebButton setDrawShade(boolean drawShade) {
        this.getWebUI().setDrawShade(drawShade);
        return this;
    }

    public boolean isRolloverShadeOnly() {
        return this.getWebUI().isRolloverShadeOnly();
    }

    public WebButton setRolloverShadeOnly(boolean rolloverShadeOnly) {
        this.getWebUI().setRolloverShadeOnly(rolloverShadeOnly);
        return this;
    }

    public boolean isShowDisabledShade() {
        return this.getWebUI().isShowDisabledShade();
    }

    public WebButton setShowDisabledShade(boolean showDisabledShade) {
        this.getWebUI().setShowDisabledShade(showDisabledShade);
        return this;
    }

    public int getShadeWidth() {
        return this.getWebUI().getShadeWidth();
    }

    public WebButton setShadeWidth(int shadeWidth) {
        this.getWebUI().setShadeWidth(shadeWidth);
        return this;
    }

    public Color getShadeColor() {
        return this.getWebUI().getShadeColor();
    }

    public WebButton setShadeColor(Color shadeColor) {
        this.getWebUI().setShadeColor(shadeColor);
        return this;
    }

    public int getInnerShadeWidth() {
        return this.getWebUI().getInnerShadeWidth();
    }

    public WebButton setInnerShadeWidth(int innerShadeWidth) {
        this.getWebUI().setInnerShadeWidth(innerShadeWidth);
        return this;
    }

    public Color getInnerShadeColor() {
        return this.getWebUI().getInnerShadeColor();
    }

    public WebButton setInnerShadeColor(Color innerShadeColor) {
        this.getWebUI().setInnerShadeColor(innerShadeColor);
        return this;
    }

    public Color getDefaultButtonShadeColor() {
        return this.getWebUI().getDefaultButtonShadeColor();
    }

    public WebButton setDefaultButtonShadeColor(Color defaultButtonShadeColor) {
        this.getWebUI().setDefaultButtonShadeColor(defaultButtonShadeColor);
        return this;
    }

    public int getLeftRightSpacing() {
        return this.getWebUI().getLeftRightSpacing();
    }

    public WebButton setLeftRightSpacing(int leftRightSpacing) {
        this.getWebUI().setLeftRightSpacing(leftRightSpacing);
        return this;
    }

    public boolean isRolloverDecoratedOnly() {
        return this.getWebUI().isRolloverDecoratedOnly();
    }

    public WebButton setRolloverDecoratedOnly(boolean rolloverDecoratedOnly) {
        this.getWebUI().setRolloverDecoratedOnly(rolloverDecoratedOnly);
        return this;
    }

    public boolean isAnimate() {
        return this.getWebUI().isAnimate();
    }

    public WebButton setAnimate(boolean animate) {
        this.getWebUI().setAnimate(animate);
        return this;
    }

    public boolean isUndecorated() {
        return this.getWebUI().isUndecorated();
    }

    public WebButton setUndecorated(boolean undecorated) {
        this.getWebUI().setUndecorated(undecorated);
        return this;
    }

    public Painter getPainter() {
        return this.getWebUI().getPainter();
    }

    public WebButton setPainter(Painter painter) {
        this.getWebUI().setPainter(painter);
        return this;
    }

    public boolean isMoveIconOnPress() {
        return this.getWebUI().isMoveIconOnPress();
    }

    public WebButton setMoveIconOnPress(boolean moveIconOnPress) {
        this.getWebUI().setMoveIconOnPress(moveIconOnPress);
        return this;
    }

    public boolean isDrawFocus() {
        return this.getWebUI().isDrawFocus();
    }

    public WebButton setDrawFocus(boolean drawFocus) {
        this.getWebUI().setDrawFocus(drawFocus);
        return this;
    }

    public boolean isDrawBottom() {
        return this.getWebUI().isDrawBottom();
    }

    public WebButton setDrawBottom(boolean drawBottom) {
        this.getWebUI().setDrawBottom(drawBottom);
        return this;
    }

    public boolean isDrawLeft() {
        return this.getWebUI().isDrawLeft();
    }

    public WebButton setDrawLeft(boolean drawLeft) {
        this.getWebUI().setDrawLeft(drawLeft);
        return this;
    }

    public boolean isDrawRight() {
        return this.getWebUI().isDrawRight();
    }

    public WebButton setDrawRight(boolean drawRight) {
        this.getWebUI().setDrawRight(drawRight);
        return this;
    }

    public boolean isDrawTop() {
        return this.getWebUI().isDrawTop();
    }

    public WebButton setDrawTop(boolean drawTop) {
        this.getWebUI().setDrawTop(drawTop);
        return this;
    }

    public WebButton setDrawSides(boolean top, boolean left, boolean bottom, boolean right) {
        this.getWebUI().setDrawSides(top, left, bottom, right);
        return this;
    }

    public boolean isDrawTopLine() {
        return this.getWebUI().isDrawTopLine();
    }

    public WebButton setDrawTopLine(boolean drawTopLine) {
        this.getWebUI().setDrawTopLine(drawTopLine);
        return this;
    }

    public boolean isDrawLeftLine() {
        return this.getWebUI().isDrawLeftLine();
    }

    public WebButton setDrawLeftLine(boolean drawLeftLine) {
        this.getWebUI().setDrawLeftLine(drawLeftLine);
        return this;
    }

    public boolean isDrawBottomLine() {
        return this.getWebUI().isDrawBottomLine();
    }

    public WebButton setDrawBottomLine(boolean drawBottomLine) {
        this.getWebUI().setDrawBottomLine(drawBottomLine);
        return this;
    }

    public boolean isDrawRightLine() {
        return this.getWebUI().isDrawRightLine();
    }

    public WebButton setDrawRightLine(boolean drawRightLine) {
        this.getWebUI().setDrawRightLine(drawRightLine);
        return this;
    }

    public WebButton setDrawLines(boolean top, boolean left, boolean bottom, boolean right) {
        this.getWebUI().setDrawLines(top, left, bottom, right);
        return this;
    }

    @Override
    public Insets getMargin() {
        return this.getWebUI().getMargin();
    }

    @Override
    public void setMargin(Insets margin) {
        this.getWebUI().setMargin(margin);
    }

    public WebButton setMargin(int top, int left, int bottom, int right) {
        this.setMargin(new Insets(top, left, bottom, right));
        return this;
    }

    public WebButton setMargin(int spacing) {
        return this.setMargin(spacing, spacing, spacing, spacing);
    }

    @Override
    public Shape provideShape() {
        return this.getWebUI().provideShape();
    }

    public WebButtonUI getWebUI() {
        return (WebButtonUI)this.getUI();
    }

    @Override
    public void updateUI() {
        if (this.getUI() == null || !(this.getUI() instanceof WebButtonUI)) {
            try {
                this.setUI((WebButtonUI)ReflectUtils.createInstance(WebLookAndFeel.buttonUI, new Object[0]));
            }
            catch (Throwable e) {
                Log.error((Object)this, e);
                this.setUI(new WebButtonUI());
            }
        } else {
            this.setUI(this.getUI());
        }
    }

    @Override
    public MouseAdapter onMousePress(MouseEventRunnable runnable) {
        return EventUtils.onMousePress(this, runnable);
    }

    @Override
    public MouseAdapter onMousePress(MouseButton mouseButton, MouseEventRunnable runnable) {
        return EventUtils.onMousePress(this, mouseButton, runnable);
    }

    @Override
    public MouseAdapter onMouseEnter(MouseEventRunnable runnable) {
        return EventUtils.onMouseEnter(this, runnable);
    }

    @Override
    public MouseAdapter onMouseExit(MouseEventRunnable runnable) {
        return EventUtils.onMouseExit(this, runnable);
    }

    @Override
    public MouseAdapter onMouseDrag(MouseEventRunnable runnable) {
        return EventUtils.onMouseDrag(this, runnable);
    }

    @Override
    public MouseAdapter onMouseDrag(MouseButton mouseButton, MouseEventRunnable runnable) {
        return EventUtils.onMouseDrag(this, mouseButton, runnable);
    }

    @Override
    public MouseAdapter onMouseClick(MouseEventRunnable runnable) {
        return EventUtils.onMouseClick(this, runnable);
    }

    @Override
    public MouseAdapter onMouseClick(MouseButton mouseButton, MouseEventRunnable runnable) {
        return EventUtils.onMouseClick(this, mouseButton, runnable);
    }

    @Override
    public MouseAdapter onDoubleClick(MouseEventRunnable runnable) {
        return EventUtils.onDoubleClick(this, runnable);
    }

    @Override
    public MouseAdapter onMenuTrigger(MouseEventRunnable runnable) {
        return EventUtils.onMenuTrigger(this, runnable);
    }

    @Override
    public KeyAdapter onKeyType(KeyEventRunnable runnable) {
        return EventUtils.onKeyType(this, runnable);
    }

    @Override
    public KeyAdapter onKeyType(HotkeyData hotkey, KeyEventRunnable runnable) {
        return EventUtils.onKeyType(this, hotkey, runnable);
    }

    @Override
    public KeyAdapter onKeyPress(KeyEventRunnable runnable) {
        return EventUtils.onKeyPress(this, runnable);
    }

    @Override
    public KeyAdapter onKeyPress(HotkeyData hotkey, KeyEventRunnable runnable) {
        return EventUtils.onKeyPress(this, hotkey, runnable);
    }

    @Override
    public KeyAdapter onKeyRelease(KeyEventRunnable runnable) {
        return EventUtils.onKeyRelease(this, runnable);
    }

    @Override
    public KeyAdapter onKeyRelease(HotkeyData hotkey, KeyEventRunnable runnable) {
        return EventUtils.onKeyRelease(this, hotkey, runnable);
    }

    @Override
    public FocusAdapter onFocusGain(FocusEventRunnable runnable) {
        return EventUtils.onFocusGain(this, runnable);
    }

    @Override
    public FocusAdapter onFocusLoss(FocusEventRunnable runnable) {
        return EventUtils.onFocusLoss(this, runnable);
    }

    @Override
    public WebCustomTooltip setToolTip(String tooltip) {
        return TooltipManager.setTooltip((Component)this, tooltip);
    }

    @Override
    public WebCustomTooltip setToolTip(Icon icon, String tooltip) {
        return TooltipManager.setTooltip((Component)this, icon, tooltip);
    }

    @Override
    public WebCustomTooltip setToolTip(String tooltip, TooltipWay tooltipWay) {
        return TooltipManager.setTooltip((Component)this, tooltip, tooltipWay);
    }

    @Override
    public WebCustomTooltip setToolTip(Icon icon, String tooltip, TooltipWay tooltipWay) {
        return TooltipManager.setTooltip((Component)this, icon, tooltip, tooltipWay);
    }

    @Override
    public WebCustomTooltip setToolTip(String tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.setTooltip((Component)this, tooltip, tooltipWay, delay);
    }

    @Override
    public WebCustomTooltip setToolTip(Icon icon, String tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.setTooltip(this, icon, tooltip, tooltipWay, delay);
    }

    @Override
    public WebCustomTooltip setToolTip(JComponent tooltip) {
        return TooltipManager.setTooltip((Component)this, tooltip);
    }

    @Override
    public WebCustomTooltip setToolTip(JComponent tooltip, int delay) {
        return TooltipManager.setTooltip((Component)this, tooltip, delay);
    }

    @Override
    public WebCustomTooltip setToolTip(JComponent tooltip, TooltipWay tooltipWay) {
        return TooltipManager.setTooltip((Component)this, tooltip, tooltipWay);
    }

    @Override
    public WebCustomTooltip setToolTip(JComponent tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.setTooltip((Component)this, tooltip, tooltipWay, delay);
    }

    @Override
    public WebCustomTooltip addToolTip(String tooltip) {
        return TooltipManager.addTooltip((Component)this, tooltip);
    }

    @Override
    public WebCustomTooltip addToolTip(Icon icon, String tooltip) {
        return TooltipManager.addTooltip((Component)this, icon, tooltip);
    }

    @Override
    public WebCustomTooltip addToolTip(String tooltip, TooltipWay tooltipWay) {
        return TooltipManager.addTooltip((Component)this, tooltip, tooltipWay);
    }

    @Override
    public WebCustomTooltip addToolTip(Icon icon, String tooltip, TooltipWay tooltipWay) {
        return TooltipManager.addTooltip((Component)this, icon, tooltip, tooltipWay);
    }

    @Override
    public WebCustomTooltip addToolTip(String tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.addTooltip((Component)this, tooltip, tooltipWay, delay);
    }

    @Override
    public WebCustomTooltip addToolTip(Icon icon, String tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.addTooltip((Component)this, icon, tooltip, tooltipWay, delay);
    }

    @Override
    public WebCustomTooltip addToolTip(JComponent tooltip) {
        return TooltipManager.addTooltip((Component)this, tooltip);
    }

    @Override
    public WebCustomTooltip addToolTip(JComponent tooltip, int delay) {
        return TooltipManager.addTooltip((Component)this, tooltip, delay);
    }

    @Override
    public WebCustomTooltip addToolTip(JComponent tooltip, TooltipWay tooltipWay) {
        return TooltipManager.addTooltip((Component)this, tooltip, tooltipWay);
    }

    @Override
    public WebCustomTooltip addToolTip(JComponent tooltip, TooltipWay tooltipWay, int delay) {
        return TooltipManager.addTooltip((Component)this, tooltip, tooltipWay, delay);
    }

    @Override
    public void removeToolTip(WebCustomTooltip tooltip) {
        TooltipManager.removeTooltip(this, tooltip);
    }

    @Override
    public void removeToolTips() {
        TooltipManager.removeTooltips(this);
    }

    @Override
    public void removeToolTips(WebCustomTooltip ... tooltips) {
        TooltipManager.removeTooltips((Component)this, tooltips);
    }

    @Override
    public void removeToolTips(List<WebCustomTooltip> tooltips) {
        TooltipManager.removeTooltips((Component)this, tooltips);
    }

    @Override
    public void setLanguage(String key, Object ... data) {
        LanguageManager.registerComponent(this, key, data);
    }

    @Override
    public void updateLanguage(Object ... data) {
        LanguageManager.updateComponent((JComponent)this, data);
    }

    @Override
    public void updateLanguage(String key, Object ... data) {
        LanguageManager.updateComponent((JComponent)this, key, data);
    }

    @Override
    public void removeLanguage() {
        LanguageManager.unregisterComponent(this);
    }

    @Override
    public boolean isLanguageSet() {
        return LanguageManager.isRegisteredComponent(this);
    }

    @Override
    public void setLanguageUpdater(LanguageUpdater updater) {
        LanguageManager.registerLanguageUpdater(this, updater);
    }

    @Override
    public void removeLanguageUpdater() {
        LanguageManager.unregisterLanguageUpdater(this);
    }

    @Override
    public WebButton setPlainFont() {
        return SwingUtils.setPlainFont(this);
    }

    @Override
    public WebButton setPlainFont(boolean apply) {
        return SwingUtils.setPlainFont(this, apply);
    }

    @Override
    public boolean isPlainFont() {
        return SwingUtils.isPlainFont(this);
    }

    @Override
    public WebButton setBoldFont() {
        return SwingUtils.setBoldFont(this);
    }

    @Override
    public WebButton setBoldFont(boolean apply) {
        return SwingUtils.setBoldFont(this, apply);
    }

    @Override
    public boolean isBoldFont() {
        return SwingUtils.isBoldFont(this);
    }

    @Override
    public WebButton setItalicFont() {
        return SwingUtils.setItalicFont(this);
    }

    @Override
    public WebButton setItalicFont(boolean apply) {
        return SwingUtils.setItalicFont(this, apply);
    }

    @Override
    public boolean isItalicFont() {
        return SwingUtils.isItalicFont(this);
    }

    @Override
    public WebButton setFontStyle(boolean bold, boolean italic) {
        return SwingUtils.setFontStyle(this, bold, italic);
    }

    @Override
    public WebButton setFontStyle(int style) {
        return SwingUtils.setFontStyle(this, style);
    }

    @Override
    public WebButton setFontSize(int fontSize) {
        return SwingUtils.setFontSize(this, fontSize);
    }

    @Override
    public WebButton changeFontSize(int change) {
        return SwingUtils.changeFontSize(this, change);
    }

    @Override
    public int getFontSize() {
        return SwingUtils.getFontSize(this);
    }

    @Override
    public WebButton setFontSizeAndStyle(int fontSize, boolean bold, boolean italic) {
        return SwingUtils.setFontSizeAndStyle(this, fontSize, bold, italic);
    }

    @Override
    public WebButton setFontSizeAndStyle(int fontSize, int style) {
        return SwingUtils.setFontSizeAndStyle(this, fontSize, style);
    }

    @Override
    public WebButton setFontName(String fontName) {
        return SwingUtils.setFontName(this, fontName);
    }

    @Override
    public String getFontName() {
        return SwingUtils.getFontName(this);
    }

    @Override
    public int getPreferredWidth() {
        return SizeUtils.getPreferredWidth(this);
    }

    @Override
    public WebButton setPreferredWidth(int preferredWidth) {
        return SizeUtils.setPreferredWidth(this, preferredWidth);
    }

    @Override
    public int getPreferredHeight() {
        return SizeUtils.getPreferredHeight(this);
    }

    @Override
    public WebButton setPreferredHeight(int preferredHeight) {
        return SizeUtils.setPreferredHeight(this, preferredHeight);
    }

    @Override
    public int getMinimumWidth() {
        return SizeUtils.getMinimumWidth(this);
    }

    @Override
    public WebButton setMinimumWidth(int minimumWidth) {
        return SizeUtils.setMinimumWidth(this, minimumWidth);
    }

    @Override
    public int getMinimumHeight() {
        return SizeUtils.getMinimumHeight(this);
    }

    @Override
    public WebButton setMinimumHeight(int minimumHeight) {
        return SizeUtils.setMinimumHeight(this, minimumHeight);
    }

    @Override
    public int getMaximumWidth() {
        return SizeUtils.getMaximumWidth(this);
    }

    @Override
    public WebButton setMaximumWidth(int maximumWidth) {
        return SizeUtils.setMaximumWidth(this, maximumWidth);
    }

    @Override
    public int getMaximumHeight() {
        return SizeUtils.getMaximumHeight(this);
    }

    @Override
    public WebButton setMaximumHeight(int maximumHeight) {
        return SizeUtils.setMaximumHeight(this, maximumHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        return SizeUtils.getPreferredSize(this, super.getPreferredSize());
    }

    @Override
    public WebButton setPreferredSize(int width, int height) {
        return SizeUtils.setPreferredSize(this, width, height);
    }

    public static WebButton createIconWebButton(ImageIcon imageIcon) {
        return WebButton.createIconWebButton(imageIcon, StyleConstants.smallRound);
    }

    public static WebButton createIconWebButton(ImageIcon imageIcon, int round) {
        return WebButton.createIconWebButton(imageIcon, round, StyleConstants.shadeWidth);
    }

    public static WebButton createIconWebButton(ImageIcon imageIcon, int round, int shadeWidth) {
        return WebButton.createIconWebButton(imageIcon, round, shadeWidth, StyleConstants.innerShadeWidth);
    }

    public static WebButton createIconWebButton(ImageIcon imageIcon, int round, int shadeWidth, int innerShadeWidth) {
        return WebButton.createIconWebButton(imageIcon, round, shadeWidth, innerShadeWidth, StyleConstants.rolloverDecoratedOnly);
    }

    public static WebButton createIconWebButton(ImageIcon imageIcon, boolean rolloverDecoratedOnly) {
        return WebButton.createIconWebButton(imageIcon, StyleConstants.smallRound, rolloverDecoratedOnly);
    }

    public static WebButton createIconWebButton(ImageIcon imageIcon, int round, boolean rolloverDecoratedOnly) {
        return WebButton.createIconWebButton(imageIcon, round, StyleConstants.shadeWidth, StyleConstants.innerShadeWidth, rolloverDecoratedOnly, StyleConstants.undecorated);
    }

    public static WebButton createIconWebButton(ImageIcon imageIcon, int round, int shadeWidth, int innerShadeWidth, boolean rolloverDecoratedOnly) {
        return WebButton.createIconWebButton(imageIcon, round, shadeWidth, innerShadeWidth, rolloverDecoratedOnly, StyleConstants.undecorated);
    }

    public static WebButton createIconWebButton(ImageIcon imageIcon, int round, int shadeWidth, int innerShadeWidth, boolean rolloverDecoratedOnly, boolean undecorated) {
        return WebButton.createIconWebButton(imageIcon, round, shadeWidth, innerShadeWidth, rolloverDecoratedOnly, undecorated, true);
    }

    public static WebButton createIconWebButton(ImageIcon imageIcon, int round, int shadeWidth, int innerShadeWidth, boolean rolloverDecoratedOnly, boolean undecorated, boolean drawFocus) {
        WebButton iconWebButton = WebButton.createWebButton(round, shadeWidth, innerShadeWidth, 0, rolloverDecoratedOnly, undecorated, drawFocus);
        iconWebButton.setIcon(imageIcon);
        return iconWebButton;
    }

    public static WebButton createWebButton(int round, int shadeWidth, int innerShadeWidth, int leftRightSpacing, boolean rolloverDecoratedOnly, boolean undecorated, boolean drawFocus) {
        WebButton webButton = new WebButton();
        webButton.setRound(round);
        webButton.setShadeWidth(shadeWidth);
        webButton.setInnerShadeWidth(innerShadeWidth);
        webButton.setLeftRightSpacing(leftRightSpacing);
        webButton.setRolloverDecoratedOnly(rolloverDecoratedOnly);
        webButton.setUndecorated(undecorated);
        webButton.setDrawFocus(drawFocus);
        return webButton;
    }
}

